/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.configs;

import com.jetbrains.launcher.InitException;
import com.jetbrains.launcher.configs.AgentFacadeFactory;
import com.jetbrains.launcher.configs.BaseLauncherConfig;
import com.jetbrains.launcher.configs.LauncherCmdConfig;
import com.jetbrains.launcher.configs.LauncherConfigEx;
import com.jetbrains.launcher.configs.LauncherConfigValidator;
import com.jetbrains.launcher.util.CmdUtil;
import com.jetbrains.launcher.util.FileUtil;
import com.jetbrains.launcher.util.LauncherUtil;
import com.jetbrains.launcher.util.StringUtil;
import java.io.File;
import java.util.List;
import java.util.Properties;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LauncherCmdConfigImpl
extends BaseLauncherConfig
implements LauncherCmdConfig {
    @Nullable
    private final String[] myConfigureCommand;
    @NotNull
    private final String[] myStartCommand;
    @NotNull
    private final String[] myStatusCommand;
    @NotNull
    private final String[] myStopCommand;
    @NotNull
    private final String[] myStopSoftCommand;

    private LauncherCmdConfigImpl(@Nullable String[] configureCommand, @NotNull String[] startCommand, @NotNull String[] statusCommand, @NotNull String[] stopCommand, @NotNull String[] stopSoftCommand) {
        if (startCommand == null) {
            LauncherCmdConfigImpl.$$$reportNull$$$0(0);
        }
        if (statusCommand == null) {
            LauncherCmdConfigImpl.$$$reportNull$$$0(1);
        }
        if (stopCommand == null) {
            LauncherCmdConfigImpl.$$$reportNull$$$0(2);
        }
        if (stopSoftCommand == null) {
            LauncherCmdConfigImpl.$$$reportNull$$$0(3);
        }
        this.myConfigureCommand = configureCommand;
        this.myStartCommand = startCommand;
        this.myStatusCommand = statusCommand;
        this.myStopCommand = stopCommand;
        this.myStopSoftCommand = stopSoftCommand;
    }

    public void validate(@NotNull LauncherConfigValidator validator) throws InitException {
        if (validator == null) {
            LauncherCmdConfigImpl.$$$reportNull$$$0(4);
        }
        validator.validateCmdConfig((LauncherCmdConfig)this);
    }

    @NotNull
    public <T> T createAgentFacade(@NotNull AgentFacadeFactory<T> factory) {
        if (factory == null) {
            LauncherCmdConfigImpl.$$$reportNull$$$0(5);
        }
        Object object = factory.createCmdAgent((LauncherCmdConfig)this);
        if (object == null) {
            LauncherCmdConfigImpl.$$$reportNull$$$0(6);
        }
        return (T)object;
    }

    @Nullable
    public String[] getConfigureCommand() {
        return this.myConfigureCommand;
    }

    @NotNull
    public String[] getStartCommand() {
        if (this.myStartCommand == null) {
            LauncherCmdConfigImpl.$$$reportNull$$$0(7);
        }
        return this.myStartCommand;
    }

    @NotNull
    public String[] getStatusCommand() {
        if (this.myStatusCommand == null) {
            LauncherCmdConfigImpl.$$$reportNull$$$0(8);
        }
        return this.myStatusCommand;
    }

    @NotNull
    public String[] getStopCommand() {
        if (this.myStopCommand == null) {
            LauncherCmdConfigImpl.$$$reportNull$$$0(9);
        }
        return this.myStopCommand;
    }

    @NotNull
    public String[] getStopSoftCommand() {
        if (this.myStopSoftCommand == null) {
            LauncherCmdConfigImpl.$$$reportNull$$$0(10);
        }
        return this.myStopSoftCommand;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startCommand";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusCommand";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopCommand";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopSoftCommand";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/configs/LauncherCmdConfigImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/configs/LauncherCmdConfigImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createAgentFacade";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getStartCommand";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusCommand";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getStopCommand";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getStopSoftCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createAgentFacade";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Parser
    extends BaseLauncherConfig.BaseParser {
        @Override
        @NotNull
        protected String getConfigFileName() {
            if ("launcher.cmd.config" == null) {
                Parser.$$$reportNull$$$0(0);
            }
            return "launcher.cmd.config";
        }

        @Override
        public boolean isJavaApplication() {
            return false;
        }

        @Override
        @NotNull
        protected LauncherConfigEx doParseConfig(@NotNull BaseLauncherConfig.BaseParser.ParserContext context) throws InitException {
            if (context == null) {
                Parser.$$$reportNull$$$0(1);
            }
            File binFolder = context.getAppFixedFiles().getAppBinFolder();
            Properties properties = context.getProperties();
            String stopCommand = context.checkProperty("stop.command");
            String stopSoftCommand = properties.getProperty("stop.soft.command");
            LauncherCmdConfigImpl launcherCmdConfigImpl = new LauncherCmdConfigImpl(this.prepareCommand(binFolder, properties.getProperty("configure.command"), "configure.command", false), this.prepareCommand(binFolder, context.checkProperty("start.command"), "start.command", true), this.prepareCommand(binFolder, context.checkProperty("status.command"), "status.command", true), this.prepareCommand(binFolder, stopCommand, "stop.command", true), this.prepareCommand(binFolder, stopSoftCommand == null ? stopCommand : stopSoftCommand, "stop.soft.command", true));
            if (launcherCmdConfigImpl == null) {
                Parser.$$$reportNull$$$0(2);
            }
            return launcherCmdConfigImpl;
        }

        @Contract(value="_, null, _, _ -> null; _, !null, _, true -> !null")
        private String[] prepareCommand(@NotNull File binFolder, @Nullable String command, @NotNull String commandName, boolean mandatory) throws InitException {
            if (binFolder == null) {
                Parser.$$$reportNull$$$0(3);
            }
            if (commandName == null) {
                Parser.$$$reportNull$$$0(4);
            }
            if (command == null) {
                return null;
            }
            List parsedCmdLine = CmdUtil.parseCommandLine((String)command);
            if (parsedCmdLine.isEmpty()) {
                if (!mandatory) {
                    return null;
                }
                throw new InitException("Command \"" + commandName + "\" is empty");
            }
            File originalProgram = FileUtil.resolvePath((File)binFolder, (String)((String)parsedCmdLine.get(0)));
            List<String> cmdLine = LauncherUtil.findCommand(originalProgram);
            if (cmdLine == null) {
                throw new InitException("Bad \"" + commandName + "\" command: program \"" + originalProgram.getAbsolutePath() + "\" is not found");
            }
            cmdLine.addAll(parsedCmdLine.subList(1, parsedCmdLine.size()));
            return StringUtil.toStringArray(cmdLine);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/launcher/configs/LauncherCmdConfigImpl$Parser";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "binFolder";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commandName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConfigFileName";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/launcher/configs/LauncherCmdConfigImpl$Parser";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doParseConfig";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "doParseConfig";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "prepareCommand";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

