/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.ep.commands;

import com.jetbrains.launcher.AppConfigFilesEx;
import com.jetbrains.launcher.AppFiles;
import com.jetbrains.launcher.AppFilesEx;
import com.jetbrains.launcher.AppFixedFiles;
import com.jetbrains.launcher.AppName;
import com.jetbrains.launcher.Arguments;
import com.jetbrains.launcher.CoreArguments;
import com.jetbrains.launcher.InitException;
import com.jetbrains.launcher.LauncherArgumentsParser;
import com.jetbrains.launcher.LauncherContext;
import com.jetbrains.launcher.LauncherContextEx;
import com.jetbrains.launcher.LauncherContextFactory;
import com.jetbrains.launcher.LauncherCoreContext;
import com.jetbrains.launcher.LauncherCoreContextFactory;
import com.jetbrains.launcher.LauncherExitCode;
import com.jetbrains.launcher.LogLevel;
import com.jetbrains.launcher.UserMessageTransformer;
import com.jetbrains.launcher.configs.AppConfig;
import com.jetbrains.launcher.ep.Command;
import com.jetbrains.launcher.ep.commands.Usage;
import com.jetbrains.launcher.lock.AppLockFactory;
import com.jetbrains.launcher.log.LogInitializer;
import com.jetbrains.launcher.log.LoggerMode;
import com.jetbrains.launcher.log.SafeLogger;
import com.jetbrains.launcher.plugins.PluginManager;
import com.jetbrains.launcher.util.JavaUtil;
import com.jetbrains.launcher.util.ManifestUtil;
import com.jetbrains.launcher.util.ProcessUtil;
import com.jetbrains.launcher.util.RuntimeUtil;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseCommand
implements Command {
    @NotNull
    private final SafeLogger LOG = new SafeLogger(Logger.getLogger(BaseCommand.class));

    @NotNull
    public String getFullName() {
        String string = this.getName();
        if (string == null) {
            BaseCommand.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getOrderId() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public Command.CommandType getType(@NotNull Arguments args) {
        if (args == null) {
            BaseCommand.$$$reportNull$$$0(1);
        }
        Command.CommandType commandType = Command.CommandType.USER_COMMAND;
        if (commandType == null) {
            BaseCommand.$$$reportNull$$$0(2);
        }
        return commandType;
    }

    public boolean isAvailable(@NotNull Arguments args) {
        if (args == null) {
            BaseCommand.$$$reportNull$$$0(3);
        }
        return true;
    }

    @Nullable
    public Command findSubCommand(@NotNull String subCommandName, @NotNull Arguments args) {
        if (subCommandName == null) {
            BaseCommand.$$$reportNull$$$0(4);
        }
        if (args == null) {
            BaseCommand.$$$reportNull$$$0(5);
        }
        return null;
    }

    @NotNull
    public LauncherExitCode run(@NotNull Arguments args) {
        LauncherExitCode launcherExitCode;
        if (args == null) {
            BaseCommand.$$$reportNull$$$0(6);
        }
        BaseCommand actualCommand = this.getActualCommand(args);
        try {
            launcherExitCode = BaseCommand.runCommand(actualCommand, args);
        }
        catch (IllegalArgumentException e) {
            LauncherExitCode launcherExitCode2;
            try {
                this.LOG.safeError(e.getMessage());
                this.LOG.safeDebug("Wrong arguments: " + Arrays.toString(args.getCmdLine()));
                launcherExitCode2 = BaseCommand.runCommand(new Usage(actualCommand, null, true), args);
            }
            catch (InitException e2) {
                this.LOG.safeInitError(e2);
                LauncherExitCode launcherExitCode3 = LauncherExitCode.ERROR;
                if (launcherExitCode3 == null) {
                    BaseCommand.$$$reportNull$$$0(9);
                }
                return launcherExitCode3;
            }
            if (launcherExitCode2 == null) {
                BaseCommand.$$$reportNull$$$0(8);
            }
            return launcherExitCode2;
        }
        if (launcherExitCode == null) {
            BaseCommand.$$$reportNull$$$0(7);
        }
        return launcherExitCode;
    }

    @NotNull
    private static LauncherExitCode runCommand(@NotNull BaseCommand command, @NotNull Arguments args) throws InitException {
        if (command == null) {
            BaseCommand.$$$reportNull$$$0(10);
        }
        if (args == null) {
            BaseCommand.$$$reportNull$$$0(11);
        }
        LauncherExitCode launcherExitCode = command.doRun(BaseCommand.initLauncherContext(command, args));
        if (launcherExitCode == null) {
            BaseCommand.$$$reportNull$$$0(12);
        }
        return launcherExitCode;
    }

    @NotNull
    private static LauncherContextEx initLauncherContext(@NotNull BaseCommand command, @NotNull Arguments args) throws InitException {
        if (command == null) {
            BaseCommand.$$$reportNull$$$0(13);
        }
        if (args == null) {
            BaseCommand.$$$reportNull$$$0(14);
        }
        AppConfigFilesEx appConfigFiles = LauncherContextFactory.createAppConfigFiles(args.getAppFixedFiles());
        int appConfigHash = appConfigFiles.getAppConfigHash();
        AppConfig appConfig = LauncherContextFactory.createAppConfig(appConfigFiles);
        AppFilesEx appFiles = LauncherContextFactory.createAppFiles(appConfigFiles, appConfig);
        AppName appName = appConfig.getAppName();
        RuntimeUtil.addRuntimeReplacements((AppFixedFiles)appFiles, (AppName)appName);
        File launcherLogsFolder = command.getLauncherLogsFolder(args, appConfig, (AppFiles)appFiles);
        if (command.readsFromOrWritesToLogsFolder()) {
            BaseCommand.checkInstance(launcherLogsFolder, (AppFixedFiles)appFiles);
        }
        command.initLogs(args, (AppFixedFiles)appFiles, launcherLogsFolder, true);
        Logger log = Logger.getLogger(command.getClass());
        log.debug((Object)("JetLauncher process ID: " + ProcessUtil.getCurrentPidDescription()));
        log.debug((Object)UserMessageTransformer.transform((String)("Using Java: " + JavaUtil.getCurrentJavaHomePath() + " (version \"" + JavaUtil.getCurrentJavaVersion() + "\")")));
        log.debug((Object)(appName.getCapitalizedName() + " home directory: " + appFiles.getAppHome().getAbsolutePath()));
        log.debug((Object)("Command line: " + Arrays.toString(args.getCmdLine())));
        log.debug((Object)UserMessageTransformer.transform((String)("JetLauncher logs directory: " + launcherLogsFolder.getAbsolutePath())));
        log.debug((Object)("JetLauncher version: " + BaseCommand.getLauncherVersion()));
        log.debug((Object)("Loaded launcher plugins: " + PluginManager.getInstance().getPluginNames()));
        log.debug((Object)UserMessageTransformer.transform((String)(appName.getCapitalizedName() + " config folder: " + appConfigFiles.getAppConfFolder().getAbsolutePath())));
        LauncherCoreContext coreContext = LauncherCoreContextFactory.createCoreContext((CoreArguments)args);
        LauncherContextEx launcherContextEx = LauncherContextFactory.createContext(args, coreContext, appConfig, appFiles, appConfigHash);
        if (launcherContextEx == null) {
            BaseCommand.$$$reportNull$$$0(15);
        }
        return launcherContextEx;
    }

    @NotNull
    private static String getLauncherVersion() {
        String string;
        try {
            string = ManifestUtil.getVersion();
        }
        catch (IOException e) {
            String string2 = "Unknown (" + e + ")";
            if (string2 == null) {
                BaseCommand.$$$reportNull$$$0(17);
            }
            return string2;
        }
        if (string == null) {
            BaseCommand.$$$reportNull$$$0(16);
        }
        return string;
    }

    protected void initLogs(@NotNull LauncherContext context) throws InitException {
        if (context == null) {
            BaseCommand.$$$reportNull$$$0(18);
        }
        AppFilesEx appFiles = context.getAppFiles();
        this.initLogs(context.getArguments(), (AppFixedFiles)appFiles, appFiles.getLauncherLogsFolder(), false);
    }

    private void initLogs(@NotNull Arguments args, @NotNull AppFixedFiles appFixedFiles, @NotNull File launcherLogsFolder, boolean firstCommand) throws InitException {
        if (args == null) {
            BaseCommand.$$$reportNull$$$0(19);
        }
        if (appFixedFiles == null) {
            BaseCommand.$$$reportNull$$$0(20);
        }
        if (launcherLogsFolder == null) {
            BaseCommand.$$$reportNull$$$0(21);
        }
        LogInitializer.init((AppFixedFiles)appFixedFiles, (File)launcherLogsFolder, (LoggerMode)this.getLoggerMode(args), (LogLevel)args.getLogLevel(), (String)this.getLogPrefix(), (boolean)firstCommand);
    }

    @NotNull
    protected File getLauncherLogsFolder(@NotNull Arguments args, @NotNull AppConfig appConfig, @NotNull AppFiles appFiles) {
        if (args == null) {
            BaseCommand.$$$reportNull$$$0(22);
        }
        if (appConfig == null) {
            BaseCommand.$$$reportNull$$$0(23);
        }
        if (appFiles == null) {
            BaseCommand.$$$reportNull$$$0(24);
        }
        File file = appFiles.getLauncherLogsFolder();
        if (file == null) {
            BaseCommand.$$$reportNull$$$0(25);
        }
        return file;
    }

    protected boolean readsFromOrWritesToLogsFolder() {
        return true;
    }

    private static void checkInstance(@NotNull File launcherLogsFolder, @NotNull AppFixedFiles appFixedFiles) throws InitException {
        if (launcherLogsFolder == null) {
            BaseCommand.$$$reportNull$$$0(26);
        }
        if (appFixedFiles == null) {
            BaseCommand.$$$reportNull$$$0(27);
        }
        RuntimeUtil.createDirIfNeededAndCheckItIsWritable((File)launcherLogsFolder, (String)"logs directory");
        File launcherHome = AppLockFactory.createLockChecker(launcherLogsFolder).getLauncherHome();
        if (launcherHome != null && !launcherHome.equals(appFixedFiles.getAppHome())) {
            throw new InitException("The specified launcher logs directory (" + launcherLogsFolder.getAbsolutePath() + ") is already in use by another running application: " + launcherHome.getAbsolutePath());
        }
    }

    @NotNull
    protected BaseCommand getActualCommand(@NotNull Arguments args) {
        if (args == null) {
            BaseCommand.$$$reportNull$$$0(28);
        }
        BaseCommand baseCommand = this;
        if (baseCommand == null) {
            BaseCommand.$$$reportNull$$$0(29);
        }
        return baseCommand;
    }

    @Nullable
    public LauncherArgumentsParser.State next(@NotNull String arg) {
        if (arg == null) {
            BaseCommand.$$$reportNull$$$0(30);
        }
        HashSet<String> possibleArgs = new HashSet<String>();
        this.collectPossibleArgs(possibleArgs);
        return new PossibleArgumentsBasedLauncherArgumentsParserState(possibleArgs).next(arg);
    }

    protected void collectPossibleArgs(@NotNull Set<String> possibleArgs) {
        if (possibleArgs == null) {
            BaseCommand.$$$reportNull$$$0(31);
        }
    }

    @NotNull
    protected abstract LoggerMode getLoggerMode(@NotNull Arguments var1);

    @Nullable
    protected String getLogPrefix() {
        return "[" + this.getFullName() + "] ";
    }

    @NotNull
    public final LauncherExitCode reinitLogsAndDoRun(@NotNull LauncherContextEx context) throws InitException {
        if (context == null) {
            BaseCommand.$$$reportNull$$$0(32);
        }
        this.initLogs(context);
        LauncherExitCode launcherExitCode = this.doRun(context);
        if (launcherExitCode == null) {
            BaseCommand.$$$reportNull$$$0(33);
        }
        return launcherExitCode;
    }

    @NotNull
    protected abstract LauncherExitCode doRun(@NotNull LauncherContextEx var1) throws InitException;

    public void printStandaloneUsage(@NotNull Command.UsagePrinter printer, @NotNull LauncherContext context) {
        if (printer == null) {
            BaseCommand.$$$reportNull$$$0(34);
        }
        if (context == null) {
            BaseCommand.$$$reportNull$$$0(35);
        }
        this.printUsage(printer, context);
    }

    @NotNull
    protected String getComplexCommandUsageText() {
        String string = "call \"help " + this.getFullName() + "\" for details";
        if (string == null) {
            BaseCommand.$$$reportNull$$$0(36);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/ep/commands/BaseCommand";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 11: 
            case 14: 
            case 19: 
            case 22: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subCommandName";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 18: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 20: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appFixedFiles";
                break;
            }
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launcherLogsFolder";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appConfig";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appFiles";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arg";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleArgs";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullName";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/ep/commands/BaseCommand";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "run";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "runCommand";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "initLauncherContext";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getLauncherVersion";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getLauncherLogsFolder";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualCommand";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "reinitLogsAndDoRun";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getComplexCommandUsageText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findSubCommand";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "runCommand";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "initLauncherContext";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "initLogs";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getLauncherLogsFolder";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "checkInstance";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getActualCommand";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "next";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "collectPossibleArgs";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "reinitLogsAndDoRun";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "printStandaloneUsage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PossibleArgumentsBasedLauncherArgumentsParserState
    implements LauncherArgumentsParser.State {
        @NotNull
        private final Set<String> myPossibleArgs;

        private PossibleArgumentsBasedLauncherArgumentsParserState(@NotNull Set<String> possibleArgs) {
            if (possibleArgs == null) {
                PossibleArgumentsBasedLauncherArgumentsParserState.$$$reportNull$$$0(0);
            }
            this.myPossibleArgs = possibleArgs;
        }

        @Nullable
        public LauncherArgumentsParser.State next(@NotNull String arg) {
            if (arg == null) {
                PossibleArgumentsBasedLauncherArgumentsParserState.$$$reportNull$$$0(1);
            }
            return this.myPossibleArgs.remove(arg) ? this : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "possibleArgs";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arg";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/launcher/ep/commands/BaseCommand$PossibleArgumentsBasedLauncherArgumentsParserState";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "next";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

