/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.service.util;

import com.jetbrains.service.util.SystemUtil;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.List;

public class ServiceUtil {
    private static final int SOCKET_CONNECTION_TIMEOUT = Integer.getInteger("bundle.check.socket.connection.timeout", 300);
    public static final String ADDRESS_ANY_IPV4 = "0.0.0.0";

    public static boolean isPortAvailable(String listenAddress, int port, boolean reuseAddress) {
        if (!ServiceUtil.canListenOn(listenAddress, port, reuseAddress)) {
            return false;
        }
        if (listenAddress.equals(ADDRESS_ANY_IPV4)) {
            return !ServiceUtil.canConnectToLocalPort(port);
        }
        return !ServiceUtil.canConnectTo(listenAddress, port);
    }

    public static boolean canConnectTo(String address, int port) {
        if (SystemUtil.isWindows()) {
            return ServiceUtil.canConnectTo(address, port, SOCKET_CONNECTION_TIMEOUT);
        }
        return ServiceUtil.canConnectTo(address, port, 0);
    }

    public static boolean canConnectToLocalPort(int port) {
        return ServiceUtil.canConnectTo("127.0.0.1", port);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean canConnectTo(String address, int port, int timeout) {
        try (Socket sock = new Socket();){
            sock.connect(new InetSocketAddress(address, port), timeout);
            boolean bl = true;
            return bl;
        }
        catch (Throwable e) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean canListenOn(String address, int port, boolean reuseAddress) {
        try (ServerSocket serverSocket = new ServerSocket();){
            serverSocket.setReuseAddress(reuseAddress);
            serverSocket.bind(new InetSocketAddress(address, port));
            boolean bl = true;
            return bl;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static boolean getAndFilterArgument(List<String> args, String arg) {
        if (args.contains(arg)) {
            args.remove(arg);
            return true;
        }
        return false;
    }
}

