/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.service.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class Version
implements Comparable<Version> {
    private final List<Integer> myVersionParts;

    public Version(List<Integer> versionParts) {
        this.myVersionParts = Collections.unmodifiableList(versionParts);
    }

    public boolean isGreaterOrEqual(@NotNull Version otherVersion) {
        return this.compareTo(otherVersion) >= 0;
    }

    public boolean isGreater(@NotNull Version otherVersion) {
        return this.compareTo(otherVersion) > 0;
    }

    public boolean isLesser(@NotNull Version otherVersion) {
        return !this.isGreaterOrEqual(otherVersion);
    }

    public boolean isLesserOrEqual(@NotNull Version otherVersion) {
        return !this.isGreater(otherVersion);
    }

    public boolean isEqual(@NotNull Version otherVersion) {
        return this.compareTo(otherVersion) == 0;
    }

    public Version toMajorMinorVersion() {
        return this.myVersionParts.size() >= 2 ? new Version(Arrays.asList(this.myVersionParts.get(0), this.myVersionParts.get(1))) : null;
    }

    public boolean isGreaterOrEqual(@NotNull String otherVersion) {
        Version parsedOtherVersion = Version.parseVersion(otherVersion);
        return parsedOtherVersion == null || this.compareTo(parsedOtherVersion) >= 0;
    }

    public boolean isGreater(@NotNull String otherVersion) {
        Version parsedOtherVersion = Version.parseVersion(otherVersion);
        return parsedOtherVersion == null || this.compareTo(parsedOtherVersion) > 0;
    }

    public boolean isLesser(@NotNull String otherVersion) {
        return !this.isGreaterOrEqual(otherVersion);
    }

    public boolean isLesserOrEqual(@NotNull String otherVersion) {
        return !this.isGreater(otherVersion);
    }

    public boolean isEqual(@NotNull String otherVersion) {
        Version parsedOtherVersion = Version.parseVersion(otherVersion);
        return parsedOtherVersion != null && this.compareTo(parsedOtherVersion) == 0;
    }

    public List<Integer> getVersionParts() {
        return this.myVersionParts;
    }

    @Override
    public int compareTo(@NotNull Version o) {
        int iterationsCount = Math.min(this.myVersionParts.size(), o.myVersionParts.size());
        for (int i = 0; i < iterationsCount; ++i) {
            if (this.myVersionParts.get(i).equals(o.myVersionParts.get(i))) continue;
            return this.myVersionParts.get(i) - o.myVersionParts.get(i);
        }
        return this.myVersionParts.size() - o.myVersionParts.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Integer part : this.myVersionParts) {
            if (sb.length() != 0) {
                sb.append(".");
            }
            sb.append(part);
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Version)) {
            return false;
        }
        Version version = (Version)o;
        return this.myVersionParts != null ? this.isEqual(version) : version.myVersionParts == null;
    }

    public int hashCode() {
        if (this.myVersionParts == null) {
            return 0;
        }
        int result = 0;
        for (Integer part : this.myVersionParts) {
            result = 31 * result + (part != null ? part : 0);
        }
        return result;
    }

    public static Version parseVersion(String version) {
        if (version == null) {
            return null;
        }
        Version result = null;
        String[] parts = version.trim().split(Pattern.quote("."));
        if (parts.length >= 2) {
            try {
                ArrayList<Integer> list = new ArrayList<Integer>();
                for (String part : parts) {
                    int intValue = Integer.parseInt(part);
                    if (intValue < 0) {
                        return null;
                    }
                    list.add(intValue);
                }
                result = new Version(list);
            }
            catch (NumberFormatException ignore) {
                result = null;
            }
        }
        return result;
    }
}

