/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.service.util;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public enum BundleProperty {
    BASE_URL("base-url"),
    DATA_DIR("data-dir"),
    TEMP_DIR("temp-dir"),
    LOGS_DIR("logs-dir"),
    BACKUPS_DIR("backups-dir"),
    ROOT_PASSWORD("root-password"),
    ROOT_USER("root-user"),
    LISTEN_PORT("listen-port"),
    LISTEN_ADDRESS("listen-address"),
    LOCALE("locale"),
    INSTALLATION_UUID("installation-uuid"),
    CURRENT_PRODUCT_VERSION("current-product-version", true),
    PREVIOUSLY_STARTED_PRODUCT_VERSION("previously-started-product-version"),
    PRODUCT_VERSION("product-version"),
    INSTALLATION_DIR("installation-dir", true),
    HUB_URL("hub-url"),
    ALLOW_ANONYMOUS_ACCESS("allow-anonymous-access"),
    STATISTICS_UPLOAD("statistics-upload"),
    ADDITIONAL_KEYSTORE_PATH("additional-keystore-path", true),
    ADDITIONAL_KEYSTORE_PASSWORD("additional-keystore-password"),
    ADDITIONAL_KEYSTORE_HUB_KEY_PASSWORD("additional-keystore-hub-key-password"),
    BACKEND_API_TOKEN("backend-api-token", true),
    SECURE_MODE("secure-mode"),
    TLS_REDIRECT_FROM_HTTP_FLAG("tls-redirect-from-http"),
    TLS_REDIRECT_FROM_HTTP_LISTEN_PORT("tls-redirect-from-http-listen-port"),
    TLS_SERVER_CERT_STORAGE_TYPE("tls-server-cert-storage-type"),
    TLS_SERVER_CERT_PRIVATE_KEY_PASSPHRASE("tls-server-cert-private-key-passphrase"),
    TLS_SERVER_CERT_KEYSTORE_KEY_ALIAS("tls-server-cert-keystore-key-alias"),
    TLS_SERVER_CERT_KEYSTORE_KEY_PASSWORD("tls-server-cert-keystore-key-password"),
    TLS_SERVER_CERT_KEYSTORE_PASSWORD("tls-server-cert-keystore-password"),
    TLS_SERVER_CERT_FOLDER("tls-server-cert-folder"),
    TLS_CIPHER_SUITE("tls-cipher-suites"),
    TLS_EXCLUDE_CIPHER_SUITE("tls-exclude-cipher-suites"),
    TLS_PROTOCOLS("tls-protocols"),
    TLS_EXCLUDE_PROTOCOLS("tls-exclude-protocols"),
    ENTROPY_CHECK_FLAG("entropy-check");

    public static final String BUNDLE_PREFIX = "bundle.";
    private final String myName;
    private final boolean myIsComputable;
    private static final Map<String, BundleProperty> shortNameToProperty;

    private BundleProperty(String name) {
        this(name, false);
    }

    private BundleProperty(String name, boolean isComputable) {
        this.myName = name;
        this.myIsComputable = isComputable;
    }

    public String getName() {
        return this.myName;
    }

    public String getPrefixedName() {
        return BUNDLE_PREFIX + this.myName;
    }

    public static boolean isBundleProperty(String propertyName) {
        String shortName = propertyName.startsWith(BUNDLE_PREFIX) ? propertyName.substring(BUNDLE_PREFIX.length(), propertyName.length()) : propertyName;
        return shortNameToProperty.containsKey(shortName) || PropertyPart.isKnownProperty(shortName);
    }

    public static BundleProperty getSimplePropertyByName(String propertyName) {
        String shortName = propertyName.startsWith(BUNDLE_PREFIX) ? propertyName.substring(BUNDLE_PREFIX.length(), propertyName.length()) : propertyName;
        return shortNameToProperty.get(shortName);
    }

    public static String constructDisableServiceProperty(@NotNull String serviceId) {
        return BundleProperty.constructDisableServiceProperty(serviceId, true);
    }

    public static String constructDisableServiceProperty(@NotNull String serviceId, boolean prefixed) {
        return BundleProperty.constructServiceSpecificProperty(serviceId, PropertyPart.DISABLE, prefixed);
    }

    public static String constructPortBaseServiceProperty(@NotNull String serviceId) {
        return BundleProperty.constructServiceSpecificProperty(serviceId, PropertyPart.PORT_BASE, true);
    }

    public static String constructPortBaseServiceProperty(@NotNull String serviceId, boolean prefixed) {
        return BundleProperty.constructServiceSpecificProperty(serviceId, PropertyPart.PORT_BASE, prefixed);
    }

    private static String constructServiceSpecificProperty(@NotNull String serviceId, @NotNull PropertyPart part, boolean prefixed) {
        return part.getProperty(serviceId, prefixed);
    }

    public boolean isComputable() {
        return this.myIsComputable;
    }

    static {
        shortNameToProperty = new HashMap<String, BundleProperty>();
        for (BundleProperty property : BundleProperty.values()) {
            shortNameToProperty.put(property.getName(), property);
        }
    }

    private static enum PropertyPart {
        DISABLE("disable."),
        PORT_BASE("port-base.");

        private final String value;

        public String getProperty(@NotNull String serviceId, boolean prefixed) {
            return (prefixed ? BundleProperty.BUNDLE_PREFIX : "") + this.value + serviceId;
        }

        private PropertyPart(String part) {
            this.value = part;
        }

        static boolean isKnownProperty(@NotNull String propertyName) {
            for (PropertyPart part : PropertyPart.values()) {
                if (!propertyName.startsWith(part.value)) continue;
                return true;
            }
            return false;
        }
    }
}

