/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.service.util;

import com.jetbrains.service.util.SortedProperties;
import com.jetbrains.service.util.StatusException;
import com.jetbrains.service.util.properties.impl.PropertiesBasedConfigurationHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfiguratorUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static Properties loadPropertiesFile(@NotNull File configPath) {
        if (!Files.isReadable(configPath.toPath())) {
            throw new StatusException("Could not find properties file " + configPath);
        }
        try (FileInputStream is = new FileInputStream(configPath);){
            Properties properties = new Properties();
            properties.load(is);
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException e) {
            throw new StatusException("Error reading properties file " + configPath + ": " + e.getMessage());
        }
    }

    public static void savePropertiesFile(@NotNull File configPath, @NotNull Properties properties) {
        ConfiguratorUtils.savePropertiesFile(configPath, properties, "DO NOT change property values. \nThese properties are generated by Bundle application and will be rewritten on the next Bundle configure/start ");
    }

    public static void savePropertiesFile(@NotNull File configPath, @NotNull Properties properties, @Nullable String comments) {
        SortedProperties sortedProperties = new SortedProperties();
        sortedProperties.putAll((Map<?, ?>)properties);
        File parentDir = configPath.getParentFile();
        if (parentDir != null) {
            parentDir.mkdirs();
        }
        try (FileOutputStream os = new FileOutputStream(configPath);){
            sortedProperties.store(os, comments);
        }
        catch (IOException e) {
            throw new StatusException("Error saving properties file " + configPath + ": " + e.getMessage());
        }
    }

    @NotNull
    public static Properties processConfiguratorArguments(List<String> args) {
        Properties result = new Properties();
        int i = 0;
        while (i < args.size()) {
            String value;
            String arg;
            if ((arg = args.get(i++)).startsWith("--")) {
                if (arg.contains("=")) {
                    String[] split = arg.substring(2).split("=", 2);
                    result.put(split[0], split[1]);
                    continue;
                }
                if (i >= args.size() || arg.length() < 3) {
                    throw new StatusException("Expected value as next argument for argument: " + arg);
                }
                value = args.get(i++);
                result.put(arg.substring(2), value);
                continue;
            }
            if (arg.equals("-f")) {
                if (i >= args.size()) {
                    throw new StatusException("Expected path to file as next argument after '-f'");
                }
                value = args.get(i++);
                File file = new File(value);
                Properties properties = ConfiguratorUtils.loadPropertiesFile(file);
                for (String opt : properties.stringPropertyNames()) {
                    result.setProperty(opt, properties.getProperty(opt));
                }
                continue;
            }
            if (arg.startsWith("-J")) continue;
            throw new StatusException("Unexpected argument: " + arg);
        }
        return result;
    }

    @NotNull
    public static Collection<String> getServices(@NotNull Properties properties) {
        return PropertiesBasedConfigurationHelper.getHelper().getServices(properties);
    }

    @NotNull
    public static Collection<String> getBundledInProcessServices(@NotNull Properties properties, @NotNull String groupServiceId) {
        return PropertiesBasedConfigurationHelper.getHelper().getBundledInProcessServices(properties, groupServiceId);
    }

    @NotNull
    public static Set<String> getAllBundleServiceContainers(@NotNull Properties properties) {
        return PropertiesBasedConfigurationHelper.getHelper().getAllBundleServiceContainers(properties);
    }

    @NotNull
    public static Map<String, String> getAllBundledServices(@NotNull Properties properties) {
        return PropertiesBasedConfigurationHelper.getHelper().getAllBundledServices(properties);
    }

    @Nullable
    public static String getServiceProperty(@NotNull Properties allProperties, String serviceId, @NotNull String propertyName) {
        return PropertiesBasedConfigurationHelper.getHelper().getServiceProperty(allProperties, serviceId, propertyName);
    }

    @NotNull
    public static String getMandatoryServiceProperty(@NotNull Properties allProperties, String serviceName, @NotNull String propertyName) {
        return PropertiesBasedConfigurationHelper.getHelper().getMandatoryServiceProperty(allProperties, serviceName, propertyName);
    }

    @NotNull
    public static String getMandatoryServiceProperty(@NotNull Properties allProperties, @NotNull String propertyName) {
        return PropertiesBasedConfigurationHelper.getHelper().getMandatoryServiceProperty(allProperties, propertyName);
    }

    @NotNull
    public static String constructServicePrefix(@NotNull String serviceId) {
        return PropertiesBasedConfigurationHelper.getHelper().constructServicePrefix(serviceId);
    }

    @NotNull
    public static String getPrefixedPropertyName(@NotNull String serviceId, @NotNull String propertyName) {
        return PropertiesBasedConfigurationHelper.getHelper().getPrefixedPropertyName(serviceId, propertyName);
    }

    public static String parseServiceIdPrefix(@NotNull String propertyName) {
        return PropertiesBasedConfigurationHelper.getHelper().parseServiceIdPrefix(propertyName);
    }

    public static void setServiceProperty(@NotNull Properties allProperties, @NotNull String serviceId, @NotNull String propertyName, @NotNull String propertyValue) {
        PropertiesBasedConfigurationHelper.getHelper().setServiceProperty(allProperties, serviceId, propertyName, propertyValue);
    }

    @NotNull
    public static String getServiceInternalBaseUrl(@NotNull Properties allProperties, @NotNull String serviceId) {
        return PropertiesBasedConfigurationHelper.getHelper().getServiceInternalBaseUrl(allProperties, serviceId);
    }

    @NotNull
    public static Map<String, String> getAllServicesContexts(@NotNull Properties properties) {
        return PropertiesBasedConfigurationHelper.getHelper().getAllServicesContexts(properties);
    }

    public static String randomAlphanumeric(int count) {
        if (count == 0) {
            return "";
        }
        if (count < 0) {
            throw new IllegalArgumentException("Requested random string length " + count + " is less than 0.");
        }
        int start = 32;
        int end = 123;
        Random random = new Random();
        char[] buffer = new char[count];
        int gap = end - start;
        while (count-- != 0) {
            char ch = (char)(random.nextInt(gap) + start);
            if (Character.isLetter(ch) || Character.isDigit(ch)) {
                buffer[count] = ch;
                continue;
            }
            ++count;
        }
        return new String(buffer);
    }

    @NotNull
    public static String join(@NotNull Collection<String> strings, @NotNull String separator) {
        StringBuilder builder = new StringBuilder();
        Iterator<String> it = strings.iterator();
        if (it.hasNext()) {
            builder.append(it.next());
            while (it.hasNext()) {
                builder.append(separator);
                builder.append(it.next());
            }
        }
        return builder.toString();
    }

    public static void copyProperties(@NotNull Properties fromProperties, @NotNull Properties toProperties) {
        Enumeration<?> names = fromProperties.propertyNames();
        while (names.hasMoreElements()) {
            Object key = names.nextElement();
            toProperties.put(key, fromProperties.get(key));
        }
    }
}

