/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.service.util;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeleteFileVisitor
extends SimpleFileVisitor<Path> {
    private final Collection<Path> exclusions;

    public DeleteFileVisitor() {
        this(null);
    }

    public DeleteFileVisitor(@Nullable Collection<Path> exclusions) {
        this.exclusions = exclusions;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        if (this.exclusions == null || !this.exclusions.contains(file)) {
            Files.delete(file);
        }
        return super.visitFile(file, attrs);
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        if (this.exclusions != null && this.exclusions.contains(dir)) {
            return FileVisitResult.SKIP_SUBTREE;
        }
        return super.preVisitDirectory(dir, attrs);
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
        if (DeleteFileVisitor.isEmptyDirectory(dir)) {
            Files.delete(dir);
        }
        return super.postVisitDirectory(dir, exc);
    }

    private static boolean isEmptyDirectory(@NotNull Path dir) throws IOException {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            boolean bl = !stream.iterator().hasNext();
            return bl;
        }
    }
}

