/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.service.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public class LocaleUtil {
    public static final String LOCALE_DELIMITER = ",";

    @NotNull
    public static Collection<Locale> parseLocales(String localeListAsString) {
        ArrayList<Locale> resultList = new ArrayList<Locale>();
        if (localeListAsString != null) {
            String[] locales;
            for (String locale : locales = localeListAsString.trim().split(LOCALE_DELIMITER)) {
                if (locale.trim().isEmpty()) continue;
                resultList.add(Locale.forLanguageTag(locale.trim()));
            }
        }
        return resultList;
    }

    @NotNull
    public static String toLocaleString(@NotNull Collection<Locale> locales) {
        StringBuilder sb = new StringBuilder();
        if (!locales.isEmpty()) {
            for (Locale locale : locales) {
                if (sb.length() > 0) {
                    sb.append(LOCALE_DELIMITER);
                }
                sb.append(locale.toLanguageTag());
            }
        }
        return sb.toString();
    }
}

