/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.service.util.cmd;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class InterruptableInputStream
extends InputStream {
    private final InputStream myInput;
    private final AtomicBoolean myInterruptFlag;

    public InterruptableInputStream(InputStream input, AtomicBoolean interruptFlag) {
        this.myInput = input;
        this.myInterruptFlag = interruptFlag;
    }

    @Override
    public int read() throws IOException {
        this.waitForInput();
        return this.myInput.read();
    }

    @Override
    public int read(@NotNull byte[] buf, int offset, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        this.waitForInput();
        return this.myInput.read(buf, offset, Math.min(len, this.getAvailableBytes()));
    }

    private void waitForInput() throws IOException {
        while (true) {
            if (this.myInterruptFlag.get()) {
                throw new InterruptedIOException();
            }
            int available = this.getAvailableBytes();
            if (available != 0) break;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
        }
    }

    private int getAvailableBytes() throws IOException {
        try {
            return this.myInput.available();
        }
        catch (Throwable t) {
            return -1;
        }
    }

    @Override
    public int available() throws IOException {
        return this.myInput.available();
    }
}

