/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.service.util.contract;

import com.jetbrains.service.util.contract.BundleContractViolationException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public class ServiceConfLocationResolver {
    public static final String SERVICE_CONF_LOCATION_FILE_NAME = "service.conf.location";

    public static File resolve(@NotNull File serviceHome) throws BundleContractViolationException {
        File serviceConfLocationFile = new File(serviceHome, SERVICE_CONF_LOCATION_FILE_NAME);
        if (!serviceConfLocationFile.exists()) {
            throw new BundleContractViolationException(String.format("Conf location file [%s] doesn't exist", serviceConfLocationFile));
        }
        try {
            String confLocation = new String(Files.readAllBytes(serviceConfLocationFile.toPath()), "UTF-8");
            Path confLocationPath = Paths.get(confLocation, new String[0]);
            if (!confLocationPath.isAbsolute()) {
                confLocationPath = serviceHome.toPath().resolve(confLocationPath);
            }
            File confDirectory = confLocationPath.toFile();
            confDirectory.mkdirs();
            if (!confDirectory.isDirectory()) {
                throw new BundleContractViolationException(String.format("Invalid directory [%s] is set to conf location in [%s]", confLocation, serviceConfLocationFile));
            }
            return confDirectory;
        }
        catch (IOException e) {
            throw new BundleContractViolationException(String.format("Can not obtain config path stored in %s", serviceConfLocationFile), e);
        }
    }

    public File resolve(@NotNull Properties properties) throws BundleContractViolationException {
        String serviceHomeValue = properties.getProperty("service-folder-in-bundle");
        if (serviceHomeValue == null) {
            throw new BundleContractViolationException(String.format("Service properties does not contain %s", "service-folder-in-bundle"));
        }
        File serviceHome = new File(serviceHomeValue);
        return ServiceConfLocationResolver.resolve(serviceHome);
    }
}

