/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.service.util.contract.callbacks.impl.log4j;

import com.jetbrains.service.util.contract.callbacks.Callback;
import com.jetbrains.service.util.logging.log4j.LoggingUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServiceCallbackBase
implements Callback {
    @Override
    public final void perform(@NotNull Map<String, Object> parameters) {
        this.initLogging(parameters);
        this.doPerform(parameters);
        this.getLogger().debug(String.format("%s finished executing", this.getClass().getName()));
    }

    protected abstract void doPerform(@NotNull Map<String, Object> var1);

    protected final Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }

    private void initLogging(@NotNull Map<String, Object> parameters) {
        if (!this.shouldSkipLoggingInit(parameters)) {
            boolean isDebugEnabled = Boolean.valueOf((String)parameters.get("jetbrains.debug.enabled"));
            try {
                LoggingUtil.setupConsoleLogging(isDebugEnabled);
            }
            catch (Throwable t) {
                this.getLogger().debug(String.format("Failed to configure logging subsystem: %s", t.getMessage()));
            }
        }
    }

    private boolean shouldSkipLoggingInit(@NotNull Map<String, Object> parameters) {
        Boolean skipLoggingInitializationFlag = (Boolean)parameters.get("skip.default.logging.initialization");
        return Boolean.TRUE.equals(skipLoggingInitializationFlag);
    }
}

