/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.service.util.properties;

import com.jetbrains.service.util.BundleProperty;
import com.jetbrains.service.util.SecureMode;
import com.jetbrains.service.util.StatusException;
import com.jetbrains.service.util.UrlUtil;
import com.jetbrains.service.util.contract.UniqueConstraintViolationException;
import com.jetbrains.service.util.properties.adapters.PropertySourceAdapter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServiceConfigurationHelper<T> {
    public static final String UNKNOWN_SERVICE_VERSION = "unknown";
    private final PropertySourceAdapter<T> myPropertySourceAdapter;

    public ServiceConfigurationHelper(@NotNull PropertySourceAdapter<T> propertySourceAdapter) {
        this.myPropertySourceAdapter = propertySourceAdapter;
    }

    @NotNull
    public final String constructServicePrefix(@NotNull String serviceId) {
        return "service." + serviceId + ".";
    }

    @NotNull
    public final String getPrefixedPropertyName(@NotNull String serviceId, @NotNull String propertyName) {
        return this.constructServicePrefix(serviceId) + propertyName;
    }

    @Nullable
    public final String parseServiceIdPrefix(@NotNull String propertyName) {
        String[] nameSplit = propertyName.split(Pattern.quote("."), 3);
        if (nameSplit.length == 3 && "service".equals(nameSplit[0])) {
            return nameSplit[0] + "." + nameSplit[1] + ".";
        }
        return null;
    }

    @NotNull
    public final Collection<String> getServices(@NotNull T properties) {
        return this.getServices(properties, true);
    }

    @NotNull
    public final Collection<String> getServices(@NotNull T properties, boolean skipDisabled) {
        HashSet<String> services = new HashSet<String>();
        for (String name : this.stringPropertyNames(properties)) {
            String[] nameSplit = name.split("\\.", 3);
            if (nameSplit.length != 3 || !"service".equals(nameSplit[0])) continue;
            services.add(nameSplit[1]);
        }
        if (skipDisabled) {
            this.removeDisabledServices(properties, services);
        }
        return services;
    }

    @NotNull
    public final Collection<String> getBundledInProcessServices(@NotNull T properties, @NotNull String groupServiceId) {
        return this.getBundledInProcessServices(properties, groupServiceId, true);
    }

    @NotNull
    public final Collection<String> getBundledInProcessServices(@NotNull T properties, @NotNull String groupServiceId, boolean skipDisabled) {
        Map<String, String> allBundlesServices = this.getAllBundledServices(properties);
        HashSet<String> services = new HashSet<String>();
        for (String serviceId : allBundlesServices.keySet()) {
            if (!groupServiceId.equals(allBundlesServices.get(serviceId))) continue;
            services.add(serviceId);
        }
        if (skipDisabled) {
            this.removeDisabledServices(properties, services);
        }
        return services;
    }

    @NotNull
    public final Set<String> getAllBundleServiceContainers(@NotNull T properties) {
        return this.getAllBundleServiceContainers(properties, true);
    }

    @NotNull
    public final Set<String> getAllBundleServiceContainers(@NotNull T properties, boolean skipDisabled) {
        Map<String, String> allBundledServices = this.getAllBundledServices(properties, skipDisabled);
        return new HashSet<String>(allBundledServices.values());
    }

    @NotNull
    public final Map<String, String> getAllBundledServices(@NotNull T properties) {
        return this.getAllBundledServices(properties, true);
    }

    @NotNull
    public final Map<String, String> getAllBundledServices(@NotNull T properties, boolean skipDisabled) {
        return this.getServicesPropertyValue(properties, "bundledin", skipDisabled);
    }

    @Nullable
    public final String getServiceProperty(@NotNull T allProperties, String serviceId, @NotNull String propertyName) {
        if (serviceId == null) {
            throw new IllegalStateException("serviceId is mandatory parameter");
        }
        String thisServiceId = this.get("id", allProperties);
        String value = thisServiceId != null && thisServiceId.equals(serviceId) ? this.get(propertyName, allProperties) : this.get(this.getPrefixedPropertyName(serviceId, propertyName), allProperties);
        return value;
    }

    @Nullable
    public final String getServiceProperty(@NotNull T allProperties, @NotNull String propertyName) {
        String thisServiceId = this.get("id", allProperties);
        return this.getServiceProperty(allProperties, thisServiceId, propertyName);
    }

    @NotNull
    public final String getMandatoryServiceProperty(@NotNull T allProperties, String serviceName, @NotNull String propertyName) {
        String value = this.getServiceProperty(allProperties, serviceName, propertyName);
        this.checkNotNullProperty(value, propertyName);
        return value;
    }

    @NotNull
    public final String getMandatoryServiceProperty(@NotNull T allProperties, @NotNull String propertyName) {
        String thisServiceId = this.get("id", allProperties);
        return this.getMandatoryServiceProperty(allProperties, thisServiceId, propertyName);
    }

    public final void setServiceProperty(@NotNull T allProperties, @NotNull String serviceId, @NotNull String propertyName, @NotNull String propertyValue) {
        String thisServiceId = this.get("id", allProperties);
        if (thisServiceId != null && thisServiceId.equals(serviceId)) {
            this.set(propertyName, propertyValue, allProperties);
        } else {
            this.set(this.getPrefixedPropertyName(serviceId, propertyName), propertyValue, allProperties);
        }
    }

    @NotNull
    public final String getServiceInternalBaseUrl(@NotNull T allProperties, @NotNull String serviceId) {
        String bundledIn;
        if (!this.isServiceEnabled(allProperties, serviceId)) {
            throw new StatusException(String.format("Attempt to get internal URL of disabled service '%s'", serviceId));
        }
        String secureMode = this.getServiceProperty(allProperties, BundleProperty.SECURE_MODE.getPrefixedName());
        if (secureMode != null && !secureMode.equals(SecureMode.DISABLE.getName()) && "bundleProcess".equals(bundledIn = this.getServiceProperty(allProperties, serviceId, "bundledin"))) {
            return this.getMandatoryServiceProperty(allProperties, serviceId, "base-url");
        }
        int listenPort = Integer.parseInt(this.getMandatoryServiceProperty(allProperties, serviceId, "port"));
        String host = this.getMandatoryServiceProperty(allProperties, serviceId, "host");
        String context = this.getMandatoryServiceProperty(allProperties, serviceId, "context");
        return UrlUtil.constructUrl("http", host, listenPort, context);
    }

    @NotNull
    public final String getBundleInternalBaseUrl(@NotNull T allProperties) {
        return this.getServiceInternalBaseUrl(allProperties, "bundleProcess");
    }

    @NotNull
    public final String getInternalHubUrl(@NotNull T allProperties) {
        String url;
        try {
            url = this.getServiceInternalBaseUrl(allProperties, "hub");
        }
        catch (StatusException e) {
            url = this.getMandatory("hub-url", allProperties);
        }
        return url;
    }

    @NotNull
    public final String getServiceSubContext(@NotNull T allProperties, String serviceId) {
        URL baseURL;
        String baseUrlAsString = this.getMandatory(BundleProperty.BASE_URL.getPrefixedName(), allProperties);
        try {
            baseURL = new URL(baseUrlAsString);
        }
        catch (MalformedURLException e) {
            throw new StatusException("Invalid base URL: " + baseUrlAsString, e);
        }
        String baseContext = UrlUtil.ensureStartsWithoutSlash(baseURL.getPath());
        String serviceContext = UrlUtil.ensureStartsWithoutSlash(this.getMandatoryServiceProperty(allProperties, serviceId, "context"));
        if (!UrlUtil.isContextStartedWith(serviceContext, baseContext)) {
            throw new StatusException("Service context " + serviceContext + " is not started with base URL context " + baseContext);
        }
        return "/" + UrlUtil.ensureStartsWithoutSlash(serviceContext.substring(baseContext.length(), serviceContext.length()));
    }

    @NotNull
    public final Map<String, String> getAllServicesContexts(@NotNull T properties) {
        return this.getAllServicesContexts(properties, true);
    }

    @NotNull
    public final Map<String, String> getAllServicesContexts(@NotNull T properties, boolean skipDisabled) {
        HashMap<String, String> contexts = new HashMap<String, String>();
        for (String name : this.stringPropertyNames(properties)) {
            String[] nameSplit = name.split("\\.");
            if (nameSplit.length != 3 || !"service".equals(nameSplit[0]) || !"context".equals(nameSplit[2]) || skipDisabled && !this.isServiceEnabled(properties, nameSplit[1])) continue;
            contexts.put(nameSplit[1], this.get(name, properties));
        }
        if (this.containsKey("context", properties)) {
            contexts.put(this.get("id", properties), this.get("context", properties));
        }
        return contexts;
    }

    @NotNull
    public final Set<String> filterServicesByProperty(@NotNull T properties, @NotNull String propertyName, @Nullable String propertyValue) {
        Collection<String> services = this.getServices(properties);
        HashSet<String> filteredServices = new HashSet<String>();
        for (String serviceId : services) {
            String servicePropertyValue = this.getServiceProperty(properties, serviceId, propertyName);
            if (servicePropertyValue == null || propertyValue != null && !propertyValue.equals(servicePropertyValue)) continue;
            filteredServices.add(serviceId);
        }
        return filteredServices;
    }

    @Nullable
    public final String getServiceByProperty(@NotNull T properties, @NotNull String propertyName, @NotNull String propertyValue) {
        Set<String> filteredServices = this.filterServicesByProperty(properties, propertyName, propertyValue);
        if (filteredServices.isEmpty()) {
            return null;
        }
        if (filteredServices.size() > 1) {
            throw new UniqueConstraintViolationException(String.format("More than one service %s has property [%s=%s]", filteredServices.toString(), propertyName, propertyValue));
        }
        return filteredServices.iterator().next();
    }

    @NotNull
    public final Map<String, String> getServicesPropertyValue(@NotNull T properties, @NotNull String servicePropertyName) {
        return this.getServicesPropertyValue(properties, servicePropertyName, true);
    }

    @NotNull
    public final Map<String, String> getServicesPropertyValue(@NotNull T properties, @NotNull String servicePropertyName, boolean skipDisabled) {
        HashMap<String, String> services = new HashMap<String, String>();
        for (String name : this.stringPropertyNames(properties)) {
            String[] nameSplit = name.split("\\.");
            if (nameSplit.length != 3 || !"service".equals(nameSplit[0]) || !servicePropertyName.equals(nameSplit[2])) continue;
            services.put(nameSplit[1], this.get(name, properties));
        }
        if (skipDisabled) {
            this.removeDisabledServices(properties, services.keySet());
        }
        return services;
    }

    public final boolean isServiceEnabled(@NotNull T properties, @NotNull String serviceId) {
        return Boolean.valueOf(this.get(BundleProperty.constructDisableServiceProperty(serviceId, false), properties)) == false && Boolean.valueOf(this.get(BundleProperty.constructDisableServiceProperty(serviceId, true), properties)) == false;
    }

    public final boolean isServiceUpgrade(@NotNull T properties) {
        String currentVersion;
        String serviceId = this.getMandatory("id", properties);
        if (this.isServiceEnabled(properties, serviceId) && (currentVersion = this.get("version", properties)) != null && !UNKNOWN_SERVICE_VERSION.equalsIgnoreCase(currentVersion)) {
            String previouslyStartedVersion = this.get("previously-started-version", properties);
            if (previouslyStartedVersion != null && !UNKNOWN_SERVICE_VERSION.equalsIgnoreCase(previouslyStartedVersion)) {
                return !currentVersion.equalsIgnoreCase(previouslyStartedVersion);
            }
            return this.isProductUpgrade(properties);
        }
        return false;
    }

    public final boolean isProductUpgrade(@NotNull T properties) {
        String previouslyStartedProductVersion;
        String currentProductVersion = this.get(BundleProperty.CURRENT_PRODUCT_VERSION.getPrefixedName(), properties);
        if (currentProductVersion != null && (previouslyStartedProductVersion = this.get(BundleProperty.PREVIOUSLY_STARTED_PRODUCT_VERSION.getPrefixedName(), properties)) != null) {
            return !currentProductVersion.equalsIgnoreCase(previouslyStartedProductVersion);
        }
        return false;
    }

    public final boolean isCleanInstallation(@NotNull T properties) {
        return !this.containsKey(BundleProperty.PREVIOUSLY_STARTED_PRODUCT_VERSION.getPrefixedName(), properties);
    }

    private void removeDisabledServices(@NotNull T properties, Set<String> services) {
        Iterator<String> it = services.iterator();
        while (it.hasNext()) {
            if (this.isServiceEnabled(properties, it.next())) continue;
            it.remove();
        }
    }

    private String get(@NotNull String property, @NotNull T allProperties) {
        return this.myPropertySourceAdapter.get(property, allProperties);
    }

    private void set(@NotNull String property, String value, @NotNull T allProperties) {
        this.myPropertySourceAdapter.set(property, value, allProperties);
    }

    private Set<String> stringPropertyNames(@NotNull T allProperties) {
        return this.myPropertySourceAdapter.stringPropertyNames(allProperties);
    }

    private boolean containsKey(@NotNull String property, @NotNull T allProperties) {
        return this.myPropertySourceAdapter.containsKey(property, allProperties);
    }

    @NotNull
    private String getMandatory(@NotNull String propertyName, @NotNull T allProperties) {
        return this.myPropertySourceAdapter.getMandatory(propertyName, allProperties);
    }

    private void checkNotNullProperty(String value, @NotNull String propertyName) {
        this.myPropertySourceAdapter.checkNotNullProperty(value, propertyName);
    }
}

