/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.util;

import com.jetbrains.launcher.Static;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringUtil {
    @Static
    @NotNull
    private static final Pattern EOL_SPLIT_PATTERN = Pattern.compile(" *(\r|\n|\r\n)+ *");

    @NotNull
    public static String join(@NotNull Collection<String> values, @NotNull String separator) {
        if (values == null) {
            StringUtil.$$$reportNull$$$0(0);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(1);
        }
        StringBuilder sb = new StringBuilder();
        for (String value : values) {
            StringUtil.append(sb, separator, value);
        }
        String string = sb.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    public static boolean isIntegerNumber(@NotNull String str) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(3);
        }
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static void append(@NotNull StringBuilder sb, @NotNull String separator, @NotNull String str) {
        if (sb == null) {
            StringUtil.$$$reportNull$$$0(4);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(5);
        }
        if (str == null) {
            StringUtil.$$$reportNull$$$0(6);
        }
        if (sb.length() > 0) {
            sb.append(separator);
        }
        sb.append(str);
    }

    @NotNull
    public static String[] toStringArray(@NotNull List<String> list) {
        if (list == null) {
            StringUtil.$$$reportNull$$$0(7);
        }
        String[] stringArray = list.toArray(new String[list.size()]);
        if (stringArray == null) {
            StringUtil.$$$reportNull$$$0(8);
        }
        return stringArray;
    }

    @Contract(value="null -> true")
    public static boolean isEmpty(@Nullable String value) {
        return value == null || value.trim().length() == 0;
    }

    @NotNull
    public static String notNullize(@Nullable String value) {
        String string = StringUtil.notNullize(value, "");
        if (string == null) {
            StringUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public static String notNullize(@Nullable String value, @NotNull String notNullValue) {
        if (notNullValue == null) {
            StringUtil.$$$reportNull$$$0(10);
        }
        String string = value == null ? notNullValue : value;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public static String notNullize(@Nullable String value1, @Nullable String value2, @NotNull String notNullValue) {
        if (notNullValue == null) {
            StringUtil.$$$reportNull$$$0(12);
        }
        String string = value1 == null ? StringUtil.notNullize(value2, notNullValue) : value1;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public static List<String> splitByLines(@NotNull String text) {
        String trimmedText;
        if (text == null) {
            StringUtil.$$$reportNull$$$0(14);
        }
        List<String> list = (trimmedText = text.trim()).length() == 0 ? Collections.emptyList() : Arrays.asList(EOL_SPLIT_PATTERN.split(trimmedText));
        if (list == null) {
            StringUtil.$$$reportNull$$$0(15);
        }
        return list;
    }

    @NotNull
    public static String trimSuffix(@NotNull String string, String suffix) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(16);
        }
        String string2 = string.endsWith(suffix) ? string.substring(0, string.length() - suffix.length()) : string;
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(17);
        }
        return string2;
    }

    @NotNull
    public static String capitalize(@NotNull String str) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(18);
        }
        String string = str.length() == 0 || Character.isUpperCase(str.charAt(0)) ? str : Character.toUpperCase(str.charAt(0)) + str.substring(1);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    public static String capitalizeAllWords(@NotNull String str) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(20);
        }
        StringBuilder sb = new StringBuilder();
        Word word = new Word(0, 0);
        while ((word = StringUtil.nextWord(str, word)) != null) {
            sb.append(StringUtil.capitalize(str.substring(word.getStartIndex(), word.getEndIndex())));
        }
        String string = sb.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(21);
        }
        return string;
    }

    @Nullable
    private static Word nextWord(@NotNull String str, @NotNull Word previousWord) {
        int endIndex;
        if (str == null) {
            StringUtil.$$$reportNull$$$0(22);
        }
        if (previousWord == null) {
            StringUtil.$$$reportNull$$$0(23);
        }
        int startIndex = previousWord.getEndIndex();
        int length = str.length();
        for (endIndex = startIndex; endIndex < length && !Character.isWhitespace(str.charAt(endIndex)); ++endIndex) {
        }
        while (endIndex < length && Character.isWhitespace(str.charAt(endIndex))) {
            ++endIndex;
        }
        return endIndex == startIndex ? null : new Word(startIndex, endIndex);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/util/StringUtil";
                break;
            }
            case 3: 
            case 6: 
            case 18: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notNullValue";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previousWord";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/util/StringUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "join";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "toStringArray";
                break;
            }
            case 9: 
            case 11: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullize";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "splitByLines";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "trimSuffix";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "capitalize";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "capitalizeAllWords";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "join";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isIntegerNumber";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "toStringArray";
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "notNullize";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "splitByLines";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "trimSuffix";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "capitalize";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "capitalizeAllWords";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "nextWord";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Word {
        private final int myStartIndex;
        private final int myEndIndex;

        private Word(int startIndex, int endIndex) {
            this.myStartIndex = startIndex;
            this.myEndIndex = endIndex;
        }

        private int getStartIndex() {
            return this.myStartIndex;
        }

        private int getEndIndex() {
            return this.myEndIndex;
        }
    }
}

