/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher;

import com.jetbrains.launcher.AppConfigFilesEx;
import com.jetbrains.launcher.AppFixedFilesEx;
import com.jetbrains.launcher.AppFixedFilesImpl;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppConfigFilesImpl
extends AppFixedFilesImpl
implements AppConfigFilesEx {
    @NotNull
    private static final String JAVA_CUSTOM_PATH_FILE_NAME_SUFFIX = ".java.path";
    @NotNull
    private final PathHolder myAppConfFolder;

    @Nullable
    public static AppConfigFilesEx detectConfigFiles() {
        AppFixedFilesEx appFixedFiles = AppConfigFilesImpl.detectFixedFiles();
        return appFixedFiles == null ? null : new AppConfigFilesImpl(appFixedFiles, System.getProperty("launcher.app.conf.dir"));
    }

    public AppConfigFilesImpl(@NotNull AppFixedFilesEx appFixedFiles, @Nullable String appConfDirPath) {
        if (appFixedFiles == null) {
            AppConfigFilesImpl.$$$reportNull$$$0(0);
        }
        this(appFixedFiles.getAppHome(), appConfDirPath);
    }

    protected AppConfigFilesImpl(@NotNull File appHome, @Nullable String appConfDirPath) {
        if (appHome == null) {
            AppConfigFilesImpl.$$$reportNull$$$0(1);
        }
        super(appHome);
        this.myAppConfFolder = new PathHolder(appConfDirPath){

            @Override
            @NotNull
            protected File resolve() {
                File file = AppConfigFilesImpl.this.resolvePath(this.getRawPath(), "conf");
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                return file;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/launcher/AppConfigFilesImpl$1", "resolve"));
            }
        };
    }

    @NotNull
    public File getAppConfFolder() {
        File file = this.myAppConfFolder.get();
        if (file == null) {
            AppConfigFilesImpl.$$$reportNull$$$0(2);
        }
        return file;
    }

    @NotNull
    public File getAppInternalConfFolder() {
        File file = new File(this.getAppConfFolder(), "internal");
        if (file == null) {
            AppConfigFilesImpl.$$$reportNull$$$0(3);
        }
        return file;
    }

    @NotNull
    public File getWinServiceConfigFile() {
        File file = new File(this.getAppInternalConfFolder(), "launcher.service.settings.xml");
        if (file == null) {
            AppConfigFilesImpl.$$$reportNull$$$0(4);
        }
        return file;
    }

    @NotNull
    public File getMacDaemonConfigFile() {
        File file = new File(this.getAppInternalConfFolder(), "launcher.daemon.plist");
        if (file == null) {
            AppConfigFilesImpl.$$$reportNull$$$0(5);
        }
        return file;
    }

    @NotNull
    public File getJavaHintFile() {
        File file = this.getAppConfigFile(JAVA_CUSTOM_PATH_FILE_NAME_SUFFIX);
        if (file == null) {
            AppConfigFilesImpl.$$$reportNull$$$0(6);
        }
        return file;
    }

    @NotNull
    public File getAppConfigFile(@NotNull String fileNameSuffix) {
        if (fileNameSuffix == null) {
            AppConfigFilesImpl.$$$reportNull$$$0(7);
        }
        File file = new File(this.getAppConfFolder(), this.getAppFileName() + fileNameSuffix);
        if (file == null) {
            AppConfigFilesImpl.$$$reportNull$$$0(8);
        }
        return file;
    }

    public int getAppConfigHash() {
        return AppConfigFilesImpl.getFilesHash(this.getAppConfigFile(".launch.config"), this.getAppConfigFile(".jvmoptions"));
    }

    private static int getFilesHash(File ... files) {
        if (files == null) {
            AppConfigFilesImpl.$$$reportNull$$$0(9);
        }
        int result = 0;
        for (File file : files) {
            result = 31 * result + new Long(file.lastModified()).hashCode();
        }
        return result;
    }

    @Nullable
    public String getAppConfigRawPath() {
        return this.myAppConfFolder.getRawPath();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appFixedFiles";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appHome";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/AppConfigFilesImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNameSuffix";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/AppConfigFilesImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppConfFolder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppInternalConfFolder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getWinServiceConfigFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMacDaemonConfigFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaHintFile";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppConfigFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAppConfigFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFilesHash";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static abstract class PathHolder {
        @Nullable
        private final String myRawPath;
        @Nullable
        private File myResolvedPath;

        protected PathHolder(@Nullable String rawPath) {
            this.myRawPath = rawPath;
        }

        @Nullable
        protected String getRawPath() {
            return this.myRawPath;
        }

        @NotNull
        protected File get() {
            if (this.myResolvedPath == null) {
                this.myResolvedPath = this.resolve();
            }
            File file = this.myResolvedPath;
            if (file == null) {
                PathHolder.$$$reportNull$$$0(0);
            }
            return file;
        }

        @NotNull
        protected abstract File resolve();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/launcher/AppConfigFilesImpl$PathHolder", "get"));
        }
    }
}

