/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher;

import com.jetbrains.launcher.AppFixedFilesEx;
import com.jetbrains.launcher.Resource;
import com.jetbrains.launcher.SystemInfo;
import com.jetbrains.launcher.util.FileUtil;
import com.jetbrains.launcher.util.JarUtil;
import com.jetbrains.launcher.util.PropertiesUtil;
import com.jetbrains.launcher.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppFixedFilesImpl
implements AppFixedFilesEx {
    @NotNull
    private final File myAppHome;
    @Nullable
    private Properties myAppNames;

    @Nullable
    public static AppFixedFilesEx detectFixedFiles() {
        String appHome = System.getProperty("launcher.app.home");
        return appHome == null ? null : new AppFixedFilesImpl(new File(appHome));
    }

    public AppFixedFilesImpl(@NotNull File appHome) {
        if (appHome == null) {
            AppFixedFilesImpl.$$$reportNull$$$0(0);
        }
        this.myAppHome = AppFixedFilesImpl.canonical(appHome);
    }

    @NotNull
    public File getAppHome() {
        File file = this.myAppHome;
        if (file == null) {
            AppFixedFilesImpl.$$$reportNull$$$0(1);
        }
        return file;
    }

    @NotNull
    public String getAppFileName() {
        String string = this.getAppName("app.file.name", "app");
        if (string == null) {
            AppFixedFilesImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public File getAppBinFolder() {
        File file = new File(this.myAppHome, "bin");
        if (file == null) {
            AppFixedFilesImpl.$$$reportNull$$$0(3);
        }
        return file;
    }

    @NotNull
    public String getMovingSafePath(@NotNull File baseDir, @NotNull File file) {
        if (baseDir == null) {
            AppFixedFilesImpl.$$$reportNull$$$0(4);
        }
        if (file == null) {
            AppFixedFilesImpl.$$$reportNull$$$0(5);
        }
        String string = FileUtil.isFileInside((File)this.myAppHome, (File)baseDir) == FileUtil.isFileInside((File)this.myAppHome, (File)file) ? FileUtil.getRelativePath((File)baseDir, (File)file) : file.getAbsolutePath();
        if (string == null) {
            AppFixedFilesImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public File getLauncherFolder() {
        File file = new File(this.myAppHome, "launcher");
        if (file == null) {
            AppFixedFilesImpl.$$$reportNull$$$0(7);
        }
        return file;
    }

    @NotNull
    public File getAppScriptFile() {
        File file = new File(this.getAppBinFolder(), this.getAppFileName() + (SystemInfo.isWindows ? ".bat" : ".sh"));
        if (file == null) {
            AppFixedFilesImpl.$$$reportNull$$$0(8);
        }
        return file;
    }

    @NotNull
    public String getJetServiceExecutableName() {
        String string = this.getAppName("jetservice.file.name", "JetService");
        if (string == null) {
            AppFixedFilesImpl.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public File getJetServiceExecutable() {
        File file = new File(this.getLauncherBinFolder(), this.getJetServiceExecutableName() + ".exe");
        if (file == null) {
            AppFixedFilesImpl.$$$reportNull$$$0(10);
        }
        return file;
    }

    @NotNull
    public File getMacDaemonScriptFile() {
        File file = new File(this.getLauncherBinFolder(), "mac.daemon.sh");
        if (file == null) {
            AppFixedFilesImpl.$$$reportNull$$$0(11);
        }
        return file;
    }

    @NotNull
    public File getLauncherBinFolder() {
        File file = new File(this.getLauncherFolder(), "bin");
        if (file == null) {
            AppFixedFilesImpl.$$$reportNull$$$0(12);
        }
        return file;
    }

    @NotNull
    public File getLauncherConfFolder() {
        File file = new File(this.getLauncherFolder(), "conf");
        if (file == null) {
            AppFixedFilesImpl.$$$reportNull$$$0(13);
        }
        return file;
    }

    @NotNull
    public File getLauncherLibFolder() {
        File file = new File(this.getLauncherFolder(), "lib");
        if (file == null) {
            AppFixedFilesImpl.$$$reportNull$$$0(14);
        }
        return file;
    }

    @NotNull
    public File getLauncherPluginsFolder() {
        File file = new File(this.getLauncherFolder(), "plugins");
        if (file == null) {
            AppFixedFilesImpl.$$$reportNull$$$0(15);
        }
        return file;
    }

    @NotNull
    public File getAppWrapperLibFolder() {
        File file = new File(this.getLauncherLibFolder(), "app-wrapper");
        if (file == null) {
            AppFixedFilesImpl.$$$reportNull$$$0(16);
        }
        return file;
    }

    @NotNull
    public Resource resolveLauncherConfigFile(@NotNull String fileName) {
        File file;
        if (fileName == null) {
            AppFixedFilesImpl.$$$reportNull$$$0(17);
        }
        if ((file = new File(this.getLauncherConfFolder(), fileName)).isFile()) {
            Resource resource = new Resource(FileUtil.toURL((File)file), true);
            if (resource == null) {
                AppFixedFilesImpl.$$$reportNull$$$0(18);
            }
            return resource;
        }
        URL resourceUrl = AppFixedFilesImpl.findResource(this.getLauncherLibFolder(), fileName);
        if (resourceUrl != null) {
            Resource resource = new Resource(resourceUrl, true);
            if (resource == null) {
                AppFixedFilesImpl.$$$reportNull$$$0(19);
            }
            return resource;
        }
        Resource resource = new Resource(FileUtil.toURL((File)file), false);
        if (resource == null) {
            AppFixedFilesImpl.$$$reportNull$$$0(20);
        }
        return resource;
    }

    @NotNull
    public Resource resolveLauncherAppConfigFile(@NotNull String fileNameSuffix) {
        if (fileNameSuffix == null) {
            AppFixedFilesImpl.$$$reportNull$$$0(21);
        }
        Resource resource = this.resolveLauncherConfigFile(this.getAppFileName() + fileNameSuffix);
        if (resource == null) {
            AppFixedFilesImpl.$$$reportNull$$$0(22);
        }
        return resource;
    }

    public int getIntelliJPluginProtocolVersion() {
        return AppFixedFilesImpl.getIntelliJPluginProtocolVersion(this.getLauncherLibFolder());
    }

    public static int getIntelliJPluginProtocolVersion(@NotNull File libFolder) {
        if (libFolder == null) {
            AppFixedFilesImpl.$$$reportNull$$$0(23);
        }
        return AppFixedFilesImpl.getProtocolVersion(AppFixedFilesImpl.findResource(libFolder, "intellij.plugin.protocol.version"));
    }

    private static int getProtocolVersion(@Nullable URL protocolVersionResourceUrl) {
        if (protocolVersionResourceUrl != null) {
            try {
                return Integer.parseInt(FileUtil.loadText((URL)protocolVersionResourceUrl).trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    @Nullable
    private static URL findResource(@NotNull File libFolder, @NotNull String fileName) {
        if (libFolder == null) {
            AppFixedFilesImpl.$$$reportNull$$$0(24);
        }
        if (fileName == null) {
            AppFixedFilesImpl.$$$reportNull$$$0(25);
        }
        try {
            File jar = JarUtil.findJarWithEntry(libFolder, fileName);
            return jar == null ? null : FileUtil.getFileInJarUrl((File)jar, (String)fileName);
        }
        catch (IOException e) {
            return null;
        }
    }

    @NotNull
    private String getAppName(@NotNull String propertyName, @NotNull String defaultValue) {
        if (propertyName == null) {
            AppFixedFilesImpl.$$$reportNull$$$0(26);
        }
        if (defaultValue == null) {
            AppFixedFilesImpl.$$$reportNull$$$0(27);
        }
        String string = StringUtil.notNullize((String)this.getRawAppName(propertyName), (String)defaultValue);
        if (string == null) {
            AppFixedFilesImpl.$$$reportNull$$$0(28);
        }
        return string;
    }

    @Nullable
    private String getRawAppName(@NotNull String propertyName) {
        if (propertyName == null) {
            AppFixedFilesImpl.$$$reportNull$$$0(29);
        }
        if (this.myAppNames == null) {
            this.myAppNames = this.readAppNames();
        }
        return PropertiesUtil.getProperty((Properties)this.myAppNames, (String)propertyName);
    }

    @NotNull
    private Properties readAppNames() {
        Properties properties = new Properties();
        Resource resource = this.resolveLauncherConfigFile("app.names");
        if (resource.exists()) {
            try {
                PropertiesUtil.loadFromUrl((Properties)properties, (URL)resource.getURL());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Properties properties2 = properties;
        if (properties2 == null) {
            AppFixedFilesImpl.$$$reportNull$$$0(30);
        }
        return properties2;
    }

    @NotNull
    public File resolvePath(@NotNull String path) {
        if (path == null) {
            AppFixedFilesImpl.$$$reportNull$$$0(31);
        }
        File file = this.resolvePath(this.myAppHome, path);
        if (file == null) {
            AppFixedFilesImpl.$$$reportNull$$$0(32);
        }
        return file;
    }

    @NotNull
    public File resolvePath(@Nullable String path, @NotNull String defaultPath) {
        if (defaultPath == null) {
            AppFixedFilesImpl.$$$reportNull$$$0(33);
        }
        File file = this.resolvePath(this.myAppHome, path, defaultPath);
        if (file == null) {
            AppFixedFilesImpl.$$$reportNull$$$0(34);
        }
        return file;
    }

    @NotNull
    public File resolvePath(@NotNull File baseDir, @NotNull String path) {
        if (baseDir == null) {
            AppFixedFilesImpl.$$$reportNull$$$0(35);
        }
        if (path == null) {
            AppFixedFilesImpl.$$$reportNull$$$0(36);
        }
        File file = AppFixedFilesImpl.canonical(FileUtil.resolvePath((File)baseDir, (String)path));
        if (file == null) {
            AppFixedFilesImpl.$$$reportNull$$$0(37);
        }
        return file;
    }

    @NotNull
    public File resolvePath(@NotNull File baseDir, @Nullable String path, @NotNull String defaultPath) {
        if (baseDir == null) {
            AppFixedFilesImpl.$$$reportNull$$$0(38);
        }
        if (defaultPath == null) {
            AppFixedFilesImpl.$$$reportNull$$$0(39);
        }
        File file = path == null ? this.resolvePath(defaultPath) : this.resolvePath(baseDir, path);
        if (file == null) {
            AppFixedFilesImpl.$$$reportNull$$$0(40);
        }
        return file;
    }

    @NotNull
    private static File canonical(@NotNull File file) {
        File file2;
        if (file == null) {
            AppFixedFilesImpl.$$$reportNull$$$0(41);
        }
        try {
            file2 = file.getCanonicalFile();
        }
        catch (IOException e) {
            File file3 = file.getAbsoluteFile();
            if (file3 == null) {
                AppFixedFilesImpl.$$$reportNull$$$0(43);
            }
            return file3;
        }
        if (file2 == null) {
            AppFixedFilesImpl.$$$reportNull$$$0(42);
        }
        return file2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 37: 
            case 40: 
            case 42: 
            case 43: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 37: 
            case 40: 
            case 42: 
            case 43: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appHome";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 37: 
            case 40: 
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/AppFixedFilesImpl";
                break;
            }
            case 4: 
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 5: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 17: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNameSuffix";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libFolder";
                break;
            }
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 31: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 33: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/AppFixedFilesImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppHome";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppFileName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppBinFolder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMovingSafePath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLauncherFolder";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppScriptFile";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getJetServiceExecutableName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getJetServiceExecutable";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getMacDaemonScriptFile";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getLauncherBinFolder";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getLauncherConfFolder";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getLauncherLibFolder";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getLauncherPluginsFolder";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppWrapperLibFolder";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLauncherConfigFile";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLauncherAppConfigFile";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppName";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "readAppNames";
                break;
            }
            case 32: 
            case 34: 
            case 37: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "resolvePath";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "canonical";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 37: 
            case 40: 
            case 42: 
            case 43: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getMovingSafePath";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "resolveLauncherConfigFile";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "resolveLauncherAppConfigFile";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getIntelliJPluginProtocolVersion";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findResource";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getAppName";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getRawAppName";
                break;
            }
            case 31: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "resolvePath";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "canonical";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 37: 
            case 40: 
            case 42: 
            case 43: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

