/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.log;

import com.jetbrains.launcher.AppFixedFiles;
import com.jetbrains.launcher.Destroyer;
import com.jetbrains.launcher.InitException;
import com.jetbrains.launcher.LogLevel;
import com.jetbrains.launcher.ProcessContext;
import com.jetbrains.launcher.log.LoggerMode;
import com.jetbrains.launcher.log.LoggerRepositorySelector;
import com.jetbrains.launcher.log.Loggers;
import com.jetbrains.launcher.log.LoggersEx;
import com.jetbrains.launcher.util.FileUtil;
import com.jetbrains.launcher.util.RuntimeUtil;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.xml.DOMConfigurator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LogInitializer {
    @NotNull
    private static final String LAUNCHER_LOGS_DIR_PROP = "launcher_logs_dir";
    @NotNull
    private static final String LAUNCHER_LOG_FILE_NAME_PROP = "launcher_log_file_name";
    @NotNull
    private static final String LAUNCHER_APP_FILE_NAME_PROP = "launcher_app_file_name";
    @NotNull
    private static final String LAUNCHER_CONSOLE_LOG_LEVEL_PROP = "launcher_console_log_level";
    @NotNull
    private static final String LAUNCHER_LOG_PREFIX_PROP = "launcher_log_prefix";
    @NotNull
    private static final ProcessContext.Key<LoggerRepository> LOGGER_REPOSITORY_COPY_KEY = new ProcessContext.Key<LoggerRepository>(){

        @NotNull
        public LoggerRepository createDefaultValue() {
            LoggerRepository loggerRepository = LoggerRepositorySelector.createLoggerRepository();
            if (loggerRepository == null) {
                1.$$$reportNull$$$0(0);
            }
            return loggerRepository;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/launcher/log/LogInitializer$1", "createDefaultValue"));
        }
    };

    private LogInitializer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(@NotNull AppFixedFiles appFiles, @NotNull File launcherLogsFolder, @NotNull LoggerMode mode, @NotNull LogLevel logLevel, @Nullable String logPrefix, boolean firstInit) throws InitException {
        if (appFiles == null) {
            LogInitializer.$$$reportNull$$$0(0);
        }
        if (launcherLogsFolder == null) {
            LogInitializer.$$$reportNull$$$0(1);
        }
        if (mode == null) {
            LogInitializer.$$$reportNull$$$0(2);
        }
        if (logLevel == null) {
            LogInitializer.$$$reportNull$$$0(3);
        }
        HashMap<String, String> logProperties = new HashMap<String, String>();
        try {
            logProperties.put(LAUNCHER_LOGS_DIR_PROP, LogInitializer.checkLogsFolder(launcherLogsFolder, mode));
            String appFileName = appFiles.getAppFileName();
            logProperties.put(LAUNCHER_APP_FILE_NAME_PROP, appFileName);
            logProperties.put(LAUNCHER_LOG_FILE_NAME_PROP, LogInitializer.prepareLogFileName(mode.getLogFileName(), appFileName));
            logProperties.put(LAUNCHER_CONSOLE_LOG_LEVEL_PROP, logLevel.name());
            logProperties.put(LAUNCHER_LOG_PREFIX_PROP, logPrefix);
        }
        finally {
            LoggersEx.init(mode, logProperties);
            Loggers.init(logLevel);
        }
        LogInitializer.setupLog4j();
        if (firstInit) {
            Logger.getRootLogger().trace((Object)"================================================================ (start)");
            final LoggerRepository loggerRepositoryCopy = (LoggerRepository)ProcessContext.get().getOrCreateValue(LOGGER_REPOSITORY_COPY_KEY);
            LogInitializer.setupLog4j(loggerRepositoryCopy);
            Destroyer.get().addStep(new Runnable(){

                @Override
                public void run() {
                    LoggerRepositorySelector.INSTANCE.muteLoggers();
                    loggerRepositoryCopy.getRootLogger().trace((Object)"================================================================ (finish)");
                    loggerRepositoryCopy.shutdown();
                }
            });
            LoggersEx.setInitialized();
        }
    }

    @Nullable
    private static String checkLogsFolder(@NotNull File logsFolder, @NotNull LoggerMode mode) throws InitException {
        if (logsFolder == null) {
            LogInitializer.$$$reportNull$$$0(4);
        }
        if (mode == null) {
            LogInitializer.$$$reportNull$$$0(5);
        }
        return mode.isLogsFolderNeeded() ? LogInitializer.checkAndGetLogsDirectoryProperty(logsFolder) : null;
    }

    @Nullable
    private static String prepareLogFileName(@Nullable String logFileName, @NotNull String appFileName) {
        if (appFileName == null) {
            LogInitializer.$$$reportNull$$$0(6);
        }
        return logFileName == null ? null : logFileName.replace("@APP_FILE_NAME@", appFileName);
    }

    public static void reinit(@NotNull File newLauncherLogsFolder) throws InitException {
        if (newLauncherLogsFolder == null) {
            LogInitializer.$$$reportNull$$$0(7);
        }
        LoggerMode loggerMode = LoggersEx.getLoggerMode();
        HashMap<String, String> logProperties = new HashMap<String, String>(LoggersEx.getLogProperties());
        logProperties.put(LAUNCHER_LOGS_DIR_PROP, LogInitializer.checkLogsFolder(newLauncherLogsFolder, loggerMode));
        LoggersEx.init(loggerMode, logProperties);
        LogInitializer.setupLog4j();
        LoggerRepository loggerRepositoryCopy = (LoggerRepository)ProcessContext.get().getValue(LOGGER_REPOSITORY_COPY_KEY);
        if (loggerRepositoryCopy != null) {
            LogInitializer.setupLog4j(loggerRepositoryCopy);
        }
    }

    @NotNull
    private static String checkAndGetLogsDirectoryProperty(@NotNull File logsFolder) throws InitException {
        if (logsFolder == null) {
            LogInitializer.$$$reportNull$$$0(8);
        }
        RuntimeUtil.createDirIfNeededAndCheckItIsWritable(logsFolder, "logs directory");
        String logsProperty = logsFolder.getPath();
        if (!logsProperty.endsWith(File.separator)) {
            logsProperty = logsProperty + File.separator;
        }
        String string = logsProperty;
        if (string == null) {
            LogInitializer.$$$reportNull$$$0(9);
        }
        return string;
    }

    public static synchronized void setupLog4j() {
        LogInitializer.setupLog4j(LogManager.getLoggerRepository());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void setupLog4j(@NotNull LoggerRepository loggerRepository) {
        if (loggerRepository == null) {
            LogInitializer.$$$reportNull$$$0(10);
        }
        for (Map.Entry<String, String> property : LoggersEx.getLogProperties().entrySet()) {
            String value = property.getValue();
            if (value == null) {
                System.clearProperty(property.getKey());
                continue;
            }
            System.setProperty(property.getKey(), value);
        }
        InputStream configStream = LogInitializer.class.getClassLoader().getResourceAsStream(LoggersEx.getLoggerMode().getConfigFileName());
        try {
            new DOMConfigurator().doConfigure(configStream, loggerRepository);
        }
        finally {
            FileUtil.close((Closeable)configStream);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appFiles";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launcherLogsFolder";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logLevel";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logsFolder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appFileName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newLauncherLogsFolder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/log/LogInitializer";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loggerRepository";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/log/LogInitializer";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "checkAndGetLogsDirectoryProperty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkLogsFolder";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "prepareLogFileName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "reinit";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkAndGetLogsDirectoryProperty";
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setupLog4j";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

