/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.util;

import com.jetbrains.launcher.ProcessEnvironment;
import com.jetbrains.launcher.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CmdUtil {
    @NotNull
    public static final String JAVA_PROPERTIES_ENV = "JL_JAVA_PROPERTIES";
    @NotNull
    private static final String WRAPPING_SYMBOL = "\"";

    public static void setSystemProperties() {
        for (Map.Entry<String, String> property : CmdUtil.getSpecifiedEnvSystemProperties().entrySet()) {
            System.setProperty(property.getKey(), property.getValue());
        }
    }

    @NotNull
    public static Process executeJava(@NotNull File workDir, @NotNull List<String> cmdLine, @NotNull Map<String, String> envSystemProperties) throws IOException {
        if (workDir == null) {
            CmdUtil.$$$reportNull$$$0(0);
        }
        if (cmdLine == null) {
            CmdUtil.$$$reportNull$$$0(1);
        }
        if (envSystemProperties == null) {
            CmdUtil.$$$reportNull$$$0(2);
        }
        ProcessBuilder processBuilder = new ProcessBuilder(cmdLine).directory(workDir);
        processBuilder.environment().putAll(ProcessEnvironment.getOwn());
        processBuilder.environment().put(JAVA_PROPERTIES_ENV, CmdUtil.buildSystemPropertiesString(envSystemProperties));
        Process process = processBuilder.start();
        if (process == null) {
            CmdUtil.$$$reportNull$$$0(3);
        }
        return process;
    }

    @NotNull
    public static String buildSystemPropertiesString(@NotNull Map<String, String> systemProperties) {
        if (systemProperties == null) {
            CmdUtil.$$$reportNull$$$0(4);
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> property : systemProperties.entrySet()) {
            String param = CmdUtil.createSystemPropertyJvmOption(property);
            if (CmdUtil.hasWhitespace(param)) {
                char quote = param.contains(WRAPPING_SYMBOL) ? (char)'\'' : '\"';
                param = quote + param + quote;
            }
            StringUtil.append((StringBuilder)sb, (String)" ", (String)param);
        }
        String string = sb.toString();
        if (string == null) {
            CmdUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public static String createSystemPropertyJvmOption(@NotNull Map.Entry<String, String> property) {
        if (property == null) {
            CmdUtil.$$$reportNull$$$0(6);
        }
        String string = "-D" + property.getKey() + "=" + property.getValue();
        if (string == null) {
            CmdUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static boolean hasWhitespace(@NotNull String param) {
        int length;
        if (param == null) {
            CmdUtil.$$$reportNull$$$0(8);
        }
        return CmdUtil.findNext(param, 0, length = param.length(), CmdUtil.isWhitespace()) < length;
    }

    @NotNull
    public static String wrap(@NotNull String line) {
        if (line == null) {
            CmdUtil.$$$reportNull$$$0(9);
        }
        String string = CmdUtil.hasWhitespace(line) ? WRAPPING_SYMBOL + line + WRAPPING_SYMBOL : line;
        if (string == null) {
            CmdUtil.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public static String unwrap(@NotNull String line) {
        if (line == null) {
            CmdUtil.$$$reportNull$$$0(11);
        }
        String string = line.startsWith(WRAPPING_SYMBOL) && line.endsWith(WRAPPING_SYMBOL) && line.length() > 1 ? line.substring(1, line.length() - 1) : line;
        if (string == null) {
            CmdUtil.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public static Map<String, String> getSpecifiedEnvSystemProperties() {
        Map<String, String> map = CmdUtil.getSystemProperties(JAVA_PROPERTIES_ENV);
        if (map == null) {
            CmdUtil.$$$reportNull$$$0(13);
        }
        return map;
    }

    @NotNull
    private static Map<String, String> getSystemProperties(@NotNull String propertiesEnvVariable) {
        String propertiesString;
        if (propertiesEnvVariable == null) {
            CmdUtil.$$$reportNull$$$0(14);
        }
        if ((propertiesString = ProcessEnvironment.get((String)propertiesEnvVariable)) == null) {
            Map<String, String> map = Collections.emptyMap();
            if (map == null) {
                CmdUtil.$$$reportNull$$$0(15);
            }
            return map;
        }
        Map<String, String> map = CmdUtil.parseSystemProperties(CmdUtil.parseCommandLine(propertiesString));
        if (map == null) {
            CmdUtil.$$$reportNull$$$0(16);
        }
        return map;
    }

    @NotNull
    private static Map<String, String> parseSystemProperties(@NotNull List<String> params) {
        if (params == null) {
            CmdUtil.$$$reportNull$$$0(17);
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (String param : params) {
            SystemProperty systemProperty = CmdUtil.parseSystemProperty(param);
            if (systemProperty == null) continue;
            result.put(systemProperty.getName(), systemProperty.getNotNullValue());
        }
        HashMap<String, String> hashMap = result;
        if (hashMap == null) {
            CmdUtil.$$$reportNull$$$0(18);
        }
        return hashMap;
    }

    @Nullable
    public static SystemProperty parseSystemProperty(@NotNull String jvmOption) {
        if (jvmOption == null) {
            CmdUtil.$$$reportNull$$$0(19);
        }
        if (jvmOption.startsWith("-D") || jvmOption.startsWith("*D") || jvmOption.startsWith("+D")) {
            int eqPos = jvmOption.indexOf(61);
            if (eqPos == -1) {
                return new SystemProperty(jvmOption.substring(2), null);
            }
            return new SystemProperty(jvmOption.substring(2, eqPos), jvmOption.substring(eqPos + 1));
        }
        return null;
    }

    @NotNull
    public static List<String> parseCommandLine(@NotNull String cmdLine) {
        if (cmdLine == null) {
            CmdUtil.$$$reportNull$$$0(20);
        }
        List<String> list = CmdUtil.parseCommandLine(cmdLine, true);
        if (list == null) {
            CmdUtil.$$$reportNull$$$0(21);
        }
        return list;
    }

    @NotNull
    public static List<String> parseCommandLine(@NotNull String cmdLine, boolean parseArguments) {
        if (cmdLine == null) {
            CmdUtil.$$$reportNull$$$0(22);
        }
        ArrayList<String> result = new ArrayList<String>();
        int length = cmdLine.length();
        int i = 0;
        while (i < length) {
            String args;
            int end;
            int start;
            while (i < length && Character.isWhitespace(cmdLine.charAt(i))) {
                ++i;
            }
            if (i == length) break;
            char symbol = cmdLine.charAt(i);
            if (symbol == '\"' || symbol == '\'') {
                start = i + 1;
                end = CmdUtil.findNext(cmdLine, start, length, CmdUtil.equals(symbol));
                i = end + 1;
            } else {
                start = i;
                end = CmdUtil.findNext(cmdLine, start, length, CmdUtil.isWhitespace());
                i = end + 1;
            }
            result.add(cmdLine.substring(start, end));
            if (parseArguments) continue;
            if (i >= length || StringUtil.isEmpty((String)(args = cmdLine.substring(i).trim()))) break;
            result.add(args);
            break;
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            CmdUtil.$$$reportNull$$$0(23);
        }
        return arrayList;
    }

    private static int findNext(@NotNull String str, int start, int end, @NotNull SymbolPredicate predicate) {
        if (str == null) {
            CmdUtil.$$$reportNull$$$0(24);
        }
        if (predicate == null) {
            CmdUtil.$$$reportNull$$$0(25);
        }
        int i = start;
        char symbol = str.charAt(i);
        while (!(i >= end || predicate.value(symbol) || symbol == '\\' && ++i == end || ++i == end)) {
            symbol = str.charAt(i);
        }
        return i;
    }

    @NotNull
    private static SymbolPredicate equals(final char symbol) {
        SymbolPredicate symbolPredicate = new SymbolPredicate(){

            @Override
            public boolean value(char thatSymbol) {
                return thatSymbol == symbol;
            }
        };
        if (symbolPredicate == null) {
            CmdUtil.$$$reportNull$$$0(26);
        }
        return symbolPredicate;
    }

    @NotNull
    private static SymbolPredicate isWhitespace() {
        SymbolPredicate symbolPredicate = new SymbolPredicate(){

            @Override
            public boolean value(char symbol) {
                return Character.isWhitespace(symbol);
            }
        };
        if (symbolPredicate == null) {
            CmdUtil.$$$reportNull$$$0(27);
        }
        return symbolPredicate;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 23: 
            case 26: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 23: 
            case 26: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workDir";
                break;
            }
            case 1: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdLine";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envSystemProperties";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 23: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/util/CmdUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemProperties";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "param";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertiesEnvVariable";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jvmOption";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/util/CmdUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "executeJava";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "buildSystemPropertiesString";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createSystemPropertyJvmOption";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "wrap";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrap";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpecifiedEnvSystemProperties";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemProperties";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "parseSystemProperties";
                break;
            }
            case 21: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "parseCommandLine";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "equals";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "isWhitespace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "executeJava";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 23: 
            case 26: 
            case 27: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildSystemPropertiesString";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createSystemPropertyJvmOption";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "hasWhitespace";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "wrap";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "unwrap";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getSystemProperties";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "parseSystemProperties";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "parseSystemProperty";
                break;
            }
            case 20: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "parseCommandLine";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findNext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 23: 
            case 26: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static interface SymbolPredicate {
        public boolean value(char var1);
    }

    public static class SystemProperty {
        @NotNull
        private final String myName;
        @Nullable
        private final String myValue;

        public SystemProperty(@NotNull String name, @Nullable String value) {
            if (name == null) {
                SystemProperty.$$$reportNull$$$0(0);
            }
            this.myName = name;
            this.myValue = value;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                SystemProperty.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nullable
        public String getValue() {
            return this.myValue;
        }

        @NotNull
        public String getNotNullValue() {
            String string = this.myValue == null ? "" : this.myValue;
            if (string == null) {
                SystemProperty.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/launcher/util/CmdUtil$SystemProperty";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/launcher/util/CmdUtil$SystemProperty";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNotNullValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

