/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher;

import com.jetbrains.launcher.AppConfigFilesEx;
import com.jetbrains.launcher.AppConfigFilesImpl;
import com.jetbrains.launcher.AppFilesEx;
import com.jetbrains.launcher.AppFilesImpl;
import com.jetbrains.launcher.AppFixedFiles;
import com.jetbrains.launcher.AppFixedFilesEx;
import com.jetbrains.launcher.Arguments;
import com.jetbrains.launcher.CoreArguments;
import com.jetbrains.launcher.InitException;
import com.jetbrains.launcher.LauncherConfigAppFilesAwareValidator;
import com.jetbrains.launcher.LauncherConfigFilesAwareContext;
import com.jetbrains.launcher.LauncherContextEx;
import com.jetbrains.launcher.LauncherContextImpl;
import com.jetbrains.launcher.LauncherCoreContext;
import com.jetbrains.launcher.configs.AppConfig;
import com.jetbrains.launcher.configs.AppConfigImpl;
import com.jetbrains.launcher.configs.AppConfigProvider;
import com.jetbrains.launcher.configs.LauncherConfigValidator;
import com.jetbrains.launcher.ep.Commands;
import com.jetbrains.launcher.plugins.PluginManager;
import com.jetbrains.launcher.util.RuntimeUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LauncherContextFactory {
    @NotNull
    public static Arguments createArguments(@NotNull CoreArguments coreArgs, boolean isEmbeddedMode, String ... cmdLine) {
        if (coreArgs == null) {
            LauncherContextFactory.$$$reportNull$$$0(0);
        }
        if (cmdLine == null) {
            LauncherContextFactory.$$$reportNull$$$0(1);
        }
        Arguments arguments = new Arguments(coreArgs, cmdLine, Commands.createLauncherArgumentsParser(), isEmbeddedMode);
        if (arguments == null) {
            LauncherContextFactory.$$$reportNull$$$0(2);
        }
        return arguments;
    }

    @NotNull
    public static LauncherContextEx createContext(@NotNull LauncherConfigFilesAwareContext configFilesAwareContext) throws InitException {
        if (configFilesAwareContext == null) {
            LauncherContextFactory.$$$reportNull$$$0(3);
        }
        AppConfigFilesEx appConfigFiles = configFilesAwareContext.getAppConfigFiles();
        LauncherContextEx launcherContextEx = LauncherContextFactory.createContext(configFilesAwareContext, appConfigFiles, appConfigFiles.getAppConfigHash());
        if (launcherContextEx == null) {
            LauncherContextFactory.$$$reportNull$$$0(4);
        }
        return launcherContextEx;
    }

    @NotNull
    public static LauncherContextEx createContext(@NotNull LauncherConfigFilesAwareContext configFilesAwareContext, @NotNull AppConfigFilesEx appConfigFiles, int appConfigHash) throws InitException {
        if (configFilesAwareContext == null) {
            LauncherContextFactory.$$$reportNull$$$0(5);
        }
        if (appConfigFiles == null) {
            LauncherContextFactory.$$$reportNull$$$0(6);
        }
        AppConfig appConfig = LauncherContextFactory.createAppConfig(appConfigFiles);
        AppFilesEx appFiles = LauncherContextFactory.createAppFiles(appConfigFiles, appConfig);
        LauncherContextEx launcherContextEx = LauncherContextFactory.createContext(configFilesAwareContext, appConfig, appFiles, appConfigHash);
        if (launcherContextEx == null) {
            LauncherContextFactory.$$$reportNull$$$0(7);
        }
        return launcherContextEx;
    }

    @NotNull
    private static LauncherContextEx createContext(@NotNull LauncherConfigFilesAwareContext configFilesAwareContext, @NotNull AppConfig appConfig, @NotNull AppFilesEx appFiles, int appConfigHash) throws InitException {
        if (configFilesAwareContext == null) {
            LauncherContextFactory.$$$reportNull$$$0(8);
        }
        if (appConfig == null) {
            LauncherContextFactory.$$$reportNull$$$0(9);
        }
        if (appFiles == null) {
            LauncherContextFactory.$$$reportNull$$$0(10);
        }
        LauncherContextEx launcherContextEx = LauncherContextFactory.createContext(configFilesAwareContext.getArguments(), (LauncherCoreContext)configFilesAwareContext, appConfig, appFiles, appConfigHash);
        if (launcherContextEx == null) {
            LauncherContextFactory.$$$reportNull$$$0(11);
        }
        return launcherContextEx;
    }

    @NotNull
    public static LauncherContextEx createContext(@NotNull Arguments args, @NotNull LauncherCoreContext coreContext, @NotNull AppConfig appConfig, @NotNull AppFilesEx appFiles, int appConfigHash) throws InitException {
        if (args == null) {
            LauncherContextFactory.$$$reportNull$$$0(12);
        }
        if (coreContext == null) {
            LauncherContextFactory.$$$reportNull$$$0(13);
        }
        if (appConfig == null) {
            LauncherContextFactory.$$$reportNull$$$0(14);
        }
        if (appFiles == null) {
            LauncherContextFactory.$$$reportNull$$$0(15);
        }
        coreContext.getLauncherConfig().validate((LauncherConfigValidator)new LauncherConfigAppFilesAwareValidator(appFiles));
        LauncherContextImpl launcherContextImpl = new LauncherContextImpl(args, coreContext.getLauncherConfig(), appConfig, appFiles, appConfigHash);
        if (launcherContextImpl == null) {
            LauncherContextFactory.$$$reportNull$$$0(16);
        }
        return launcherContextImpl;
    }

    @NotNull
    public static AppConfigFilesEx createAppConfigFiles(@NotNull AppFixedFilesEx appFixedFiles) throws InitException {
        if (appFixedFiles == null) {
            LauncherContextFactory.$$$reportNull$$$0(17);
        }
        AppConfigFilesImpl appConfigFiles = new AppConfigFilesImpl(appFixedFiles, LauncherContextFactory.findAppConfDirPath((AppFixedFiles)appFixedFiles));
        RuntimeUtil.createDirIfNeededAndCheckItIsWritable((File)appConfigFiles.getAppConfFolder(), (String)"config directory");
        AppConfigFilesImpl appConfigFilesImpl = appConfigFiles;
        if (appConfigFilesImpl == null) {
            LauncherContextFactory.$$$reportNull$$$0(18);
        }
        return appConfigFilesImpl;
    }

    @Nullable
    private static String findAppConfDirPath(@NotNull AppFixedFiles appFixedFiles) {
        if (appFixedFiles == null) {
            LauncherContextFactory.$$$reportNull$$$0(19);
        }
        for (AppConfigProvider appConfigProvider : PluginManager.getInstance().loadExtensions(AppConfigProvider.class)) {
            String appConfDirPath = appConfigProvider.getAppConfigFolderPath(appFixedFiles);
            if (appConfDirPath == null) continue;
            return appConfDirPath;
        }
        return null;
    }

    @NotNull
    public static AppConfig createAppConfig(@NotNull AppConfigFilesEx appConfigFiles) throws InitException {
        if (appConfigFiles == null) {
            LauncherContextFactory.$$$reportNull$$$0(20);
        }
        AppConfig appConfig = AppConfigImpl.parseConfig(appConfigFiles);
        if (appConfig == null) {
            LauncherContextFactory.$$$reportNull$$$0(21);
        }
        return appConfig;
    }

    @NotNull
    public static AppFilesEx createAppFiles(@NotNull AppConfigFilesEx appConfigFiles, @NotNull AppConfig appConfig) {
        if (appConfigFiles == null) {
            LauncherContextFactory.$$$reportNull$$$0(22);
        }
        if (appConfig == null) {
            LauncherContextFactory.$$$reportNull$$$0(23);
        }
        AppFilesImpl appFilesImpl = new AppFilesImpl(appConfigFiles, appConfig.getBaseDirPath(), appConfig.getAppLibDirPath(), appConfig.getAppLogsDirPath(), appConfig.getLauncherLogsDirPath());
        if (appFilesImpl == null) {
            LauncherContextFactory.$$$reportNull$$$0(24);
        }
        return appFilesImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 11: 
            case 16: 
            case 18: 
            case 21: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 11: 
            case 16: 
            case 18: 
            case 21: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coreArgs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdLine";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 11: 
            case 16: 
            case 18: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/LauncherContextFactory";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFilesAwareContext";
                break;
            }
            case 6: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appConfigFiles";
                break;
            }
            case 9: 
            case 14: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appConfig";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appFiles";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coreContext";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appFixedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/LauncherContextFactory";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createArguments";
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createContext";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createAppConfigFiles";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createAppConfig";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createAppFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createArguments";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 11: 
            case 16: 
            case 18: 
            case 21: 
            case 24: {
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createContext";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createAppConfigFiles";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findAppConfDirPath";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createAppConfig";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createAppFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 11: 
            case 16: 
            case 18: 
            case 21: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

