/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.configs;

import com.jetbrains.launcher.AppFixedFiles;
import com.jetbrains.launcher.AppFixedFilesEx;
import com.jetbrains.launcher.InitException;
import com.jetbrains.launcher.Resource;
import com.jetbrains.launcher.UserMessageTransformer;
import com.jetbrains.launcher.configs.LauncherConfigEx;
import com.jetbrains.launcher.util.PropertiesUtil;
import com.jetbrains.launcher.util.StringUtil;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

abstract class BaseLauncherConfig
extends LauncherConfigEx {
    BaseLauncherConfig() {
    }

    protected static abstract class BaseParser
    implements LauncherConfigEx.Parser {
        @NotNull
        private final Logger LOG = Logger.getLogger(BaseParser.class);

        protected BaseParser() {
        }

        @Override
        @NotNull
        public LauncherConfigEx parseConfig(@NotNull AppFixedFilesEx appFixedFiles) throws InitException {
            if (appFixedFiles == null) {
                BaseParser.$$$reportNull$$$0(0);
            }
            Resource configFile = this.getConfigFile(appFixedFiles);
            URL configFileUrl = configFile.getURL();
            this.LOG.debug((Object)UserMessageTransformer.transform((String)("Using launcher configuration file: " + configFileUrl.toExternalForm())));
            Properties ps = new Properties();
            try {
                PropertiesUtil.loadFromUrl((Properties)ps, (URL)configFileUrl);
            }
            catch (IOException e) {
                throw new InitException("Failed to read launcher configuration file \"" + configFileUrl.toExternalForm() + "\": " + e, (Throwable)e);
            }
            LauncherConfigEx launcherConfigEx = this.doParseConfig(new ParserContext(ps, (AppFixedFiles)appFixedFiles, configFileUrl));
            if (launcherConfigEx == null) {
                BaseParser.$$$reportNull$$$0(1);
            }
            return launcherConfigEx;
        }

        @Override
        @NotNull
        public Resource getConfigFile(@NotNull AppFixedFilesEx appFixedFiles) {
            if (appFixedFiles == null) {
                BaseParser.$$$reportNull$$$0(2);
            }
            Resource resource = appFixedFiles.resolveLauncherConfigFile(this.getConfigFileName());
            if (resource == null) {
                BaseParser.$$$reportNull$$$0(3);
            }
            return resource;
        }

        @NotNull
        protected abstract String getConfigFileName();

        @Override
        public boolean isApplicable(@NotNull AppFixedFilesEx appFixedFiles) {
            if (appFixedFiles == null) {
                BaseParser.$$$reportNull$$$0(4);
            }
            return this.getConfigFile(appFixedFiles).exists();
        }

        @NotNull
        protected abstract LauncherConfigEx doParseConfig(@NotNull ParserContext var1) throws InitException;

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "appFixedFiles";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/launcher/configs/BaseLauncherConfig$BaseParser";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/launcher/configs/BaseLauncherConfig$BaseParser";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parseConfig";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConfigFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "parseConfig";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getConfigFile";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isApplicable";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        protected static class ParserContext {
            @NotNull
            private final Properties myProperties;
            @NotNull
            private final AppFixedFiles myAppFixedFiles;
            @NotNull
            private final URL myConfigFileUrl;

            public ParserContext(@NotNull Properties properties, @NotNull AppFixedFiles appFixedFiles, @NotNull URL configFileUrl) {
                if (properties == null) {
                    ParserContext.$$$reportNull$$$0(0);
                }
                if (appFixedFiles == null) {
                    ParserContext.$$$reportNull$$$0(1);
                }
                if (configFileUrl == null) {
                    ParserContext.$$$reportNull$$$0(2);
                }
                this.myProperties = properties;
                this.myAppFixedFiles = appFixedFiles;
                this.myConfigFileUrl = configFileUrl;
            }

            @NotNull
            public Properties getProperties() {
                Properties properties = this.myProperties;
                if (properties == null) {
                    ParserContext.$$$reportNull$$$0(3);
                }
                return properties;
            }

            @NotNull
            public AppFixedFiles getAppFixedFiles() {
                AppFixedFiles appFixedFiles = this.myAppFixedFiles;
                if (appFixedFiles == null) {
                    ParserContext.$$$reportNull$$$0(4);
                }
                return appFixedFiles;
            }

            @NotNull
            public String checkProperty(@NotNull String propertyKey) throws InitException {
                String propertyValue;
                if (propertyKey == null) {
                    ParserContext.$$$reportNull$$$0(5);
                }
                if (StringUtil.isEmpty((String)(propertyValue = this.myProperties.getProperty(propertyKey)))) {
                    throw new InitException("Property \"" + propertyKey + "\" is not found or is empty in config file: " + this.myConfigFileUrl.toExternalForm());
                }
                String string = propertyValue;
                if (string == null) {
                    ParserContext.$$$reportNull$$$0(6);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 6: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 6: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "properties";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "appFixedFiles";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "configFileUrl";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/launcher/configs/BaseLauncherConfig$BaseParser$ParserContext";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "propertyKey";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/launcher/configs/BaseLauncherConfig$BaseParser$ParserContext";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getProperties";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getAppFixedFiles";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "checkProperty";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 6: {
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "checkProperty";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 6: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }
}

