/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.ep.commands;

import com.jetbrains.launcher.AppName;
import com.jetbrains.launcher.Arguments;
import com.jetbrains.launcher.LauncherContext;
import com.jetbrains.launcher.LauncherContextEx;
import com.jetbrains.launcher.LauncherExitCode;
import com.jetbrains.launcher.ep.Command;
import com.jetbrains.launcher.ep.commands.BaseCommand;
import com.jetbrains.launcher.log.LoggerMode;
import com.jetbrains.launcher.run.AgentRuntimeHelper;
import com.jetbrains.launcher.run.AgentStartFacade;
import com.jetbrains.launcher.run.UpToDateLauncherContext;
import com.jetbrains.launcher.util.ThreadUtil;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class Kill
extends BaseCommand {
    @NotNull
    private static final String NAME = "kill";
    @NotNull
    public static final String NO_LAUNCHER = "no-launcher";
    @NotNull
    private final Logger LOG = Logger.getLogger(Kill.class);

    @NotNull
    public String getName() {
        if (NAME == null) {
            Kill.$$$reportNull$$$0(0);
        }
        return NAME;
    }

    @Override
    @NotNull
    public String getOrderId() {
        if ("j" == null) {
            Kill.$$$reportNull$$$0(1);
        }
        return "j";
    }

    @Override
    protected void collectPossibleArgs(@NotNull Set<String> possibleArgs) {
        if (possibleArgs == null) {
            Kill.$$$reportNull$$$0(2);
        }
        possibleArgs.add(NO_LAUNCHER);
    }

    @Override
    @NotNull
    protected LoggerMode getLoggerMode(@NotNull Arguments args) {
        if (args == null) {
            Kill.$$$reportNull$$$0(3);
        }
        LoggerMode loggerMode = LoggerMode.LAUNCHER;
        if (loggerMode == null) {
            Kill.$$$reportNull$$$0(4);
        }
        return loggerMode;
    }

    @Override
    @NotNull
    protected LauncherExitCode doRun(@NotNull LauncherContextEx context) {
        if (context == null) {
            Kill.$$$reportNull$$$0(5);
        }
        AppName appName = context.getAppConfig().getAppName();
        AgentStartFacade agentFacade = context.createAgentFacade();
        if (agentFacade.kill() && (Kill.isNoLauncher(context.getArguments()) || agentFacade.waitForExit(10))) {
            Kill.afterRun(context);
            this.LOG.info((Object)(appName.getCapitalizedName() + " has been killed"));
            LauncherExitCode launcherExitCode = LauncherExitCode.OK;
            if (launcherExitCode == null) {
                Kill.$$$reportNull$$$0(6);
            }
            return launcherExitCode;
        }
        this.LOG.error((Object)("Failed to kill " + appName.getName()));
        LauncherExitCode launcherExitCode = LauncherExitCode.ERROR;
        if (launcherExitCode == null) {
            Kill.$$$reportNull$$$0(7);
        }
        return launcherExitCode;
    }

    protected static void afterRun(@NotNull LauncherContextEx context) {
        if (context == null) {
            Kill.$$$reportNull$$$0(8);
        }
        if (Kill.isNoLauncher(context.getArguments())) {
            new AgentRuntimeHelper(new UpToDateLauncherContext(context)).afterRun();
        } else {
            ThreadUtil.sleep((long)200L);
        }
    }

    protected static boolean isNoLauncher(@NotNull Arguments args) {
        if (args == null) {
            Kill.$$$reportNull$$$0(9);
        }
        return args.containsLauncherParam(NO_LAUNCHER);
    }

    public void printUsage(@NotNull Command.UsagePrinter printer, @NotNull LauncherContext context) {
        if (printer == null) {
            Kill.$$$reportNull$$$0(10);
        }
        if (context == null) {
            Kill.$$$reportNull$$$0(11);
        }
        printer.print(NAME, "kills " + context.getAppConfig().getAppName().getName() + " process");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/ep/commands/Kill";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleArgs";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderId";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/ep/commands/Kill";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoggerMode";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "doRun";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectPossibleArgs";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLoggerMode";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doRun";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "afterRun";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isNoLauncher";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "printUsage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

