/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.ep.commands;

import com.jetbrains.launcher.Arguments;
import com.jetbrains.launcher.InitException;
import com.jetbrains.launcher.LauncherContext;
import com.jetbrains.launcher.LauncherContextEx;
import com.jetbrains.launcher.LauncherExitCode;
import com.jetbrains.launcher.StatusDescriptor;
import com.jetbrains.launcher.ep.Command;
import com.jetbrains.launcher.ep.commands.BaseCommand;
import com.jetbrains.launcher.log.ConsoleLogger;
import com.jetbrains.launcher.log.LoggerMode;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Status
extends BaseCommand {
    @NotNull
    public static final String NAME = "status";
    @NotNull
    private static final String SHORT = "short";
    @NotNull
    private final Logger LOG = Logger.getLogger(Status.class);
    @Nullable
    private final String myParentCommandName;

    public Status() {
        this(null);
    }

    public Status(@Nullable String parentCommandName) {
        this.myParentCommandName = parentCommandName;
    }

    @NotNull
    public String getName() {
        if (NAME == null) {
            Status.$$$reportNull$$$0(0);
        }
        return NAME;
    }

    @Override
    @NotNull
    public String getFullName() {
        String string = this.myParentCommandName == null ? this.getName() : this.myParentCommandName + " " + this.getName();
        if (string == null) {
            Status.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String getOrderId() {
        if ("e" == null) {
            Status.$$$reportNull$$$0(2);
        }
        return "e";
    }

    @Override
    protected void collectPossibleArgs(@NotNull Set<String> possibleArgs) {
        if (possibleArgs == null) {
            Status.$$$reportNull$$$0(3);
        }
        possibleArgs.add(SHORT);
    }

    @Override
    @NotNull
    protected LoggerMode getLoggerMode(@NotNull Arguments args) {
        if (args == null) {
            Status.$$$reportNull$$$0(4);
        }
        LoggerMode loggerMode = Status.isShort(args) ? LoggerMode.CONSOLE_ERROR_ONLY : LoggerMode.CONSOLE_ONLY;
        if (loggerMode == null) {
            Status.$$$reportNull$$$0(5);
        }
        return loggerMode;
    }

    @Override
    @NotNull
    protected LauncherExitCode doRun(@NotNull LauncherContextEx context) throws InitException {
        if (context == null) {
            Status.$$$reportNull$$$0(6);
        }
        StatusDescriptor status = context.getStatus(true);
        if (Status.isShort(context.getArguments())) {
            ConsoleLogger.system((String)status.asString());
        } else {
            this.LOG.info((Object)status.asHumanReadableString(context.getAppConfig().getAppName().getCapitalizedName()));
        }
        LauncherExitCode launcherExitCode = status.isAlive() ? LauncherExitCode.OK : LauncherExitCode.NO;
        if (launcherExitCode == null) {
            Status.$$$reportNull$$$0(7);
        }
        return launcherExitCode;
    }

    private static boolean isShort(@NotNull Arguments args) {
        if (args == null) {
            Status.$$$reportNull$$$0(8);
        }
        return args.containsLauncherParam(SHORT);
    }

    public void printUsage(@NotNull Command.UsagePrinter printer, @NotNull LauncherContext context) {
        if (printer == null) {
            Status.$$$reportNull$$$0(9);
        }
        if (context == null) {
            Status.$$$reportNull$$$0(10);
        }
        if (this.myParentCommandName == null) {
            printer.print(this.getFullName(), "prints " + context.getAppConfig().getAppName().getName() + " status, " + this.getComplexCommandUsageText());
        } else {
            printer.print(this.getFullName(), "same as \"status\" command");
        }
    }

    @Override
    public void printStandaloneUsage(@NotNull Command.UsagePrinter printer, @NotNull LauncherContext context) {
        if (printer == null) {
            Status.$$$reportNull$$$0(11);
        }
        if (context == null) {
            Status.$$$reportNull$$$0(12);
        }
        String name = context.getAppConfig().getAppName().getName();
        printer.print(this.getFullName(), "prints " + name + " status (exits with code 0 if " + name + " is alive, 1 otherwise)");
        printer.print(this.getFullName() + " " + SHORT, "prints short and parsable " + name + " status (exits with code 0 if " + name + " is alive, 1 otherwise)");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/ep/commands/Status";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleArgs";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 6: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderId";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/ep/commands/Status";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoggerMode";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "doRun";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectPossibleArgs";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLoggerMode";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doRun";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isShort";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "printUsage";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "printStandaloneUsage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

