/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.ep.commands;

import com.jetbrains.launcher.AppFiles;
import com.jetbrains.launcher.Arguments;
import com.jetbrains.launcher.InitAction;
import com.jetbrains.launcher.InitException;
import com.jetbrains.launcher.LauncherContext;
import com.jetbrains.launcher.LauncherContextEx;
import com.jetbrains.launcher.LauncherExitCode;
import com.jetbrains.launcher.ep.Command;
import com.jetbrains.launcher.ep.commands.BaseCommand;
import com.jetbrains.launcher.lock.AppLockFactory;
import com.jetbrains.launcher.lock.AppState;
import com.jetbrains.launcher.log.LoggerMode;
import com.jetbrains.launcher.run.AgentRuntimeHelper;
import com.jetbrains.launcher.run.UpToDateLauncherContext;
import com.jetbrains.launcher.util.ExceptionUtil;
import com.jetbrains.launcher.util.ProcessUtil;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class Unlock
extends BaseCommand {
    @NotNull
    private static final String NAME = "unlock";
    @NotNull
    private final Logger LOG = Logger.getLogger(Unlock.class);

    @NotNull
    public String getName() {
        if (NAME == null) {
            Unlock.$$$reportNull$$$0(0);
        }
        return NAME;
    }

    @Override
    @NotNull
    public String getOrderId() {
        if ("z" == null) {
            Unlock.$$$reportNull$$$0(1);
        }
        return "z";
    }

    @Override
    @NotNull
    public Command.CommandType getType(@NotNull Arguments args) {
        if (args == null) {
            Unlock.$$$reportNull$$$0(2);
        }
        Command.CommandType commandType = Command.CommandType.SYSTEM_COMMAND;
        if (commandType == null) {
            Unlock.$$$reportNull$$$0(3);
        }
        return commandType;
    }

    @Override
    @NotNull
    protected LoggerMode getLoggerMode(@NotNull Arguments args) {
        if (args == null) {
            Unlock.$$$reportNull$$$0(4);
        }
        LoggerMode loggerMode = LoggerMode.LAUNCHER;
        if (loggerMode == null) {
            Unlock.$$$reportNull$$$0(5);
        }
        return loggerMode;
    }

    @Override
    @NotNull
    protected LauncherExitCode doRun(@NotNull LauncherContextEx context) throws InitException {
        LauncherExitCode launcherExitCode;
        AppState appState;
        if (context == null) {
            Unlock.$$$reportNull$$$0(6);
        }
        if ((appState = context.getAppState()) == null) {
            this.LOG.error((Object)(context.getAppConfig().getAppName().getCapitalizedName() + " is not locked"));
            LauncherExitCode launcherExitCode2 = LauncherExitCode.ILLEGAL_STATE;
            if (launcherExitCode2 == null) {
                Unlock.$$$reportNull$$$0(7);
            }
            return launcherExitCode2;
        }
        Integer launcherPid = AppLockFactory.createLockChecker(context).getLauncherPid();
        if (launcherPid == null) {
            this.LOG.error((Object)"Failed to determine launcher PID");
            LauncherExitCode launcherExitCode3 = LauncherExitCode.ERROR;
            if (launcherExitCode3 == null) {
                Unlock.$$$reportNull$$$0(8);
            }
            return launcherExitCode3;
        }
        try {
            int killCommandExitCode = ProcessUtil.kill((int)launcherPid);
            this.LOG.debug((Object)("Kill command exited with code " + killCommandExitCode));
            Unlock.tryToDeleteLockAndRuntimeFiles(context);
            launcherExitCode = LauncherExitCode.OK;
        }
        catch (IOException e) {
            ExceptionUtil.logError((Logger)this.LOG, (String)"Failed to kill launcher process", (Throwable)e);
            LauncherExitCode launcherExitCode4 = LauncherExitCode.ERROR;
            if (launcherExitCode4 == null) {
                Unlock.$$$reportNull$$$0(10);
            }
            return launcherExitCode4;
        }
        if (launcherExitCode == null) {
            Unlock.$$$reportNull$$$0(9);
        }
        return launcherExitCode;
    }

    private static void tryToDeleteLockAndRuntimeFiles(final @NotNull LauncherContextEx context) {
        if (context == null) {
            Unlock.$$$reportNull$$$0(11);
        }
        try {
            AppLockFactory.withLock(AppLockFactory.createLock((AppFiles)context.getAppFiles()), AppState.RUN, new InitAction(){

                @Override
                @NotNull
                public LauncherExitCode run() {
                    new AgentRuntimeHelper(new UpToDateLauncherContext(context)).afterRun();
                    LauncherExitCode launcherExitCode = LauncherExitCode.OK;
                    if (launcherExitCode == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return launcherExitCode;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/launcher/ep/commands/Unlock$1", "run"));
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void printUsage(@NotNull Command.UsagePrinter printer, @NotNull LauncherContext context) {
        if (printer == null) {
            Unlock.$$$reportNull$$$0(12);
        }
        if (context == null) {
            Unlock.$$$reportNull$$$0(13);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 11: 
            case 12: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/ep/commands/Unlock";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 6: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderId";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/ep/commands/Unlock";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoggerMode";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "doRun";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLoggerMode";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doRun";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "tryToDeleteLockAndRuntimeFiles";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "printUsage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

