/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.lock;

import com.jetbrains.launcher.InitException;
import com.jetbrains.launcher.lock.AppLock;
import com.jetbrains.launcher.lock.AppState;
import com.jetbrains.launcher.lock.CannotAcquireAppLockException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CompositeAppLock
implements AppLock {
    @NotNull
    private final AppLock myFirstLock;
    @NotNull
    private final AppLock mySecondLock;

    CompositeAppLock(@NotNull AppLock firstLock, @NotNull AppLock secondLock) {
        if (firstLock == null) {
            CompositeAppLock.$$$reportNull$$$0(0);
        }
        if (secondLock == null) {
            CompositeAppLock.$$$reportNull$$$0(1);
        }
        this.myFirstLock = firstLock;
        this.mySecondLock = secondLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lock(@NotNull AppState state) throws InitException, CannotAcquireAppLockException {
        if (state == null) {
            CompositeAppLock.$$$reportNull$$$0(2);
        }
        this.myFirstLock.lock(state);
        boolean locked = false;
        try {
            this.mySecondLock.lock(state);
            locked = true;
        }
        finally {
            if (!locked) {
                this.myFirstLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock() {
        try {
            this.mySecondLock.unlock();
        }
        finally {
            this.myFirstLock.unlock();
        }
    }

    @Override
    public boolean isLocked() throws InitException {
        return this.myFirstLock.isLocked() || this.mySecondLock.isLocked();
    }

    @Override
    @Nullable
    public AppState getState() throws InitException {
        AppState primaryState = this.myFirstLock.getState();
        return primaryState == null ? this.mySecondLock.getState() : primaryState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstLock";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondLock";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/launcher/lock/CompositeAppLock";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "lock";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

