/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.util.java;

import com.jetbrains.launcher.AppName;
import com.jetbrains.launcher.ProcessEnvironment;
import com.jetbrains.launcher.util.CmdUtil;
import com.jetbrains.launcher.util.FileUtil;
import com.jetbrains.launcher.util.JavaUtil;
import com.jetbrains.launcher.util.LauncherUtil;
import com.jetbrains.launcher.util.java.InvalidJvmOptionException;
import com.jetbrains.launcher.util.java.JvmOptionsMerger;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaCommandLineBuilder {
    @NotNull
    public static final String BOOTSTRAP_CLASS_NAME = "com.jetbrains.launcher.ep.Bootstrap";
    @NotNull
    private final File myWorkDir;
    @NotNull
    private final File myLibDir;
    @Nullable
    private final String myEntryPointKey;
    @NotNull
    private final List<String> myJvmOptions;
    @NotNull
    private final List<String> myProgramArgs;
    @NotNull
    private final Map<String, String> myEnvSystemProperties;
    private boolean myUseJavaw;

    public JavaCommandLineBuilder(@NotNull File workDir, @NotNull File libDir, @Nullable String entryPointKey) {
        if (workDir == null) {
            JavaCommandLineBuilder.$$$reportNull$$$0(0);
        }
        if (libDir == null) {
            JavaCommandLineBuilder.$$$reportNull$$$0(1);
        }
        this.myJvmOptions = new ArrayList<String>();
        this.myProgramArgs = new ArrayList<String>();
        this.myEnvSystemProperties = new HashMap<String, String>();
        this.myUseJavaw = false;
        this.myWorkDir = workDir;
        this.myLibDir = libDir;
        this.myEntryPointKey = entryPointKey;
    }

    public void addJvmOption(@NotNull String jvmOption) {
        if (jvmOption == null) {
            JavaCommandLineBuilder.$$$reportNull$$$0(2);
        }
        this.myJvmOptions.add(jvmOption);
    }

    public void addJvmOptions(@NotNull List<String> jvmOptions) {
        if (jvmOptions == null) {
            JavaCommandLineBuilder.$$$reportNull$$$0(3);
        }
        this.myJvmOptions.addAll(jvmOptions);
    }

    public void addJvmOptionsFromEnvVariable(@NotNull String variableName, String ... additionalJvmOptions) throws InvalidJvmOptionException {
        String variableValue;
        if (variableName == null) {
            JavaCommandLineBuilder.$$$reportNull$$$0(4);
        }
        if (additionalJvmOptions == null) {
            JavaCommandLineBuilder.$$$reportNull$$$0(5);
        }
        if ((variableValue = ProcessEnvironment.get((String)variableName)) != null) {
            List<String> jvmOptions = CmdUtil.parseCommandLine((String)variableValue);
            if (additionalJvmOptions.length > 0) {
                JvmOptionsMerger jvmOptionsMerger = new JvmOptionsMerger(null);
                jvmOptionsMerger.addJvmOptions(jvmOptions);
                jvmOptionsMerger.addJvmOptions(Arrays.asList(additionalJvmOptions));
                jvmOptions = jvmOptionsMerger.getJvmOptions();
            }
            this.addJvmOptions(jvmOptions);
        }
    }

    public void addEnvSystemPropertyIfNotNull(@NotNull String key, @Nullable String value) {
        if (key == null) {
            JavaCommandLineBuilder.$$$reportNull$$$0(6);
        }
        if (value != null) {
            this.addEnvSystemProperty(key, value);
        }
    }

    public void addEnvSystemProperty(@NotNull String key, @NotNull String value) {
        if (key == null) {
            JavaCommandLineBuilder.$$$reportNull$$$0(7);
        }
        if (value == null) {
            JavaCommandLineBuilder.$$$reportNull$$$0(8);
        }
        this.myEnvSystemProperties.put(key, value);
    }

    public void addEnvSystemProperties(@NotNull Map<String, String> systemProperties) {
        if (systemProperties == null) {
            JavaCommandLineBuilder.$$$reportNull$$$0(9);
        }
        this.myEnvSystemProperties.putAll(systemProperties);
    }

    public void addProgramArg(@NotNull String programArg) {
        if (programArg == null) {
            JavaCommandLineBuilder.$$$reportNull$$$0(10);
        }
        this.myProgramArgs.add(programArg);
    }

    public void addProgramArgs(@NotNull List<String> programArgs) {
        if (programArgs == null) {
            JavaCommandLineBuilder.$$$reportNull$$$0(11);
        }
        this.myProgramArgs.addAll(programArgs);
    }

    public void passAgentSystemPropertiesThrough() {
        Enumeration<?> propNames = System.getProperties().propertyNames();
        while (propNames.hasMoreElements()) {
            String propName = (String)propNames.nextElement();
            if (!propName.startsWith("agent.")) continue;
            this.doPassSystemPropertyThrough(propName);
        }
    }

    public void passLauncherSystemPropertiesThrough() {
        this.passSystemPropertiesThrough("launcher.dev.mode");
    }

    public void passSystemPropertiesThrough(String ... propertyNames) {
        if (propertyNames == null) {
            JavaCommandLineBuilder.$$$reportNull$$$0(12);
        }
        for (String propertyName : propertyNames) {
            this.doPassSystemPropertyThrough(propertyName);
        }
    }

    private void doPassSystemPropertyThrough(@NotNull String propertyName) {
        String propertyValue;
        if (propertyName == null) {
            JavaCommandLineBuilder.$$$reportNull$$$0(13);
        }
        if ((propertyValue = System.getProperty(propertyName)) != null) {
            this.addEnvSystemProperty(propertyName, propertyValue);
        }
    }

    public void setDebugOptionsIfSpecified() {
        String debugPort = System.getProperty("agent.debug.port");
        if (debugPort != null) {
            this.addJvmOption("-Xdebug");
            this.addJvmOption("-Xnoagent");
            this.addJvmOption("-Djava.compiler=NONE");
            String suspendMode = System.getProperty("agent.debug.suspend");
            if (!"n".equals(suspendMode) && !"y".equals(suspendMode)) {
                suspendMode = "n";
            }
            this.addJvmOption("-Xrunjdwp:transport=dt_socket,server=y,suspend=" + suspendMode + ",address=" + debugPort);
        }
    }

    public void setUseJavaw(boolean useJavaw) {
        this.myUseJavaw = useJavaw;
    }

    @NotNull
    public List<String> build(@NotNull AppName appName, @NotNull File appHome) throws FileNotFoundException {
        if (appName == null) {
            JavaCommandLineBuilder.$$$reportNull$$$0(14);
        }
        if (appHome == null) {
            JavaCommandLineBuilder.$$$reportNull$$$0(15);
        }
        ArrayList<String> cmdLine = new ArrayList<String>();
        cmdLine.add(JavaUtil.getCurrentJavaExecutablePath((boolean)this.myUseJavaw));
        this.appendJvmOptionsTo(cmdLine, appName, appHome);
        File jarToLaunch = LauncherUtil.findJarByClass(this.myLibDir, BOOTSTRAP_CLASS_NAME);
        cmdLine.add("-jar");
        cmdLine.add(FileUtil.getShortPath((File)this.myWorkDir, (File)jarToLaunch));
        this.appendProgramArgsTo(cmdLine);
        ArrayList<String> arrayList = cmdLine;
        if (arrayList == null) {
            JavaCommandLineBuilder.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    private void appendJvmOptionsTo(@NotNull List<String> cmdLine, @NotNull AppName appName, @NotNull File appHome) {
        if (cmdLine == null) {
            JavaCommandLineBuilder.$$$reportNull$$$0(17);
        }
        if (appName == null) {
            JavaCommandLineBuilder.$$$reportNull$$$0(18);
        }
        if (appHome == null) {
            JavaCommandLineBuilder.$$$reportNull$$$0(19);
        }
        cmdLine.add("-Djl.service=" + appName.getAllWordsCapitalizedName());
        cmdLine.add("-Djl.home=" + appHome.getAbsolutePath());
        cmdLine.addAll(this.myJvmOptions);
    }

    private void appendProgramArgsTo(@NotNull List<String> cmdLine) {
        if (cmdLine == null) {
            JavaCommandLineBuilder.$$$reportNull$$$0(20);
        }
        if (this.myEntryPointKey != null) {
            cmdLine.add(this.myEntryPointKey);
        }
        cmdLine.addAll(this.myProgramArgs);
    }

    @NotNull
    public Map<String, String> getEnvSystemProperties() {
        Map<String, String> map = Collections.unmodifiableMap(this.myEnvSystemProperties);
        if (map == null) {
            JavaCommandLineBuilder.$$$reportNull$$$0(21);
        }
        return map;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workDir";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libDir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jvmOption";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jvmOptions";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalJvmOptions";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemProperties";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "programArg";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "programArgs";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyNames";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appName";
                break;
            }
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appHome";
                break;
            }
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/util/java/JavaCommandLineBuilder";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/util/java/JavaCommandLineBuilder";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvSystemProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addJvmOption";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addJvmOptions";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addJvmOptionsFromEnvVariable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addEnvSystemPropertyIfNotNull";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addEnvSystemProperty";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addEnvSystemProperties";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addProgramArg";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addProgramArgs";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "passSystemPropertiesThrough";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doPassSystemPropertyThrough";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 16: 
            case 21: {
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "appendJvmOptionsTo";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "appendProgramArgsTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

