/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.util.java;

import com.jetbrains.launcher.util.FileUtil;
import com.jetbrains.launcher.util.OptionsProcessor;
import com.jetbrains.launcher.util.java.InvalidJvmOptionException;
import com.jetbrains.launcher.util.java.JvmOptionsMerger;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JvmOptionsUtil {
    public static void fixJvmOptions(@NotNull File file, @NotNull List<String> newJvmOptions) throws IOException, InvalidJvmOptionException {
        if (file == null) {
            JvmOptionsUtil.$$$reportNull$$$0(0);
        }
        if (newJvmOptions == null) {
            JvmOptionsUtil.$$$reportNull$$$0(1);
        }
        List<String> lines = FileUtil.readLines((File)file);
        lines = JvmOptionsUtil.doFixJvmOptions(lines, newJvmOptions);
        FileUtil.writeLines((File)file, lines);
    }

    @NotNull
    public static List<String> doFixJvmOptions(@NotNull List<String> lines, @NotNull List<String> newJvmOptions) throws InvalidJvmOptionException {
        if (lines == null) {
            JvmOptionsUtil.$$$reportNull$$$0(2);
        }
        if (newJvmOptions == null) {
            JvmOptionsUtil.$$$reportNull$$$0(3);
        }
        JvmOptionsMerger parser = new JvmOptionsMerger(null);
        LinkedHashMap<String, JvmOptionsMerger.Option> newJvmOptionsMap = new LinkedHashMap<String, JvmOptionsMerger.Option>();
        for (String newJvmOption : newJvmOptions) {
            JvmOptionsMerger.Option option = parser.parseOption(newJvmOption);
            if (option == null) continue;
            newJvmOptionsMap.put(option.getKey(), option);
        }
        List list = new JvmOptionsProcessor(newJvmOptionsMap, parser).processOptionLines(lines);
        if (list == null) {
            JvmOptionsUtil.$$$reportNull$$$0(4);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newJvmOptions";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/util/java/JvmOptionsUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/util/java/JvmOptionsUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "doFixJvmOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fixJvmOptions";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doFixJvmOptions";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ParsedJvmOptionLine
    implements OptionsProcessor.ParsedLine<ParsedJvmOptionLine, JvmOptionsMerger.Option> {
        @NotNull
        private final String myRawLine;
        @Nullable
        private final JvmOptionsMerger.Option myOption;
        private final boolean myIsCommented;

        public ParsedJvmOptionLine(@NotNull String rawLine, @Nullable JvmOptionsMerger.Option option, boolean isCommented) {
            if (rawLine == null) {
                ParsedJvmOptionLine.$$$reportNull$$$0(0);
            }
            this.myRawLine = rawLine;
            this.myOption = option;
            this.myIsCommented = isCommented;
        }

        public boolean isCommented() {
            return this.myIsCommented;
        }

        public boolean isRemovingLine() {
            return this.myOption != null && this.myOption.isOptionToRemove();
        }

        @Nullable
        public String getKey() {
            return this.myOption == null ? null : this.myOption.getKey();
        }

        @NotNull
        public String getRawLine() {
            String string = this.myRawLine;
            if (string == null) {
                ParsedJvmOptionLine.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public ParsedJvmOptionLine commentOut() {
            ParsedJvmOptionLine parsedJvmOptionLine = this.myIsCommented ? this : new ParsedJvmOptionLine("#" + this.myRawLine, this.myOption, true);
            if (parsedJvmOptionLine == null) {
                ParsedJvmOptionLine.$$$reportNull$$$0(2);
            }
            return parsedJvmOptionLine;
        }

        public boolean hasSameValue(@NotNull JvmOptionsMerger.Option option) {
            if (option == null) {
                ParsedJvmOptionLine.$$$reportNull$$$0(3);
            }
            if (this.myOption == null) {
                return false;
            }
            String myValue = this.myOption.getValue();
            String thatValue = option.getValue();
            return myValue == null ? thatValue == null : myValue.equals(thatValue);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rawLine";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/launcher/util/java/JvmOptionsUtil$ParsedJvmOptionLine";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "option";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/launcher/util/java/JvmOptionsUtil$ParsedJvmOptionLine";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRawLine";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "commentOut";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "hasSameValue";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class JvmOptionsProcessor
    extends OptionsProcessor<JvmOptionsMerger.Option, ParsedJvmOptionLine, InvalidJvmOptionException> {
        @NotNull
        private final JvmOptionsMerger myParser;

        private JvmOptionsProcessor(@NotNull Map<String, JvmOptionsMerger.Option> newJvmOptions, @NotNull JvmOptionsMerger parser) {
            if (newJvmOptions == null) {
                JvmOptionsProcessor.$$$reportNull$$$0(0);
            }
            if (parser == null) {
                JvmOptionsProcessor.$$$reportNull$$$0(1);
            }
            super(newJvmOptions, false);
            this.myParser = parser;
        }

        @NotNull
        protected String getCommentPrefix() {
            if ("#" == null) {
                JvmOptionsProcessor.$$$reportNull$$$0(2);
            }
            return "#";
        }

        @NotNull
        protected ParsedJvmOptionLine doParseLine(@NotNull String line, @NotNull String actualLine, boolean isCommented) throws InvalidJvmOptionException {
            ParsedJvmOptionLine parsedJvmOptionLine;
            block6: {
                if (line == null) {
                    JvmOptionsProcessor.$$$reportNull$$$0(3);
                }
                if (actualLine == null) {
                    JvmOptionsProcessor.$$$reportNull$$$0(4);
                }
                try {
                    parsedJvmOptionLine = new ParsedJvmOptionLine(line, this.myParser.parseOption(actualLine), isCommented);
                    if (parsedJvmOptionLine != null) break block6;
                }
                catch (InvalidJvmOptionException e) {
                    if (isCommented) {
                        ParsedJvmOptionLine parsedJvmOptionLine2 = new ParsedJvmOptionLine(line, null, true);
                        if (parsedJvmOptionLine2 == null) {
                            JvmOptionsProcessor.$$$reportNull$$$0(6);
                        }
                        return parsedJvmOptionLine2;
                    }
                    throw e;
                }
                JvmOptionsProcessor.$$$reportNull$$$0(5);
            }
            return parsedJvmOptionLine;
        }

        protected boolean isOptionToRemove(@Nullable JvmOptionsMerger.Option option) {
            return option == null || option.isOptionToRemove();
        }

        @NotNull
        protected ParsedJvmOptionLine createLine(@NotNull String key, @NotNull JvmOptionsMerger.Option option) {
            if (key == null) {
                JvmOptionsProcessor.$$$reportNull$$$0(7);
            }
            if (option == null) {
                JvmOptionsProcessor.$$$reportNull$$$0(8);
            }
            ParsedJvmOptionLine parsedJvmOptionLine = new ParsedJvmOptionLine(option.asRawString(), option, false);
            if (parsedJvmOptionLine == null) {
                JvmOptionsProcessor.$$$reportNull$$$0(9);
            }
            return parsedJvmOptionLine;
        }

        protected boolean addRemovingLines() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newJvmOptions";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parser";
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/launcher/util/java/JvmOptionsUtil$JvmOptionsProcessor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actualLine";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "option";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/launcher/util/java/JvmOptionsUtil$JvmOptionsProcessor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommentPrefix";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doParseLine";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createLine";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 9: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "doParseLine";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "createLine";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

