/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.service.util;

import com.jetbrains.service.util.SortedProperties;
import com.jetbrains.service.util.StatusException;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertiesUtil {
    @NotNull
    public static Properties loadProperties(File propertiesFile) throws IOException {
        if (propertiesFile == null) {
            return new Properties();
        }
        return PropertiesUtil.loadProperties(new FileInputStream(propertiesFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Properties loadProperties(@Nullable InputStream inputStream) throws IOException {
        Properties properties;
        if (inputStream == null) {
            return new Properties();
        }
        BufferedInputStream inStream = null;
        try {
            inStream = new BufferedInputStream(inputStream);
            Properties properties2 = new Properties();
            properties2.load(inStream);
            properties = properties2;
        }
        catch (Throwable throwable) {
            PropertiesUtil.close(inStream);
            throw throwable;
        }
        PropertiesUtil.close(inStream);
        return properties;
    }

    private static void close(Closeable cl) {
        if (cl != null) {
            try {
                cl.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void saveConfig(@NotNull Path configPath, @NotNull Properties properties, String propertiesComment, boolean createBackUp) {
        if (createBackUp) {
            // empty if block
        }
        SortedProperties sortedProperties = new SortedProperties();
        sortedProperties.putAll((Map<?, ?>)properties);
        OutputStream os = null;
        try {
            File parentFile = configPath.getParent().toFile();
            parentFile.mkdirs();
            if (!parentFile.isDirectory()) {
                throw new StatusException("Could create config directory " + configPath.getParent());
            }
            os = Files.newOutputStream(configPath, new OpenOption[0]);
            sortedProperties.store(os, propertiesComment);
        }
        catch (IOException e) {
            throw new StatusException("Could not save config to " + configPath + ": " + e.getMessage());
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @NotNull
    public static Properties convertToProperties(Map<String, String> sourceMap) {
        Properties properties = new Properties();
        PropertiesUtil.putFromMapToProperties(sourceMap, properties);
        return properties;
    }

    public static void putFromMapToProperties(Map<String, String> sourceMap, @NotNull Properties properties) {
        if (sourceMap == null) {
            return;
        }
        for (String property : sourceMap.keySet()) {
            String value = sourceMap.get(property);
            if (value == null) continue;
            properties.setProperty(property, value);
        }
    }

    public static boolean isEqual(String s1, String s2) {
        return s1 == null && s2 == null || s1 != null && s1.equals(s2);
    }

    public static void setPropertyIfNotNull(@NotNull Properties properties, @NotNull String property, @Nullable String value) {
        if (value != null) {
            properties.setProperty(property, value);
        }
    }
}

