/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.service.util;

import com.jetbrains.service.util.Version;

public class VersionInterval {
    private final Version low;
    private final Version high;

    public VersionInterval(Version low, Version high) {
        this.low = low;
        this.high = high;
    }

    public boolean contains(Version version) {
        return this.contains(version, false);
    }

    public boolean contains(Version version, boolean inclusively) {
        if (version == null) {
            return false;
        }
        return (this.low == null || (inclusively ? this.low.isLesserOrEqual(version) : this.low.isLesser(version))) && (this.high == null || (inclusively ? this.high.isGreaterOrEqual(version) : this.high.isGreater(version)));
    }

    public Version getLow() {
        return this.low;
    }

    public Version getHigh() {
        return this.high;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VersionInterval)) {
            return false;
        }
        VersionInterval that = (VersionInterval)o;
        if (this.low != null ? !this.low.equals(that.low) : that.low != null) {
            return false;
        }
        return this.high != null ? this.high.equals(that.high) : that.high == null;
    }

    public int hashCode() {
        int result = this.low != null ? this.low.hashCode() : 0;
        result = 31 * result + (this.high != null ? this.high.hashCode() : 0);
        return result;
    }
}

