/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.ep.commands;

import com.jetbrains.launcher.AppConfigFiles;
import com.jetbrains.launcher.AppFiles;
import com.jetbrains.launcher.AppFilesEx;
import com.jetbrains.launcher.LauncherContext;
import com.jetbrains.launcher.LauncherExitCode;
import com.jetbrains.launcher.SystemInfo;
import com.jetbrains.launcher.configs.AppConfig;
import com.jetbrains.launcher.ep.commands.BaseProcessBasedCommand;
import com.jetbrains.launcher.ep.commands.BaseServiceSubCommand;
import com.jetbrains.launcher.ep.commands.WinServiceUninstall;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class BaseWinServiceSubCommand
extends BaseServiceSubCommand {
    @NotNull
    private static final String SERVICE_NAME_PREFIX = "<name>";
    @NotNull
    private static final String SERVICE_NAME_SUFFIX = "</name>";
    @NotNull
    private final Logger LOG = Logger.getLogger(BaseWinServiceSubCommand.class);

    BaseWinServiceSubCommand() {
    }

    @NotNull
    protected String getServiceCommandName() {
        if ("service" == null) {
            BaseWinServiceSubCommand.$$$reportNull$$$0(0);
        }
        return "service";
    }

    @NotNull
    protected String getServiceTypeName() {
        if ("service" == null) {
            BaseWinServiceSubCommand.$$$reportNull$$$0(1);
        }
        return "service";
    }

    @NotNull
    protected String getServiceNameName() {
        if ("name" == null) {
            BaseWinServiceSubCommand.$$$reportNull$$$0(2);
        }
        return "name";
    }

    @NotNull
    protected BaseServiceSubCommand createServiceUninstallCommand() {
        WinServiceUninstall winServiceUninstall = new WinServiceUninstall();
        if (winServiceUninstall == null) {
            BaseWinServiceSubCommand.$$$reportNull$$$0(3);
        }
        return winServiceUninstall;
    }

    @Nullable
    protected String doGetOldServiceName(@NotNull String configText) {
        int prefixPos;
        if (configText == null) {
            BaseWinServiceSubCommand.$$$reportNull$$$0(4);
        }
        if ((prefixPos = configText.indexOf(SERVICE_NAME_PREFIX)) == -1) {
            return null;
        }
        int serviceNameStartPos = prefixPos + SERVICE_NAME_PREFIX.length();
        int suffixPos = configText.indexOf(SERVICE_NAME_SUFFIX, serviceNameStartPos);
        if (suffixPos == -1) {
            return null;
        }
        return configText.substring(serviceNameStartPos, suffixPos).trim();
    }

    @NotNull
    protected String getCurrentServiceName(@NotNull LauncherContext context) {
        if (context == null) {
            BaseWinServiceSubCommand.$$$reportNull$$$0(5);
        }
        String string = context.getAppConfig().getWinServiceName();
        if (string == null) {
            BaseWinServiceSubCommand.$$$reportNull$$$0(6);
        }
        return string;
    }

    protected boolean serviceExists(@NotNull LauncherContext context, @NotNull String serviceName, boolean defaultValue) {
        if (context == null) {
            BaseWinServiceSubCommand.$$$reportNull$$$0(7);
        }
        if (serviceName == null) {
            BaseWinServiceSubCommand.$$$reportNull$$$0(8);
        }
        if (SystemInfo.isWindowsXP) {
            return defaultValue;
        }
        List<String> command = Arrays.asList("sc.exe", "GetDisplayName", serviceName);
        return BaseWinServiceSubCommand.runProcess((File)context.getAppFiles().getAppHome(), command, (boolean)true, (Logger)this.LOG, (BaseProcessBasedCommand.ExitCodeConverter)BaseProcessBasedCommand.ExitCodeConverter.DEFAULT) == LauncherExitCode.OK;
    }

    @NotNull
    protected String getServiceConfigDistFileName() {
        if ("launcher.win.service.settings.xml.dist" == null) {
            BaseWinServiceSubCommand.$$$reportNull$$$0(9);
        }
        return "launcher.win.service.settings.xml.dist";
    }

    @NotNull
    public File getServiceConfigFile(@NotNull AppConfigFiles appConfigFiles) {
        if (appConfigFiles == null) {
            BaseWinServiceSubCommand.$$$reportNull$$$0(10);
        }
        File file = appConfigFiles.getWinServiceConfigFile();
        if (file == null) {
            BaseWinServiceSubCommand.$$$reportNull$$$0(11);
        }
        return file;
    }

    @NotNull
    protected String prepareConfigText(@NotNull String text, @NotNull File serviceConfigFile, @NotNull LauncherContext context) throws IOException {
        File serviceBaseDir;
        if (text == null) {
            BaseWinServiceSubCommand.$$$reportNull$$$0(12);
        }
        if (serviceConfigFile == null) {
            BaseWinServiceSubCommand.$$$reportNull$$$0(13);
        }
        if (context == null) {
            BaseWinServiceSubCommand.$$$reportNull$$$0(14);
        }
        if ((serviceBaseDir = serviceConfigFile.getParentFile()) == null) {
            throw new IOException("Failed to get parent file for: " + serviceConfigFile.getAbsolutePath());
        }
        AppFilesEx appFiles = context.getAppFiles();
        AppConfig appConfig = context.getAppConfig();
        String string = text.replace("#%$!-WIN-SERVICE-NAME-!$%#", appConfig.getWinServiceName()).replace("#%$!-APP-DISPLAY-NAME-!$%#", appConfig.getAppName().getName()).replace("#%$!-APP-DESCRIPTION-!$%#", appConfig.getAppDescription()).replace("#%$!-LOGS-DIR-!$%#", BaseWinServiceSubCommand.getServiceLogsDirPath((AppFiles)appFiles, serviceBaseDir)).replace("#%$!-STARTED-MARKER-!$%#", "###-STARTED-f0SJK3P4wGKm6dOdWlouxGHLBO5Pogsbq27V7h9M-###").replace("#%$!-STOP-TIMEOUT-MINUTES-!$%#", String.valueOf(appConfig.getStopTimeoutSeconds() / 60 + 1)).replace("#%$!-WORK-DIR-!$%#", BaseWinServiceSubCommand.getServiceWorkDirPath((AppFiles)appFiles, serviceBaseDir));
        if (string == null) {
            BaseWinServiceSubCommand.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    private static String getServiceLogsDirPath(@NotNull AppFiles appFiles, @NotNull File serviceBaseDir) {
        if (appFiles == null) {
            BaseWinServiceSubCommand.$$$reportNull$$$0(16);
        }
        if (serviceBaseDir == null) {
            BaseWinServiceSubCommand.$$$reportNull$$$0(17);
        }
        String string = BaseWinServiceSubCommand.getServiceFilePath(appFiles, serviceBaseDir, appFiles.getLauncherLogsFolder());
        if (string == null) {
            BaseWinServiceSubCommand.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    private static String getServiceWorkDirPath(@NotNull AppFiles appFiles, @NotNull File serviceBaseDir) {
        if (appFiles == null) {
            BaseWinServiceSubCommand.$$$reportNull$$$0(19);
        }
        if (serviceBaseDir == null) {
            BaseWinServiceSubCommand.$$$reportNull$$$0(20);
        }
        String string = BaseWinServiceSubCommand.getServiceFilePath(appFiles, serviceBaseDir, appFiles.getAppHome());
        if (string == null) {
            BaseWinServiceSubCommand.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    private static String getServiceFilePath(@NotNull AppFiles appFiles, @NotNull File serviceBaseDir, @NotNull File serviceFile) {
        if (appFiles == null) {
            BaseWinServiceSubCommand.$$$reportNull$$$0(22);
        }
        if (serviceBaseDir == null) {
            BaseWinServiceSubCommand.$$$reportNull$$$0(23);
        }
        if (serviceFile == null) {
            BaseWinServiceSubCommand.$$$reportNull$$$0(24);
        }
        String string = appFiles.getBaseFiles().getMovingSafePath(serviceBaseDir, serviceFile);
        if (string == null) {
            BaseWinServiceSubCommand.$$$reportNull$$$0(25);
        }
        return string;
    }

    @NotNull
    protected static List<String> getNetExeCmdLine(final @NotNull LauncherContext context, final @NotNull String command) {
        if (context == null) {
            BaseWinServiceSubCommand.$$$reportNull$$$0(26);
        }
        if (command == null) {
            BaseWinServiceSubCommand.$$$reportNull$$$0(27);
        }
        ArrayList<String> arrayList = new ArrayList<String>(){
            {
                this.add("net.exe");
                this.add(command);
                this.add(context.getAppConfig().getWinServiceName());
            }
        };
        if (arrayList == null) {
            BaseWinServiceSubCommand.$$$reportNull$$$0(28);
        }
        return arrayList;
    }

    @NotNull
    protected static List<String> getJetServiceCmdLine(final @NotNull LauncherContext context, final @NotNull String command) {
        if (context == null) {
            BaseWinServiceSubCommand.$$$reportNull$$$0(29);
        }
        if (command == null) {
            BaseWinServiceSubCommand.$$$reportNull$$$0(30);
        }
        ArrayList<String> arrayList = new ArrayList<String>(){
            {
                AppFilesEx appFiles = context.getAppFiles();
                this.add(appFiles.getJetServiceExecutable().getAbsolutePath());
                this.add(command);
                this.add("/settings=" + appFiles.getWinServiceConfigFile().getAbsolutePath());
                this.addAll(context.getArguments().getApplicationArguments());
            }
        };
        if (arrayList == null) {
            BaseWinServiceSubCommand.$$$reportNull$$$0(31);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 30: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 30: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/ep/commands/BaseWinServiceSubCommand";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configText";
                break;
            }
            case 5: 
            case 7: 
            case 14: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appConfigFiles";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceConfigFile";
                break;
            }
            case 16: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appFiles";
                break;
            }
            case 17: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceBaseDir";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceFile";
                break;
            }
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getServiceCommandName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getServiceTypeName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getServiceNameName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createServiceUninstallCommand";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/ep/commands/BaseWinServiceSubCommand";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentServiceName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getServiceConfigDistFileName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getServiceConfigFile";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareConfigText";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getServiceLogsDirPath";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getServiceWorkDirPath";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getServiceFilePath";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getNetExeCmdLine";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getJetServiceCmdLine";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doGetOldServiceName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentServiceName";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "serviceExists";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getServiceConfigFile";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "prepareConfigText";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getServiceLogsDirPath";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getServiceWorkDirPath";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getServiceFilePath";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getNetExeCmdLine";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getJetServiceCmdLine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 30: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

