/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.service.jetty;

import com.jetbrains.launcher.AppExitCode;
import com.jetbrains.launcher.LogLevel;
import com.jetbrains.launcher.Status;
import com.jetbrains.launcher.StatusDescriptor;
import com.jetbrains.launcher.exceptions.ConfiguringException;
import com.jetbrains.launcher.exceptions.StartupException;
import com.jetbrains.service.jetty.context.CommonContextProvider;
import com.jetbrains.service.jetty.context.ConfiguringContextProvider;
import com.jetbrains.service.jetty.context.StartupContextProvider;
import com.jetbrains.service.util.BundleProperty;
import com.jetbrains.service.util.ConfiguratorUtils;
import com.jetbrains.service.util.PropertiesUtil;
import com.jetbrains.service.util.ServiceProperties;
import com.jetbrains.service.util.StatusException;
import com.jetbrains.service.util.SystemUtil;
import com.jetbrains.service.util.logging.JavaUtilLoggingToSlf4jBridge;
import com.jetbrains.service.util.logging.log4j.LoggingUtil;
import com.jetbrains.service.util.properties.impl.PropertiesBasedConfigurationHelper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JettyServiceBase {
    public static final String CONVENIENT_SERVICE_CONFIG_PROPERTIES = "service-config.properties";
    public static final String CONVENIENT_BUNDLE_IN_PROCESS_SERVICE_CONFIG_PATH_PROPERTY = "bundle-in-process-service-config-path";
    public static final String CONF_FOLDER_PROPERTY = "service-conf-folder";
    private volatile Server myServer;
    private final AtomicReference<Status> myStatus = new AtomicReference<Status>(Status.STARTING);
    public static final String SERVICE_CONFIG_PROPERTIES = "service-config.properties";
    private static final long GRACEFUL_STOP_TIMEOUT_MS = 5000L;
    private volatile CommonContextProvider myConfigurationProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(@NotNull ConfiguringContextProvider contextProvider) throws ConfiguringException {
        this.myConfigurationProvider = contextProvider;
        try {
            LoggingUtil.setupConsoleLogging((contextProvider.getLogLevel() == LogLevel.DEBUG ? 1 : 0) != 0);
            Properties commandLineProperties = this.getCommandLineProperties(contextProvider);
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)this.getDefaultProperties());
            Properties existingProperties = this.getAllProperties();
            this.removeOneTimeProperties(existingProperties, commandLineProperties);
            properties.putAll((Map<?, ?>)existingProperties);
            properties.putAll((Map<?, ?>)commandLineProperties);
            properties.setProperty(CONF_FOLDER_PROPERTY, contextProvider.getAppConfFolder().getAbsolutePath());
            this.configure(properties);
        }
        finally {
            this.myConfigurationProvider = null;
        }
    }

    private void removeOneTimeProperties(@NotNull Properties allProperties, @NotNull Properties cliProperties) {
        Collection allServices = PropertiesBasedConfigurationHelper.getHelper().getServices((Object)allProperties);
        for (String property : this.getOneTimeProperties(cliProperties)) {
            allProperties.remove(property);
            if (property.startsWith("bundle.")) continue;
            for (String serviceId : allServices) {
                allProperties.remove(PropertiesBasedConfigurationHelper.getHelper().getPrefixedPropertyName(serviceId, property));
            }
        }
    }

    protected List<String> getOneTimeProperties(@NotNull Properties cliProperties) {
        ArrayList<String> oneTimeProperties = new ArrayList<String>();
        oneTimeProperties.add("bundledin");
        if (cliProperties.containsKey(BundleProperty.INSTALLATION_UUID.getPrefixedName())) {
            oneTimeProperties.addAll(Arrays.asList("license-key", "license-user-name", "hub-url", BundleProperty.HUB_URL.getPrefixedName(), BundleProperty.LOCALE.getPrefixedName(), BundleProperty.ROOT_PASSWORD.getPrefixedName()));
        }
        return oneTimeProperties;
    }

    @NotNull
    protected Properties getCommandLineProperties(ConfiguringContextProvider serviceConfigurationProvider) throws ConfiguringException {
        return PropertiesUtil.convertToProperties(serviceConfigurationProvider.getNewProperties());
    }

    public final void configure(@NotNull Properties properties, @NotNull CommonContextProvider serviceConfigurationProvider) {
        this.myConfigurationProvider = serviceConfigurationProvider;
        try {
            this.configure(properties);
        }
        finally {
            this.myConfigurationProvider = null;
        }
    }

    public void start(@NotNull StartupContextProvider contextProvider) throws StartupException {
        this.myConfigurationProvider = contextProvider;
        boolean isLoggingSystemConfigured = LoggingUtil.isConfigured();
        Properties properties = this.getAllProperties();
        try {
            String bundledInProperty = properties.getProperty("bundledin");
            if (bundledInProperty != null) {
                throw new StartupException("This service is configured to be started together with Bundle process. You might start entire product instead of starting this particular service separately.");
            }
            this.beforeStart(properties);
            this.configureLoggingForStarting(properties, isLoggingSystemConfigured, contextProvider);
            this.setTempDir(properties);
            this.myServer = this.createServer(properties);
            this.myStatus.set(Status.STARTING);
            this.myServer.start();
            if (!this.myServer.isStarted()) {
                throw new StartupException("Something went wrong. Server not started.");
            }
            this.myStatus.set(Status.RUNNING);
            this.onStarted(properties);
        }
        catch (Throwable ex) {
            throw new StartupException(ex.getMessage(), ex);
        }
        finally {
            this.configureLoggingAfterStarted(properties, isLoggingSystemConfigured, contextProvider);
        }
    }

    protected void beforeStart(@NotNull Properties properties) {
    }

    protected void onStarted(@NotNull Properties properties) {
    }

    private void configureLoggingForStarting(Properties properties, boolean isLoggingSystemConfigured, @NotNull StartupContextProvider contextProvider) {
        JavaUtilLoggingToSlf4jBridge.install();
        if (!isLoggingSystemConfigured) {
            this.setupLogging(properties, this.isDebugEnabled(contextProvider), true);
        }
    }

    protected void configureLoggingAfterStarted(Properties properties, boolean isLoggingSystemConfigured, @NotNull StartupContextProvider contextProvider) {
        if (!isLoggingSystemConfigured) {
            this.setupLogging(properties, this.isDebugEnabled(contextProvider), false);
        }
    }

    protected Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }

    @NotNull
    public StatusDescriptor getStatus() {
        return new StatusDescriptor(this.myStatus.get(), null);
    }

    public AppExitCode shutdown(boolean force, AppExitCode suggestedExitCode) {
        if (this.myServer != null) {
            this.getLogger().info(String.format("Stopping %s", this.getServicePresentableName(this.getAllProperties())));
            this.myStatus.set(Status.SHUTTING_DOWN);
            this.myServer.setStopTimeout(force ? 0L : 5000L);
            try {
                this.myServer.stop();
            }
            catch (Throwable e) {
                this.getLogger().error("Could not stop Jetty", e);
            }
            this.myServer = null;
            this.myConfigurationProvider = null;
        }
        return suggestedExitCode;
    }

    protected void configure(@NotNull Properties properties) {
        this.setTempDir(properties);
        ConfiguratorUtils.savePropertiesFile((File)this.getConfigPath(), (Properties)properties);
        this.createConvenientConfigFileIfNeeded(properties);
    }

    @NotNull
    protected File getServiceHome() {
        CommonContextProvider configurationProvider = this.myConfigurationProvider;
        if (configurationProvider == null) {
            throw new RuntimeException("Called getServiceHome before start");
        }
        return configurationProvider.getServiceHome();
    }

    @NotNull
    protected final File getConfFolder() {
        CommonContextProvider configurationProvider = this.myConfigurationProvider;
        if (configurationProvider == null) {
            throw new RuntimeException("Called getConfFolder before start");
        }
        return configurationProvider.getAppConfFolder();
    }

    @NotNull
    protected File getLogsDirectory() {
        CommonContextProvider configurationProvider = this.myConfigurationProvider;
        if (configurationProvider == null) {
            throw new RuntimeException("Called getLogsDirectory before start");
        }
        return configurationProvider.getLogsDirectory();
    }

    @NotNull
    protected String getServicePresentableName(@NotNull Properties serviceProperties) {
        return this.getMandatoryProperty("presentation-service-name", serviceProperties);
    }

    @NotNull
    protected String getServiceCookieName() {
        return "JSESSIONID";
    }

    @NotNull
    protected File getConfigPath() {
        return this.getConvenientConfigFile();
    }

    @NotNull
    protected final File getConvenientConfigFile() {
        return new File(this.getConfFolder(), "service-config.properties");
    }

    @NotNull
    protected abstract Server createServer(Properties var1) throws Exception;

    @NotNull
    protected abstract String getLogFileName(Properties var1);

    private void setupLogging(Properties properties, boolean enableDebugMessages, boolean consoleLogging) {
        String logsDir = this.getMandatoryProperty(ServiceProperties.LOGS_DIR_PROPERTY, properties);
        File logPath = new File(logsDir, this.getLogFileName(properties));
        LoggingUtil.setupLogging((boolean)enableDebugMessages, (File)logPath, (boolean)consoleLogging);
    }

    @NotNull
    protected String getMandatoryProperty(String propertyName, @NotNull Properties properties) {
        String value = properties.getProperty(propertyName);
        if (value == null) {
            throw new StatusException(String.format("Mandatory config property '%s' is not found in config file '%s'", propertyName, this.getConfigPath()));
        }
        return value;
    }

    @NotNull
    protected Properties getAllProperties() {
        Properties ps = new Properties();
        ps.putAll((Map<?, ?>)this.getDefaultProperties());
        File configPath = this.getConfigPath();
        if (configPath.exists()) {
            ps.putAll((Map<?, ?>)ConfiguratorUtils.loadPropertiesFile((File)configPath));
        } else if (LoggingUtil.isConfigured()) {
            this.getLogger().debug(String.format("Properties file %s is not found", configPath));
        }
        return ps;
    }

    @NotNull
    protected Properties getDefaultProperties() {
        Properties ps = new Properties();
        ps.setProperty("org.eclipse.jetty.servlet.SessionCookie", this.getServiceCookieName());
        ps.setProperty("org.eclipse.jetty.servlet.SessionIdPathParameterName", this.getServiceCookieName().toLowerCase());
        return ps;
    }

    protected final Server getServer() {
        return this.myServer;
    }

    protected final void setInitParameters(Properties properties, ContextHandler contentHandler) {
        for (String propName : properties.stringPropertyNames()) {
            contentHandler.setInitParameter(propName, properties.getProperty(propName));
        }
        contentHandler.setInitParameter("is-debug-mode", Boolean.valueOf(this.myConfigurationProvider.getLogLevel().isDebugEnabled()).toString());
    }

    private void setTempDir(@NotNull Properties properties) {
        try {
            SystemUtil.setTempDir((Path)Paths.get(PropertiesBasedConfigurationHelper.getHelper().getMandatoryServiceProperty((Object)properties, ServiceProperties.TEMP_DIR_PROPERTY), new String[0]));
        }
        catch (IOException e) {
            this.getLogger().warn(String.format("Cannot set temp dir for service %s", this.getServicePresentableName(properties)), (Throwable)e);
        }
    }

    private void createConvenientConfigFileIfNeeded(Properties properties) {
        File convenientConfigPathForBundleInProcessService;
        File configPath;
        if (properties.containsKey("bundledin") && !(configPath = this.getConfigPath()).equals(convenientConfigPathForBundleInProcessService = this.getConvenientConfigFile())) {
            Properties inProcessProperties = new Properties();
            inProcessProperties.setProperty(CONVENIENT_BUNDLE_IN_PROCESS_SERVICE_CONFIG_PATH_PROPERTY, configPath.getAbsolutePath());
            ConfiguratorUtils.savePropertiesFile((File)convenientConfigPathForBundleInProcessService, (Properties)inProcessProperties);
        }
        this.removeLegacyConvenientConfigFile();
    }

    protected final boolean isDebugEnabled(StartupContextProvider contextProvider) {
        return contextProvider.getLogLevel() == LogLevel.DEBUG;
    }

    private void removeLegacyConvenientConfigFile() {
        File legacyConvenientConfigFile = new File(this.getServiceHome(), "service-config.properties");
        try {
            Files.deleteIfExists(legacyConvenientConfigFile.toPath());
        }
        catch (Exception e) {
            this.getLogger().debug(String.format("Can not remove legacy config file: [%s]", legacyConvenientConfigFile.getPath()), (Throwable)e);
        }
    }
}

