/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.service.util.cmd;

import com.jetbrains.service.util.cmd.CmdUtil;
import com.jetbrains.service.util.cmd.ProcessExecutor;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultProcessExecutor
implements ProcessExecutor {
    private final CmdUtil.CommandLine myCommandLine;
    private final Path myWorkDirectory;

    public DefaultProcessExecutor(@NotNull String scriptName, @Nullable Path workDirectory, List<String> commandArguments, @NotNull List<String> additionalArguments) {
        this.myCommandLine = this.buildCommandLine(scriptName, commandArguments, additionalArguments);
        this.myWorkDirectory = workDirectory;
    }

    private CmdUtil.CommandLine buildCommandLine(@NotNull String scriptName, List<String> commandArguments, @NotNull List<String> additionalArguments) {
        CmdUtil.CommandLine commandLine = CmdUtil.constructCommandLine(scriptName);
        commandLine.addArguments(commandArguments.toArray(new String[commandArguments.size()]));
        commandLine.addArguments(additionalArguments.toArray(new String[additionalArguments.size()]));
        return commandLine;
    }

    @Override
    @NotNull
    public Process start() throws IOException {
        return Runtime.getRuntime().exec(this.myCommandLine.toStrings(), null, this.myWorkDirectory != null ? this.myWorkDirectory.toFile() : null);
    }

    @Override
    public List<String> getCommandLine() {
        return Arrays.asList(this.myCommandLine.toStrings());
    }

    @Override
    public Path getWorkDirectory() {
        return this.myWorkDirectory;
    }
}

