/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.service.util.cmd;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaitThread
extends Thread {
    private final AtomicBoolean myInterrupted = new AtomicBoolean(false);
    private final AtomicInteger myExitCode = new AtomicInteger(-1);
    private final Process myProcess;
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());

    public WaitThread(Process process) {
        this.myProcess = process;
    }

    @Override
    public void run() {
        try {
            int rc = this.myProcess.waitFor();
            this.myExitCode.set(rc);
        }
        catch (InterruptedException e) {
            this.myInterrupted.set(true);
            this.LOG.error("Wait thread interrupted");
        }
        catch (Throwable t) {
            this.LOG.error("Error in wait thread", t);
            this.myInterrupted.set(true);
        }
    }

    public boolean isInterruptedFlagSet() {
        return this.myInterrupted.get();
    }

    public Integer getExitCode() {
        return this.myExitCode.get();
    }
}

