/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.service.util.logging.log4j;

import java.io.File;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.core.config.NullConfiguration;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.AppenderRefComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.impl.BuiltConfiguration;
import org.apache.logging.log4j.status.StatusLogger;
import org.jetbrains.annotations.Nullable;

public class LoggingUtil {
    private static final String LOGGING_PATTERN = "[%d] %6p - %30.30c - %m %n";
    private static final String CONSOLE_LOGGING_PATTERN = "* %m %n";

    public static void setupConsoleLogging(boolean debug) {
        LoggingUtil.setupLogging(debug, null, true);
    }

    public static void setupLogging(boolean enableDebugMessages, @Nullable File targetFile, boolean consoleLogging) {
        ConfigurationBuilder configBuilder = ConfigurationBuilderFactory.newConfigurationBuilder();
        RootLoggerComponentBuilder rootLoggerComponentBuilder = configBuilder.newRootLogger(enableDebugMessages ? Level.DEBUG : Level.INFO);
        if (targetFile != null) {
            File parent = targetFile.getParentFile();
            if (parent != null && !parent.isDirectory() && !parent.mkdirs()) {
                throw new RuntimeException("Could not create directory " + parent);
            }
            LayoutComponentBuilder layoutBuilder = (LayoutComponentBuilder)configBuilder.newLayout("PatternLayout").addAttribute("pattern", LOGGING_PATTERN);
            ComponentBuilder triggeringPolicy = configBuilder.newComponent("Policies").addComponent(configBuilder.newComponent("SizeBasedTriggeringPolicy").addAttribute("size", "10Mb"));
            ComponentBuilder strategy = configBuilder.newComponent("DefaultRolloverStrategy").addAttribute("max", 3).addAttribute("fileIndex", "min");
            AppenderComponentBuilder appenderComponentBuilder = ((AppenderComponentBuilder)((AppenderComponentBuilder)((AppenderComponentBuilder)((AppenderComponentBuilder)configBuilder.newAppender("FILE", "RollingFile").addAttribute("fileName", targetFile.getAbsolutePath())).addAttribute("filePattern", targetFile.getAbsolutePath().replace(".log", "") + "-%i.log.gz")).addComponent(triggeringPolicy)).addComponent(strategy)).add(layoutBuilder);
            configBuilder.add(appenderComponentBuilder);
            AppenderRefComponentBuilder fileAppenderRef = (AppenderRefComponentBuilder)configBuilder.newAppenderRef("FILE").addAttribute("level", enableDebugMessages ? "debug" : "info");
            rootLoggerComponentBuilder.add(fileAppenderRef);
        }
        if (consoleLogging) {
            LayoutComponentBuilder consoleLayoutBuilder = (LayoutComponentBuilder)configBuilder.newLayout("PatternLayout").addAttribute("pattern", CONSOLE_LOGGING_PATTERN);
            AppenderComponentBuilder consoleAppenderComponentBuilder = configBuilder.newAppender("CONSOLE", "Console").add(consoleLayoutBuilder);
            configBuilder.add(consoleAppenderComponentBuilder);
            AppenderRefComponentBuilder consoleAppenderRef = (AppenderRefComponentBuilder)configBuilder.newAppenderRef("CONSOLE").addAttribute("level", enableDebugMessages ? "debug" : "info");
            rootLoggerComponentBuilder.add(consoleAppenderRef);
        }
        configBuilder.add(rootLoggerComponentBuilder);
        configBuilder.newLogger("org.eclipse.jetty.webapp.StandardDescriptorProcessor", Level.WARN);
        BuiltConfiguration configuration = (BuiltConfiguration)configBuilder.build();
        LoggerContext ctx = Configurator.initialize((Configuration)configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isConfigured() {
        Level statusLoggerLevel = StatusLogger.getLogger().getLevel();
        try {
            StatusLogger.getLogger().setLevel(Level.FATAL);
            if (LogManager.getContext() instanceof LoggerContext) {
                LoggerContext loggerContext = (LoggerContext)LogManager.getContext();
                if (loggerContext.getConfigLocation() == null || loggerContext.getConfiguration() instanceof NullConfiguration || loggerContext.getConfiguration() instanceof DefaultConfiguration) {
                    boolean bl = false;
                    return bl;
                }
                for (Logger logger : loggerContext.getLoggers()) {
                    if (Level.OFF.equals((Object)logger.getLevel())) continue;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            StatusLogger.getLogger().setLevel(statusLoggerLevel);
        }
    }
}

