/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.event;

import com.jetbrains.teamsys.dnq.database.TransientChangesTrackerImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jetbrains.charisma.context.ContextProvider;
import jetbrains.charisma.context.StatefulContext;
import jetbrains.charisma.event.ChangeHandler;
import jetbrains.charisma.event.EventMarker;
import jetbrains.charisma.event.EventMergeProvider;
import jetbrains.charisma.event.EventProducer;
import jetbrains.charisma.event.EventProducerManager;
import jetbrains.charisma.event.InMemoryTransactionEventsData;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.exodus.database.TransientChangesTracker;
import jetbrains.exodus.database.TransientEntityChange;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.database.TransientStoreSessionListener;
import jetbrains.exodus.database.exceptions.DataIntegrityViolationException;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ISetSequence;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.txn._Txn;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.events.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventIssueListener
implements TransientStoreSessionListener {
    private static final Object IGNORE_FLAG = new Object();
    private final ThreadLocal<Object> ignoreThreads = new ThreadLocal();
    private final ThreadLocal<EventMarker> threadCurrentEventMarker = new ThreadLocal();
    private final ThreadLocal<TransientStoreSession> threadCurrentSession = new ThreadLocal();
    private final ThreadLocal<InMemoryTransactionEventsData> threadCurrentData = new ThreadLocal();
    private Map<String, ChangeHandler> handlers = MapSequence.fromMap(new HashMap());
    private Long frozenTimestamp = null;
    private final EventProducerManager manager;

    public EventIssueListener(EventProducerManager manager) {
        this.manager = manager;
    }

    public void setChangeHandlers(List<ChangeHandler> handlers) {
        ListSequence.fromList(handlers).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<ChangeHandler>(){

            public void visit(ChangeHandler it) {
                MapSequence.fromMap((Map)EventIssueListener.this.handlers).put((Object)it.getTypeName(), (Object)it);
            }
        });
    }

    public Iterable<ChangeHandler> getChangeHandlers() {
        return MapSequence.fromMap(this.handlers).values();
    }

    public Iterable<String> getHandledPersistentClasses() {
        return MapSequence.fromMap(this.handlers).keySet();
    }

    public void setEventMarkers(Iterable<EventMarker> markers) throws IllegalArgumentException {
        ISetSequence ids = SetSequence.fromSet(new HashSet());
        for (EventMarker marker : Sequence.fromIterable(markers)) {
            byte id = marker.getId();
            if (SetSequence.fromSet((Set)ids).contains((Object)id)) {
                throw new IllegalArgumentException("Event origins have not unique identificators, repeating value " + id);
            }
            SetSequence.fromSet((Set)ids).addElement((Object)id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushed(@NotNull TransientStoreSession session, @Nullable Set<TransientEntityChange> set) {
        try {
            InMemoryTransactionEventsData map;
            EventProducer producer = this.manager.getProducer();
            if (producer != null && (map = this.threadCurrentData.get()) != null && this.getCurrentMarkerAdded() != (EventMarker)ServiceLocator.getBean((String)"systemApplyEventMarker")) {
                producer.produce(map, EventIssueListener.as_xd54bt_a1a0a0b0b0a0e(ContextProvider.getContext(), StatefulContext.class));
            }
        }
        finally {
            this.threadCurrentData.remove();
        }
    }

    public void beforeFlushBeforeConstraints(@NotNull TransientStoreSession session, @Nullable Set<TransientEntityChange> changes) {
        if (this.isEventDisabled()) {
            return;
        }
        if (this.threadCurrentSession.get() == session) {
            return;
        }
        try {
            ChangeHandler handler;
            this.threadCurrentSession.set(session);
            TransientChangesTrackerImpl changesTracker = (TransientChangesTrackerImpl)DnqUtils.getCurrentTransientSession().getTransientChangesTracker();
            long timestamp = this.getCurrentTime();
            Entity author = ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get();
            InMemoryTransactionEventsData data = new InMemoryTransactionEventsData(author, (TransientChangesTracker)changesTracker, timestamp);
            this.threadCurrentData.set(data);
            EventMarker marker = this.threadCurrentEventMarker.get();
            Set nonIssueChanges = changesTracker.getChangesDescription();
            Iterator itr = nonIssueChanges.iterator();
            ArrayList<TransientEntityChange> issueChanges = new ArrayList<TransientEntityChange>();
            while (itr.hasNext()) {
                TransientEntityChange change = (TransientEntityChange)itr.next();
                if (!"Issue".equals(change.getTransientEntity().getType())) continue;
                itr.remove();
                issueChanges.add(change);
            }
            for (TransientEntityChange change : ListSequence.fromList(issueChanges)) {
                handler = (ChangeHandler)MapSequence.fromMap(this.handlers).get((Object)change.getTransientEntity().getType());
                if (handler == null) continue;
                handler.handle(change, data, marker);
            }
            for (TransientEntityChange change : SetSequence.fromSet((Set)nonIssueChanges)) {
                handler = (ChangeHandler)MapSequence.fromMap(this.handlers).get((Object)change.getTransientEntity().getType());
                if (handler == null) continue;
                handler.handle(change, data, marker);
            }
        }
        catch (RuntimeException exception) {
            this.threadCurrentSession.remove();
            throw exception;
        }
    }

    public void beforeFlushAfterConstraints(@NotNull TransientStoreSession session, @Nullable Set<TransientEntityChange> set) {
        this.threadCurrentSession.remove();
    }

    public void afterConstraintsFail(@NotNull TransientStoreSession session, @NotNull Set<DataIntegrityViolationException> set) {
        this.threadCurrentSession.remove();
        this.threadCurrentData.remove();
    }

    private boolean isEventDisabled() {
        return this.isIgnoreThread();
    }

    private boolean isIgnoreThread() {
        return this.ignoreThreads.get() == IGNORE_FLAG;
    }

    public void addIgnoreThread() {
        this.ignoreThreads.set(IGNORE_FLAG);
    }

    public void removeIgnoreThread() {
        this.ignoreThreads.remove();
    }

    public ChangeHandler getHandler(Entity entity) {
        return (ChangeHandler)MapSequence.fromMap(this.handlers).get((Object)entity.getType());
    }

    public void addCurrentEventMarker(EventMarker marker) {
        this.threadCurrentEventMarker.set(marker);
    }

    public void removeCurrentEventMarker() {
        this.threadCurrentEventMarker.remove();
    }

    public EventMarker getCurrentMarkerAdded() {
        return this.threadCurrentEventMarker.get();
    }

    public long getCurrentTime() {
        return this.frozenTimestamp == null ? System.currentTimeMillis() : this.frozenTimestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freezeTime(long time, boolean strictOrder) {
        boolean $nt$_xd54bt_b0r = DnqUtils.getCurrentTransientSession() == null;
        TransientStoreSession ts1_xd54bt_b0r = DnqUtils.beginTransientSession();
        boolean wasEx_xd54bt_b0r = true;
        try {
            Event last = ((EventMergeProvider)ServiceLocator.getBean((String)"eventMergeProvider")).getLastEvent();
            if (strictOrder && last != null && last.getTimestamp() > time) {
                throw new RuntimeException("Could not set frozen time early than last event timestamp");
            }
            wasEx_xd54bt_b0r = false;
        }
        finally {
            if ($nt$_xd54bt_b0r && ts1_xd54bt_b0r.isOpened()) {
                if (wasEx_xd54bt_b0r) {
                    ts1_xd54bt_b0r.abort();
                } else {
                    ts1_xd54bt_b0r.commit();
                }
            }
        }
        this.frozenTimestamp = time;
    }

    public void unfreezeTime() {
        this.frozenTimestamp = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entity transactionalNew(final _FunctionTypes._return_P0_E0<? extends Entity> action) {
        InMemoryTransactionEventsData data = this.threadCurrentData.get();
        this.threadCurrentData.remove();
        try {
            Entity entity = (Entity)_Txn.evalNew((_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<Entity>(){

                public Entity invoke() {
                    return (Entity)action.invoke();
                }
            });
            return entity;
        }
        finally {
            this.threadCurrentData.set(data);
        }
    }

    private static <T> T as_xd54bt_a1a0a0b0b0a0e(Object o, Class<T> type) {
        return (T)(type.isInstance(o) ? o : null);
    }
}

