/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.event;

import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import jetbrains.charisma.event.EventExecutionData;
import jetbrains.charisma.event.InMemoryEventType;
import jetbrains.exodus.core.dataStructures.Pair;
import jetbrains.exodus.core.dataStructures.decorators.HashSetDecorator;
import jetbrains.exodus.database.TransientChangesTracker;
import jetbrains.exodus.entitystore.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InMemoryTransactionEventsData {
    @Nullable
    private final Entity author;
    @NotNull
    private final TransientChangesTracker changesTracker;
    private final long timestamp;
    private final Map<Entity, EventExecutionData> state = new LinkedHashMap<Entity, EventExecutionData>();
    private final Set<Entity> removedEvents = new HashSetDecorator();

    public InMemoryTransactionEventsData(@Nullable Entity author, @NotNull TransientChangesTracker changesTracker, long timestamp) {
        this.author = author;
        this.changesTracker = changesTracker;
        this.timestamp = timestamp;
    }

    @Nullable
    public Entity getAuthor() {
        return this.author;
    }

    @NotNull
    public TransientChangesTracker getChangesTracker() {
        return this.changesTracker;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void addCreatedEvent(InMemoryEventType type, Entity issue, Entity target, Entity event) {
        if (!EntityOperations.equals((Entity)target, null)) {
            EventExecutionData data = this.state.get(target);
            if (data == null) {
                data = new EventExecutionData(target, issue);
                this.state.put(target, data);
            }
            data.events.add((Pair<InMemoryEventType, Entity>)new Pair((Object)type, (Object)event));
        }
    }

    public void addRemovedEvent(Entity event) {
        this.removedEvents.add(event);
    }

    public Map<Entity, EventExecutionData> getState() {
        return this.state;
    }

    public Collection<Entity> getRemovedEvents() {
        return this.removedEvents;
    }
}

