/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.links.persistent;

import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import jetbrains.charisma.links.persistent.IssueLinkPrototypeImpl;
import jetbrains.charisma.links.persistent.LinkDirection;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import org.apache.commons.lang.StringUtils;

public class DirectedLink {
    private Entity myPrototype;
    private LinkDirection myDirection;
    private String myRole;

    public DirectedLink(Entity prototype, LinkDirection direction) {
        this.setPrototype(prototype);
        this.setDirection(direction);
    }

    public DirectedLink(Entity prototype, boolean outward) {
        this.setPrototype(prototype);
        this.setDirection(((Boolean)PrimitiveAssociationSemantics.get((Entity)this.getPrototype(), (String)"directed", Boolean.class, null)).booleanValue() ? (outward ? LinkDirection.OUTWARD : LinkDirection.INWARD) : LinkDirection.BOTH);
    }

    public DirectedLink(Entity prototype, LinkDirection direction, String role) {
        this(prototype, direction);
        this.setRole(role);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DirectedLink)) {
            return false;
        }
        DirectedLink that = (DirectedLink)object;
        return DirectedLink.eq_874gg1_a0a3a0_0(this.getPrototype(), that.getPrototype()) && DirectedLink.eq_874gg1_a0a3a0((Object)this.getDirection(), (Object)that.getDirection());
    }

    public int hashCode() {
        return this.getPrototype().hashCode() ^ this.getDirection().hashCode();
    }

    public String getCapitalizedRole() {
        if (this.getRole() != null) {
            return StringUtils.capitalize((String)this.getRole());
        }
        return ((IssueLinkPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)this.getPrototype(), (String)"IssueLinkPrototype")).getCapitalizedRoleName(this.getDirection() != LinkDirection.INWARD, this.getPrototype());
    }

    public String getId() {
        if (this.getDirection() == LinkDirection.INWARD) {
            return (String)PrimitiveAssociationSemantics.get((Entity)this.getPrototype(), (String)"targetToSourceAssociationName", String.class, null);
        }
        if (this.getDirection() == LinkDirection.OUTWARD) {
            return (String)PrimitiveAssociationSemantics.get((Entity)this.getPrototype(), (String)"sourceToTargetAssociationName", String.class, null);
        }
        String ass = (String)PrimitiveAssociationSemantics.get((Entity)this.getPrototype(), (String)"sourceToTargetAssociationName", String.class, null);
        return ass.substring(0, ass.length() - 1);
    }

    public Entity getPrototype() {
        return this.myPrototype;
    }

    private void setPrototype(Entity value) {
        this.myPrototype = value;
    }

    public LinkDirection getDirection() {
        return this.myDirection;
    }

    private void setDirection(LinkDirection value) {
        this.myDirection = value;
    }

    public String getRole() {
        return this.myRole;
    }

    private void setRole(String value) {
        this.myRole = value;
    }

    public static DirectedLink find(String role) {
        Entity outward = QueryOperations.getFirst((Iterable)QueryOperations.query(null, (String)"IssueLinkPrototype", (NodeBase)new PropertyEqual("sourceToTarget", (Comparable)((Object)role))));
        if (!EntityOperations.equals((Entity)outward, null)) {
            if (((Boolean)PrimitiveAssociationSemantics.get((Entity)outward, (String)"directed", Boolean.class, null)).booleanValue()) {
                return ((IssueLinkPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)outward, (String)"IssueLinkPrototype")).getDirectedLink(LinkDirection.OUTWARD, outward);
            }
            return ((IssueLinkPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)outward, (String)"IssueLinkPrototype")).getDirectedLink(LinkDirection.BOTH, outward);
        }
        Entity inward = QueryOperations.getFirst((Iterable)QueryOperations.query(null, (String)"IssueLinkPrototype", (NodeBase)new PropertyEqual("targetToSource", (Comparable)((Object)role))));
        if (!EntityOperations.equals((Entity)inward, null)) {
            if (((Boolean)PrimitiveAssociationSemantics.get((Entity)inward, (String)"directed", Boolean.class, null)).booleanValue()) {
                return ((IssueLinkPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)inward, (String)"IssueLinkPrototype")).getDirectedLink(LinkDirection.INWARD, inward);
            }
            return null;
        }
        return null;
    }

    private static boolean eq_874gg1_a0a3a0(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }

    private static boolean eq_874gg1_a0a3a0_0(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }
}

