/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.links.persistent;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.association.UndirectedAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import jetbrains.charisma.links.iterable.LinkAssociationIterable;
import jetbrains.charisma.links.iterable.LinkSourceTargetIterable;
import jetbrains.charisma.links.iterable.LinkedIssuesIterable;
import jetbrains.charisma.links.persistent.AbstractIssueLinkPrototypeImpl;
import jetbrains.charisma.links.persistent.DirectedLink;
import jetbrains.charisma.links.persistent.IssueLinkPrototypeImpl;
import jetbrains.charisma.links.persistent.LinkAssociationsCache;
import jetbrains.charisma.links.persistent.LinkDirection;
import jetbrains.charisma.links.persistent.LinkImpl;
import jetbrains.charisma.links.persistent.LinkSourceTarget;
import jetbrains.charisma.links.persistent.Link_Direction;
import jetbrains.charisma.persistent.IssueImpl;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.database.exceptions.ConstraintsValidationException;
import jetbrains.exodus.database.exceptions.DataIntegrityViolationException;
import jetbrains.exodus.database.exceptions.UserConstraintValidationException;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterable;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIteratorWithPropId;
import jetbrains.exodus.query.And;
import jetbrains.exodus.query.LinkEqual;
import jetbrains.exodus.query.LinkNotNull;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.Or;
import jetbrains.exodus.query.TreeKeepingEntityIterable;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IMapping;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.ISetSequence;
import jetbrains.mps.internal.collections.runtime.ITranslator2;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.core.security.Operation;
import kotlin.Pair;
import org.apache.commons.lang.StringUtils;

public class IssueLinkPrototypeUtil {
    public static Iterable<Entity> getLinkedIssues(Entity _this, DirectedLink link) {
        return IssueLinkPrototypeUtil.getLinkedIssues(_this, ((LinkAssociationsCache)ServiceLocator.getBean((String)"linkAssociationsCache")).getAssociationsSet(link));
    }

    public static Iterable<Entity> getLinkedIssues(Entity _this, Entity linkPrototype, boolean outward) {
        Iterable issues = AssociationSemantics.getToMany((Entity)_this, (String)((AbstractIssueLinkPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)linkPrototype, (String)"AbstractIssueLinkPrototype")).getAssociationName(outward, linkPrototype));
        return issues;
    }

    public static Iterable<Entity> getAddedLinkedIssues(Entity _this, DirectedLink link) {
        return IssueLinkPrototypeUtil.getAddedLinkedIssues(_this, ((LinkAssociationsCache)ServiceLocator.getBean((String)"linkAssociationsCache")).getAssociationsSet(link));
    }

    public static Iterable<Entity> getRemoveLinkedIssues(Entity _this, DirectedLink link) {
        return IssueLinkPrototypeUtil.getRemoveLinkedIssues(_this, ((LinkAssociationsCache)ServiceLocator.getBean((String)"linkAssociationsCache")).getAssociationsSet(link));
    }

    public static Iterable<LinkImpl> getAccessibleNonDraftLinks(Entity _this) {
        LinkedIssuesIterable result = new LinkedIssuesIterable(_this, LinkDirection.BOTH);
        return Sequence.fromIterable((Iterable)result).where((_FunctionTypes._return_P1_E0)new IWhereFilter<LinkImpl>(){

            public boolean accept(LinkImpl it) {
                return !((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)it.getTo(), (String)"Issue")).isDraft(it.getTo()) && ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)it.getTo(), (String)"Issue")).isAccessible(Operation.READ, it.getTo());
            }
        });
    }

    public static Iterable<Entity> getAllLinkedIssues(Entity _this) {
        Object issues = EntityIterableBase.EMPTY;
        for (String association : SetSequence.fromSet(((LinkAssociationsCache)ServiceLocator.getBean((String)"linkAssociationsCache")).getAllAssociations())) {
            Iterable linked = AssociationSemantics.getToMany((Entity)_this, (String)association);
            issues = issues == EntityIterableBase.EMPTY ? linked : QueryOperations.union((Iterable)issues, (Iterable)linked);
        }
        return issues;
    }

    public static Iterable<Entity> getAllAddedLinkedIssues(Entity _this) {
        Set<String> associations = ((LinkAssociationsCache)ServiceLocator.getBean((String)"linkAssociationsCache")).getAllAssociations();
        return IssueLinkPrototypeUtil.getAddedLinkedIssues(_this, associations);
    }

    public static Iterable<Entity> getAllRemovedLinkedIssues(Entity _this) {
        Set<String> associations = ((LinkAssociationsCache)ServiceLocator.getBean((String)"linkAssociationsCache")).getAllAssociations();
        return IssueLinkPrototypeUtil.getRemoveLinkedIssues(_this, associations);
    }

    public static void clearAllLinks(Entity _this, LinkDirection direction) {
        IssueLinkPrototypeUtil.clearLinks(_this, ((LinkAssociationsCache)ServiceLocator.getBean((String)"linkAssociationsCache")).getAssociations(direction));
    }

    public static void clearLinks(Entity _this, DirectedLink directedLink) {
        IssueLinkPrototypeUtil.clearLinks(_this, ((LinkAssociationsCache)ServiceLocator.getBean((String)"linkAssociationsCache")).getAssociations(directedLink));
    }

    public static void clearLinks(Entity _this, Map<String, Link_Direction> associationNames) {
        for (IMapping association : MapSequence.fromMap(associationNames)) {
            Link_Direction link = (Link_Direction)((Object)association.value());
            String oppositeAssociationName = link.getOppositeAssociationName();
            UndirectedAssociationSemantics.clearManyToMany((Entity)_this, (String)((String)association.key()), (String)oppositeAssociationName);
        }
    }

    public static void assertNoAggregationLinkCycles(Entity _this) {
        Map<String, Entity> inwardAssociations = ((LinkAssociationsCache)ServiceLocator.getBean((String)"linkAssociationsCache")).getInwardAggregationAssociations();
        EntityIteratorWithPropId iter = (EntityIteratorWithPropId)AssociationSemantics.getAddedLinks((TransientEntity)((TransientEntity)_this), (Set)MapSequence.fromMap(inwardAssociations).keySet()).iterator();
        while (iter.hasNext()) {
            String associationName = iter.currentLinkName();
            Entity linkPrototype = (Entity)MapSequence.fromMap(inwardAssociations).get((Object)associationName);
            IssueLinkPrototypeUtil.assertNoAggregationLinkCycles(_this, associationName, DnqUtils.cast((Object)iter.next(), (String)"Issue"), linkPrototype);
        }
    }

    private static void assertNoAggregationLinkCycles(Entity _this, String associationName, Entity parent, Entity linkPrototype) {
        ISetSequence path = SetSequence.fromSet(new LinkedHashSet());
        SetSequence.fromSet((Set)path).addElement((Object)_this);
        while (!EntityOperations.equals((Entity)parent, null)) {
            if (QueryOperations.contains((Iterable)path, (Entity)parent)) {
                String msg = ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("IssueLinkPrototypeUtil.{link_name}_link_cycle_detected", new Object[]{StringUtils.capitalize((String)((String)PrimitiveAssociationSemantics.get((Entity)linkPrototype, (String)"name", String.class, null)))});
                StringBuilder message = new StringBuilder(msg);
                for (Entity issue : SetSequence.fromSet((Set)path)) {
                    message.append(((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).getId(issue)).append(" \u2192 ");
                }
                message.append(((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)parent, (String)"Issue")).getId(parent));
                throw new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException(message.toString(), (Entity)((TransientEntity)_this)));
            }
            SetSequence.fromSet((Set)path).addElement((Object)parent);
            parent = QueryOperations.getFirst((Iterable)AssociationSemantics.getToMany((Entity)parent, (String)associationName));
        }
    }

    public static void moveAllLinksTo(Entity _this, Entity newIssue) {
        Map<String, Link_Direction> associations = ((LinkAssociationsCache)ServiceLocator.getBean((String)"linkAssociationsCache")).getAssociations(LinkDirection.BOTH);
        for (IMapping p : MapSequence.fromMap(associations)) {
            Entity proto = ((Link_Direction)((Object)p.value())).linkPrototype();
            boolean outward = ((Link_Direction)((Object)p.value())).outward();
            Iterable oppIssues = AssociationSemantics.getToMany((Entity)_this, (String)((String)p.key()));
            for (Entity oppIssue : Sequence.fromIterable((Iterable)oppIssues).toListSequence()) {
                if (outward) {
                    ((IssueLinkPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)proto, (String)"IssueLinkPrototype")).link(newIssue, oppIssue, proto);
                    ((IssueLinkPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)proto, (String)"IssueLinkPrototype")).unlink(_this, oppIssue, proto);
                    continue;
                }
                ((IssueLinkPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)proto, (String)"IssueLinkPrototype")).link(oppIssue, newIssue, proto);
                ((IssueLinkPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)proto, (String)"IssueLinkPrototype")).unlink(oppIssue, _this, proto);
            }
        }
    }

    public static boolean hasLinksChanges(Entity _this) {
        return !QueryOperations.isEmpty(IssueLinkPrototypeUtil.getAllAddedLinkedIssues(_this)) || !QueryOperations.isEmpty(IssueLinkPrototypeUtil.getAllRemovedLinkedIssues(_this));
    }

    public static boolean hasLinksChanges(Entity _this, DirectedLink link) {
        return !QueryOperations.isEmpty(IssueLinkPrototypeUtil.getAddedLinkedIssues(_this, link)) || !QueryOperations.isEmpty(IssueLinkPrototypeUtil.getRemoveLinkedIssues(_this, link));
    }

    public static Iterable<Entity> whereHasLinks(Iterable<Entity> _this) {
        return IssueLinkPrototypeUtil.whereHasLinks(_this, ((LinkAssociationsCache)ServiceLocator.getBean((String)"linkAssociationsCache")).getAllAssociations());
    }

    public static Iterable<Entity> whereHasLinks(Iterable<Entity> _this, DirectedLink link) {
        return IssueLinkPrototypeUtil.whereHasLinks(_this, ((LinkAssociationsCache)ServiceLocator.getBean((String)"linkAssociationsCache")).getAssociationsSet(link));
    }

    public static Iterable<Entity> whereHasLinks(Iterable<Entity> _this, DirectedLink link, Entity target) {
        return IssueLinkPrototypeUtil.whereHasLinks(_this, ((LinkAssociationsCache)ServiceLocator.getBean((String)"linkAssociationsCache")).getAssociationsSet(link), target);
    }

    static Iterable<Entity> whereHasLinks(Iterable<Entity> _this, Set<String> associations) {
        LinkNotNull node = null;
        for (String association : SetSequence.fromSet(associations)) {
            LinkNotNull linkNotNull = new LinkNotNull(association);
            if (node == null) {
                node = linkNotNull;
                continue;
            }
            node = new Or((NodeBase)node, (NodeBase)linkNotNull);
        }
        TreeKeepingEntityIterable result = node != null ? QueryOperations.query(_this, (String)"Issue", node) : null;
        return result;
    }

    static Iterable<Entity> whereHasLinks(Iterable<Entity> _this, Set<String> associations, Entity target) {
        LinkEqual node = null;
        for (String association : SetSequence.fromSet(associations)) {
            LinkEqual linkEqual = new LinkEqual(association, target);
            if (node == null) {
                node = linkEqual;
                continue;
            }
            node = new Or((NodeBase)node, (NodeBase)linkEqual);
        }
        TreeKeepingEntityIterable result = node != null ? QueryOperations.query(_this, (String)"Issue", node) : null;
        return result;
    }

    public static Iterable<Entity> whereHasNoLinks(Iterable<Entity> _this, DirectedLink link) {
        return IssueLinkPrototypeUtil.whereHasNoLinks(_this, ((LinkAssociationsCache)ServiceLocator.getBean((String)"linkAssociationsCache")).getAssociationsSet(link));
    }

    static Iterable<Entity> whereHasNoLinks(Iterable<Entity> _this, Set<String> associations) {
        LinkEqual node = null;
        for (String association : SetSequence.fromSet(associations)) {
            LinkEqual linkNull = new LinkEqual(association, null);
            if (node == null) {
                node = linkNull;
                continue;
            }
            node = new And((NodeBase)node, (NodeBase)linkNull);
        }
        TreeKeepingEntityIterable result = node != null ? QueryOperations.query(_this, (String)"Issue", node) : null;
        return result;
    }

    public static Iterable<Entity> getLinkedIssuesByRole(Entity _this, String role) {
        DirectedLink directedLink = DirectedLink.find(role);
        return directedLink != null ? IssueLinkPrototypeUtil.getLinkedIssues(_this, directedLink) : null;
    }

    public static Iterable<LinkSourceTarget> selectLinks(Iterable<Entity> _this) {
        final Map<String, Link_Direction> associations = ((LinkAssociationsCache)ServiceLocator.getBean((String)"linkAssociationsCache")).getAssociations(LinkDirection.OUTWARD);
        Iterable<Entity> issuesWithLinks = IssueLinkPrototypeUtil.whereHasLinks(_this, MapSequence.fromMap(associations).keySet());
        return Sequence.fromIterable(issuesWithLinks).translate((_FunctionTypes._return_P1_E0)new ITranslator2<Entity, LinkSourceTarget>(){

            public Iterable<LinkSourceTarget> translate(Entity source) {
                return new LinkSourceTargetIterable(source, associations);
            }
        });
    }

    public static Iterable<String> getLinkRolesFromIssueToIssue(Entity _this, Entity toIssue) {
        final Map<String, Link_Direction> associations = ((LinkAssociationsCache)ServiceLocator.getBean((String)"linkAssociationsCache")).getAssociations(LinkDirection.BOTH);
        PersistentEntityId toIssueId = DnqUtils.toPersistentId((Entity)toIssue);
        ISetSequence foundAssociations = SetSequence.fromSet(new LinkedHashSet());
        LinkAssociationIterable associatedEntities = new LinkAssociationIterable(_this, associations);
        for (Pair associated : Sequence.fromIterable((Iterable)associatedEntities)) {
            EntityId id = ((Entity)associated.getSecond()).getId();
            if (id.getLocalId() != toIssueId.getLocalId()) continue;
            SetSequence.fromSet((Set)foundAssociations).addElement(associated.getFirst());
        }
        return SetSequence.fromSetWithValues(new LinkedHashSet(), (Iterable)SetSequence.fromSet((Set)foundAssociations).select((_FunctionTypes._return_P1_E0)new ISelector<String, String>(){

            public String select(String it) {
                return ((Link_Direction)((Object)MapSequence.fromMap((Map)associations).get((Object)it))).getRole();
            }
        }));
    }

    public static Iterable<String> getDistinguishableDirectedLinks(Entity _this) {
        ISetSequence directedLinks = SetSequence.fromSet(new LinkedHashSet());
        for (DirectedLink directedLink : Sequence.fromIterable(((LinkAssociationsCache)ServiceLocator.getBean((String)"linkAssociationsCache")).getAllDirectedLinks())) {
            if (QueryOperations.isEmpty(IssueLinkPrototypeUtil.getLinkedIssues(_this, directedLink))) continue;
            SetSequence.fromSet((Set)directedLinks).addElement((Object)directedLink.getCapitalizedRole());
        }
        return directedLinks;
    }

    public static Iterable<Entity> getLinkedIssues(Entity _this, Set<String> associations) {
        Object issues = SetSequence.fromSet(associations).isEmpty() ? EntityIterableBase.EMPTY : (SetSequence.fromSet(associations).count() == 1 ? AssociationSemantics.getToMany((Entity)_this, (String)((String)SetSequence.fromSet(associations).first())) : AssociationSemantics.getToMany((Entity)_this, associations));
        return issues;
    }

    private static Iterable<Entity> getAddedLinkedIssues(Entity _this, Set<String> associations) {
        EntityIterable issues = AssociationSemantics.getAddedLinks((TransientEntity)((TransientEntity)_this), associations);
        return issues;
    }

    private static Iterable<Entity> getRemoveLinkedIssues(Entity _this, Set<String> associations) {
        EntityIterable issues = AssociationSemantics.getRemovedLinks((TransientEntity)((TransientEntity)_this), associations);
        return issues;
    }
}

