/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.main;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SSLSocketFactory;
import jetbrains.charisma.main.ConfigurationParameter;
import jetbrains.charisma.main.SingleSmtpAdressWrapper;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.txn._Txn;
import jetbrains.youtrack.api.notifications.JabberConnectionConfigurator;
import jetbrains.youtrack.api.notifications.YoutrackJabberService;
import jetbrains.youtrack.core.persistent.MailSendProtocolImpl;
import jetbrains.youtrack.core.ssl.SSLContextFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import webr.framework.controller.CentralManager;
import webr.framework.url.HostToBaseUrlConfiguration;

public class ConfigurationUtil {
    public static final String TEST_MODE = "jetbrains.youtrack.testMode";
    private static final String SUPPORT_EMAIL_PROPERTY = "jetbrains.youtrack.support.email";
    private static final String HOSTED_SUPPORT_EMAIL_DEFAULT = "youtrack-incloud-support@jetbrains.com";
    private static final String SUPPORT_EMAIL_DEFAULT = "youtrack-feedback@jetbrains.com";
    public static final int MAX_TIMEOUT_FOR_HOSTED_YOUTRACK = 60;
    private static final String MAIL_PARAMETER_PREFIX = "mail.";
    public static String FILE_UPLOAD_UPPER_LIMIT = "jetbrains.youtrack.fileUploadUpperLimit";
    protected static Log log = LogFactory.getLog(ConfigurationUtil.class);

    public static void initConfiguration(boolean asyncJabberInit) {
        ConfigurationUtil.configureMailSender((JavaMailSenderImpl)((JavaMailSender)ServiceLocator.getBean((String)"mailSender2")), (SimpleMailMessage)ServiceLocator.getBean((String)"templateMessage2"), (HostToBaseUrlConfiguration)ServiceLocator.getBean((String)"hostToBaseUrlConfiguration"));
        ConfigurationUtil.configureJabberSender((YoutrackJabberService)ServiceLocator.getBean((String)"jabberService"), asyncJabberInit);
        ((CentralManager)ServiceLocator.getBean((String)"centralManager")).setDebugMode(String.valueOf(Boolean.getBoolean("jetrbains.mps.webr.debugMode")));
    }

    public static void initConfiguration() {
        ConfigurationUtil.initConfiguration(false);
    }

    public static void configureMailSender(JavaMailSenderImpl mail, SimpleMailMessage templateMessage, HostToBaseUrlConfiguration hostToBaseUrl) {
        Entity config = (Entity)ServiceLocator.getBean((String)"notificationsConfig");
        if (hostToBaseUrl != null) {
            hostToBaseUrl.setDefaultBaseUrl((String)PrimitiveAssociationSemantics.get((Entity)config, (String)"baseUrl", String.class, null));
        }
        if (((Boolean)PrimitiveAssociationSemantics.get((Entity)config, (String)"enableSmtp", Boolean.class, null)).booleanValue()) {
            String envelopFromDomain;
            String password;
            String login;
            mail.setHost((String)PrimitiveAssociationSemantics.get((Entity)config, (String)"smtpHost", String.class, null));
            int port = (Integer)PrimitiveAssociationSemantics.get((Entity)config, (String)"smtpPort", Integer.class, null);
            if (port > 0) {
                mail.setPort(port);
            }
            if ((login = (String)PrimitiveAssociationSemantics.get((Entity)config, (String)"smtpLogin", String.class, null)) != null && login.length() > 0) {
                mail.setUsername(login);
            }
            if ((password = (String)PrimitiveAssociationSemantics.get((Entity)config, (String)"smtpPassword", String.class, null)) != null && password.length() > 0) {
                mail.setPassword(password);
            }
            Entity mailSendProtocol = AssociationSemantics.getToOne((Entity)config, (String)"mailProtocol");
            String protocol = (String)PrimitiveAssociationSemantics.get((Entity)mailSendProtocol, (String)"value", String.class, (Object)"smtp");
            mail.setProtocol(protocol);
            templateMessage.setFrom((String)PrimitiveAssociationSemantics.get((Entity)config, (String)"smtpFrom", String.class, null));
            Properties props = new Properties();
            SSLSocketFactory sslSocketFactory = ((SSLContextFactory)ServiceLocator.getBean((String)"sslContextFactory")).createContext(AssociationSemantics.getToOne((Entity)config, (String)"sslKey")).getSocketFactory();
            props.put(MAIL_PARAMETER_PREFIX + protocol + ".connectiontimeout", (Object)30000);
            props.put(MAIL_PARAMETER_PREFIX + protocol + ".timeout", (Object)30000);
            props.put(MAIL_PARAMETER_PREFIX + protocol + ".ssl.socketFactory", sslSocketFactory);
            String smtpEnvelopeFrom = (String)PrimitiveAssociationSemantics.get((Entity)config, (String)"smtpEnvelopeFrom", String.class, null);
            if (smtpEnvelopeFrom != null && smtpEnvelopeFrom.length() > 0 && (envelopFromDomain = ConfigurationUtil.getEnvelopeFromDomain(smtpEnvelopeFrom)) != null && envelopFromDomain.length() > 0 && ((String)PrimitiveAssociationSemantics.get((Entity)config, (String)"smtpHost", String.class, null)).equalsIgnoreCase(envelopFromDomain)) {
                props.put(MAIL_PARAMETER_PREFIX + protocol + ".from", smtpEnvelopeFrom);
            }
            if (EntityOperations.equals((Entity)mailSendProtocol, (Object)MailSendProtocolImpl.SMTP_TLS.get())) {
                props.put("mail.smtp.starttls.enable", (Object)true);
            }
            props.put("mail.mime.address.strict", (Object)false);
            ConfigurationUtil.populateWithMailConfigurationParameters(props);
            mail.setJavaMailProperties(props);
        } else {
            mail.setHost("");
            mail.setPort(0);
        }
    }

    private static String getEnvelopeFromDomain(String rawAddress) {
        String domain;
        block3: {
            domain = "";
            try {
                SingleSmtpAdressWrapper wrapper = new SingleSmtpAdressWrapper();
                wrapper.parse(rawAddress);
                String address = wrapper.getAddress();
                int indexOf = address.indexOf(64);
                if (indexOf >= 0) {
                    domain = address.substring(indexOf + 1);
                }
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block3;
                log.warn((Object)"Cannot get domain of smtpEnvelopeFrom address", (Throwable)e);
            }
        }
        return domain;
    }

    private static void populateWithMailConfigurationParameters(Properties properties) {
        for (String propKey : SetSequence.fromSet(ConfigurationParameter.getParameterKeySet())) {
            if (!propKey.startsWith(MAIL_PARAMETER_PREFIX)) continue;
            properties.put(propKey, ConfigurationParameter.getParameter(propKey));
        }
    }

    public static void configureJabberSender(YoutrackJabberService jabber) {
        ConfigurationUtil.configureJabberSender(jabber, false);
    }

    public static void configureJabberSender(YoutrackJabberService jabber, boolean configAsync) {
        ((JabberConnectionConfigurator)ServiceLocator.getBean((String)"jabberConfigurator")).configure(jabber, configAsync);
    }

    public static void parseConfiguration(final Map<String, String> params) {
        _Txn.run((_FunctionTypes._void_P0_E0)new _FunctionTypes._void_P0_E0(){

            public void invoke() {
                Entity nc = (Entity)ServiceLocator.getBean((String)"notificationsConfig");
                for (ConfigurationParameter cp : Sequence.fromIterable((Iterable)Sequence.fromArray((Object[])ConfigurationParameter.values()))) {
                    try {
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("Apply config parameter [" + Arrays.toString(cp.getKey()) + "]"));
                        }
                        cp.apply(params, nc);
                    }
                    catch (Exception e) {
                        if (!log.isErrorEnabled()) continue;
                        log.error((Object)"Error appling config parameter", (Throwable)e);
                    }
                }
                ConfigurationUtil.validateSmtpConfig(nc);
                ConfigurationUtil.validateJabberConfig(nc);
            }
        });
    }

    public static void validateJabberConfig(Entity nc) {
        if (((Boolean)PrimitiveAssociationSemantics.get((Entity)nc, (String)"enableJabber", Boolean.class, null)).booleanValue()) {
            if (ConfigurationUtil.isEmpty_z2negs_a0a0a0i((String)PrimitiveAssociationSemantics.get((Entity)nc, (String)"jabberServer", String.class, null))) {
                throw new IllegalArgumentException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("ConfigurationUtil.Jabber_server_is_required", new Object[0]));
            }
            if (ConfigurationUtil.isEmpty_z2negs_a0b0a0i((String)PrimitiveAssociationSemantics.get((Entity)nc, (String)"jabberLogin", String.class, null))) {
                throw new IllegalArgumentException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("ConfigurationUtil.Jabber_from_is_required", new Object[0]));
            }
            if (ConfigurationUtil.isEmpty_z2negs_a0c0a0i((String)PrimitiveAssociationSemantics.get((Entity)nc, (String)"jabberPassword", String.class, null))) {
                throw new IllegalArgumentException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("ConfigurationUtil.Jabber_password_is_required", new Object[0]));
            }
            if ((Integer)PrimitiveAssociationSemantics.get((Entity)nc, (String)"jabberPort", Integer.class, null) <= 0) {
                throw new IllegalArgumentException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("ConfigurationUtil.Jabber_port_is_required", new Object[0]));
            }
        }
    }

    public static void validateSmtpConfig(Entity nc) {
        if (((Boolean)PrimitiveAssociationSemantics.get((Entity)nc, (String)"enableSmtp", Boolean.class, null)).booleanValue()) {
            if (ConfigurationUtil.isEmpty_z2negs_a0a0a0j((String)PrimitiveAssociationSemantics.get((Entity)nc, (String)"smtpHost", String.class, null))) {
                throw new IllegalArgumentException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("ConfigurationUtil.SMTP_host_is_required", new Object[0]));
            }
            if (ConfigurationUtil.isEmpty_z2negs_a0b0a0j((String)PrimitiveAssociationSemantics.get((Entity)nc, (String)"smtpFrom", String.class, null))) {
                throw new IllegalArgumentException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("ConfigurationUtil.SMTP_from_is_required", new Object[0]));
            }
            if ((Integer)PrimitiveAssociationSemantics.get((Entity)nc, (String)"smtpPort", Integer.class, null) <= 0) {
                throw new IllegalArgumentException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("ConfigurationUtil.SMTP_port_is_required", new Object[0]));
            }
        }
    }

    public static void validateBaseUrl(Entity nc) {
        if (ConfigurationUtil.isEmpty_z2negs_a0a0k((String)PrimitiveAssociationSemantics.get((Entity)nc, (String)"baseUrl", String.class, null))) {
            throw new IllegalArgumentException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("ConfigurationUtil.Base_URL_must_be_not_empty", new Object[0]));
        }
        if (((String)PrimitiveAssociationSemantics.get((Entity)nc, (String)"baseUrl", String.class, null)).endsWith("/") || ((String)PrimitiveAssociationSemantics.get((Entity)nc, (String)"baseUrl", String.class, null)).endsWith("\\")) {
            throw new IllegalArgumentException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("ConfigurationUtil.Base_URL_can_t_end_with_a_slash", new Object[0]));
        }
    }

    public static boolean isYoutrackHosted() {
        return Boolean.getBoolean("jetbrains.youtrack.hosted");
    }

    public static String getSupportEmail() {
        String supportEmail = ConfigurationUtil.isYoutrackHosted() ? HOSTED_SUPPORT_EMAIL_DEFAULT : SUPPORT_EMAIL_DEFAULT;
        supportEmail = System.getProperty(SUPPORT_EMAIL_PROPERTY, supportEmail);
        return supportEmail;
    }

    public static String getSupportUrl() {
        StringBuilder sb = new StringBuilder("http://www.jetbrains.com/support/youtrack?version=");
        sb.append(((CentralManager)ServiceLocator.getBean((String)"centralManager")).getAppicationVersion());
        if (ConfigurationUtil.isYoutrackHosted()) {
            sb.append("&hostedInstance=" + PrimitiveAssociationSemantics.getBlobAsString((Entity)((Entity)ServiceLocator.getBean((String)"applicationMetaData")), (String)"domain"));
        }
        return sb.toString();
    }

    public static boolean isTestMode() {
        return Boolean.getBoolean(TEST_MODE);
    }

    public static void setTestMode(boolean testMode) {
        System.setProperty(TEST_MODE, testMode + "");
    }

    public static boolean isEmpty_z2negs_a0a0a0i(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isEmpty_z2negs_a0b0a0i(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isEmpty_z2negs_a0c0a0i(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isEmpty_z2negs_a0a0a0j(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isEmpty_z2negs_a0b0a0j(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isEmpty_z2negs_a0a0k(String str) {
        return str == null || str.length() == 0;
    }
}

