/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.main;

import java.io.UnsupportedEncodingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.ParseException;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;

public class SingleSmtpAdressWrapper {
    private InternetAddress address;

    public void update(String address, String personal) {
        try {
            this.address = new InternetAddress(address == null ? "" : address, personal);
        }
        catch (UnsupportedEncodingException ignored) {
            this.address = null;
        }
    }

    public void parse(String unparsed) throws AddressException, ParseException {
        InternetAddress[] addresses;
        if (unparsed == null || unparsed == null || unparsed.length() == 0) {
            throw new ParseException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("SingleSmtpAdressWrapper.Empty_email_and_personal", new Object[0]));
        }
        try {
            addresses = InternetAddress.parse((String)unparsed);
        }
        catch (AddressException exception) {
            throw new ParseException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("SingleSmtpAdressWrapper.Cannot_parse_email_address", new Object[0]));
        }
        if (addresses.length > 1) {
            throw new ParseException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("SingleSmtpAdressWrapper.Only_one_email_address_available", new Object[0]));
        }
        if (addresses.length == 0) {
            throw new ParseException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("SingleSmtpAdressWrapper.No_email_has_been_specified", new Object[0]));
        }
        this.address = addresses[0];
        this.address.validate();
    }

    public String getAddress() {
        return this.address == null ? "" : this.address.getAddress();
    }

    public String getPersonal() {
        return this.address == null ? "" : this.address.getPersonal();
    }

    public String getRaw() {
        if (this.address == null) {
            return "";
        }
        return SingleSmtpAdressWrapper.isEmpty_5rfs73_a0a1a4(this.address.getPersonal()) ? this.address.getAddress() : this.address.toUnicodeString();
    }

    public static boolean isEmpty_5rfs73_a0a1a4(String str) {
        return str == null || str.length() == 0;
    }
}

