/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.misc;

import java.net.HttpURLConnection;
import java.net.URL;
import jetbrains.charisma.main.ConfigurationUtil;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.Sequence;

public enum DocumentationLink {
    ROOT(""),
    COMMANDS_QUICK_START_GUIDE("/Commands.html"),
    SHORTCUTS_REFERENCE("/Keyboard-Shortcuts.html"),
    IMAGE_EDITOR("/Edit-an-Image.html");

    private static String STANDALONE_BASE;
    private static String HOSTED_BASE;
    private String suffix;

    private DocumentationLink(String suffix) {
        this.suffix = suffix;
    }

    public String getUrl() {
        return (ConfigurationUtil.isYoutrackHosted() ? HOSTED_BASE : STANDALONE_BASE) + this.suffix;
    }

    public static void main(String[] args) {
        DocumentationLink.checkLinks(HOSTED_BASE);
        DocumentationLink.checkLinks(STANDALONE_BASE);
    }

    private static void checkLinks(final String base) {
        Sequence.fromIterable((Iterable)Sequence.fromArray((Object[])DocumentationLink.values())).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<DocumentationLink>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void visit(DocumentationLink it) {
                System.out.println("##teamcity[testStarted name='DocumentationLinkTest']");
                try {
                    int responseCode = ((HttpURLConnection)new URL(base + it.suffix).openConnection()).getResponseCode();
                    if (responseCode != 200) {
                        throw new AssertionError((Object)("Response code is " + responseCode));
                    }
                }
                catch (Throwable e) {
                    String message = "Help URL is not accessible: " + base + it.suffix + ". " + e.getMessage();
                    System.out.println("##teamcity[testFailed name='DocumentationLinkTest' message='" + message + "']");
                }
                finally {
                    System.out.println("##teamcity[testFinished name='DocumentationLinkTest']");
                }
            }
        });
    }

    static {
        STANDALONE_BASE = "https://www.jetbrains.com/help/youtrack/standalone/2018.4";
        HOSTED_BASE = "https://www.jetbrains.com/help/youtrack/incloud/2018.4";
    }
}

