/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.misc;

import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import jetbrains.charisma.misc.UploadedFile;
import jetbrains.charisma.misc.UploadedImage;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.webr.runtime.converter.TypeConvertManager;
import jetbrains.mps.webr.runtime.uri.QueryParameter;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.files.FileMeta;
import jetbrains.teamsys.dnq.runtime.files.PersistentFileImpl;
import jetbrains.teamsys.dnq.runtime.files.PersistentImageFileImpl;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import webr.framework.controller.BaseApplication;
import webr.framework.url.UrlUtil;

public class UploadedFiles {
    private UploadedFiles() {
    }

    public static boolean update(UploadedImage image, DiskFileItem file, int maxWidth, int maxHeight) {
        UploadedFile thumbnail;
        if (file != null && (thumbnail = UploadedFiles.getUploadedThumbnail(file, maxWidth, maxHeight)) != null) {
            image.setUploadedFile(UploadedFiles.saveUploadedFile(thumbnail));
            DnqUtils.getCurrentTransientSession().revert();
            return true;
        }
        return false;
    }

    public static boolean hasUri(UploadedImage file) {
        return !EntityOperations.equals((Entity)file.getSavedFile(), null) || file.getUploadedFile() != null;
    }

    @NotNull
    public static String getUri(UploadedImage file) {
        String up = file.getUploadedFile();
        return up == null ? UrlUtil.getPersistentFileUrl((Entity)file.getSavedFile(), null, null, (Boolean)true) : UrlUtil.getDispatchActionUrl((String)"UploadedFiles", (String)"name", (QueryParameter[])new QueryParameter[]{new QueryParameter("name", (Object)up, (TypeConvertManager)ServiceLocator.getBean((String)"typeConvertManager"))});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static UploadedFile getUploadedFile(String handle) {
        Map<String, UploadedFile> files;
        Map<String, UploadedFile> map = files = UploadedFiles.getSessionMap();
        synchronized (map) {
            return files.get(handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static String saveUploadedFile(@NotNull UploadedFile file) {
        Map<String, UploadedFile> files = UploadedFiles.getSessionMap();
        String handle = "upload" + System.currentTimeMillis();
        Map<String, UploadedFile> map = files;
        synchronized (map) {
            files.put(handle, file);
            return handle;
        }
    }

    private static Map<String, UploadedFile> getSessionMap() {
        return (Map)BaseApplication.getSessionField((String)"uploadedFiles");
    }

    @Nullable
    public static UploadedFile getUploadedThumbnail(@NotNull DiskFileItem item, int maxWidth, int maxHeight) {
        if (!item.getContentType().startsWith("image/")) {
            return null;
        }
        Entity f = PersistentFileImpl.constructor((DiskFileItem)item);
        final FileMeta meta = new FileMeta(f);
        InputStream thumbnail = ((PersistentFileImpl)DnqUtils.getPersistentClassInstance((Entity)f, (String)"PersistentFile")).getThumbnail(maxWidth, maxHeight, true, meta, f);
        if (thumbnail == null) {
            return null;
        }
        int size = (int)meta.getSize();
        final byte[] content = new byte[size];
        int offset = 0;
        try {
            int n;
            while ((n = thumbnail.read(content, offset, size - offset)) > 0) {
                offset += n;
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return new UploadedFile(){

            @Override
            @NotNull
            public byte[] getContent() {
                return content;
            }

            @Override
            @NotNull
            public FileMeta getMeta() {
                return meta;
            }
        };
    }

    public static Entity convertToPersistent(@NotNull UploadedFile file) {
        FileMeta meta = file.getMeta();
        Entity newIcon = PersistentImageFileImpl.constructor((InputStream)new ByteArrayInputStream(file.getContent()), (String)meta.getName(), null, (String)meta.getMimeType());
        PrimitiveAssociationSemantics.set((Entity)newIcon, (String)"size", (Comparable)Long.valueOf(meta.getSize()), Long.class);
        return newIcon;
    }
}

