/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.notifications.mail;

import java.util.HashMap;
import java.util.Map;
import jetbrains.charisma.main.ConfigurationParameter;
import jetbrains.charisma.notifications.mail.MailSendListenerAdapter;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.youtrack.api.notifications.MailingService;
import jetbrains.youtrack.api.notifications.MessageBuilder;
import jetbrains.youtrack.api.notifications.MessageSendListener;
import org.springframework.mail.javamail.MimeMessageHelper;

public class MailMessageBuilder
implements MessageBuilder {
    private MimeMessageHelper helper;
    private MailingService service;
    private MessageSendListener listener;
    private Map<String, String> customHeaders = new HashMap<String, String>();
    private boolean error = false;
    private String sesConfiguration = ConfigurationParameter.getParameter("jetbrains.youtrack.awsses.configuration");

    public MailMessageBuilder() {
        this(null);
    }

    public MailMessageBuilder(MessageSendListener listener) {
        this.listener = listener != null ? listener : new MailSendListenerAdapter();
    }

    public void setService(MailingService service) {
        this.service = service;
        try {
            this.helper = this.service.createMimeMessageHelper();
        }
        catch (Exception exception) {
            this.error(exception);
        }
    }

    public void addTo(String address, String personal) {
        if (this.error) {
            return;
        }
        try {
            this.helper.addTo(address, personal);
        }
        catch (Exception exception) {
            this.error(exception);
        }
    }

    public void addCc(String address, String personal) {
        if (this.error) {
            return;
        }
        try {
            this.helper.addCc(address, personal);
        }
        catch (Exception exception) {
            this.error(exception);
        }
    }

    public void addBcc(String address, String personal) {
        if (this.error) {
            return;
        }
        try {
            this.helper.addBcc(address, personal);
        }
        catch (Exception exception) {
            this.error(exception);
        }
    }

    public void setFrom(String address, String personal) {
        if (this.error) {
            return;
        }
        try {
            this.helper.setFrom(address, personal);
        }
        catch (Exception exception) {
            this.error(exception);
        }
    }

    public void setReplyTo(String address) {
        if (this.error) {
            return;
        }
        try {
            this.helper.setReplyTo(address);
        }
        catch (Exception exception) {
            this.error(exception);
        }
    }

    public void setText(String text) {
        if (this.error) {
            return;
        }
        try {
            this.helper.setText(text);
        }
        catch (Exception exception) {
            this.error(exception);
        }
    }

    public void setText(String text, boolean html) {
        if (this.error) {
            return;
        }
        try {
            this.helper.setText(text, html);
        }
        catch (Exception exception) {
            this.error(exception);
        }
    }

    public void setText(String text, String html) {
        if (this.error) {
            return;
        }
        try {
            this.helper.setText(text, html);
        }
        catch (Exception exception) {
            this.error(exception);
        }
    }

    public void setSubject(String subject) {
        if (this.error) {
            return;
        }
        try {
            this.helper.setSubject(subject);
        }
        catch (Exception exception) {
            this.error(exception);
        }
    }

    public void addCustomHeader(String name, String value) {
        MapSequence.fromMap(this.customHeaders).put((Object)name, (Object)value);
    }

    public void addCustomHeaders(Map<String, String> headers) {
        MapSequence.fromMap(this.customHeaders).putAll(headers);
    }

    protected void setDefaultHeaders() {
        this.customHeaders.put("X-Mailer", "YouTrack");
        this.customHeaders.put("Auto-Submitted", "auto-generated");
        this.customHeaders.put("X-Auto-Response-Suppress", "OOF, DR, RN, NRN, AutoReply");
        if (this.sesConfiguration != null) {
            this.customHeaders.put("X-SES-CONFIGURATION-SET", this.sesConfiguration);
        }
    }

    public void send() {
        if (this.error) {
            return;
        }
        this.setDefaultHeaders();
        this.service.send(this.helper, this.customHeaders, this.listener);
    }

    private void error(Exception exception) {
        this.listener.error(exception);
        this.error = true;
    }
}

