/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.persistence.security;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.DirectedAssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.BasePersistentClassImpl;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.HashSet;
import java.util.Set;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.database.TransientEntityStore;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.ring.RingImporter;
import jetbrains.youtrack.core.security.DefaultRole;
import jetbrains.youtrack.core.security.Permission;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;

public class RoleImpl
extends BasePersistentClassImpl {
    private static String __ENTITY_TYPE__ = "Role";
    private static final Log securityLog = LogFactory.getLog((String)"security");

    public void run() {
        DnqUtils.setPersistentClassInstance((String)__ENTITY_TYPE__, (BasePersistentClassImpl)this);
    }

    protected Entity _constructor(String name, String _entityType_) {
        Entity entity = super._constructor(_entityType_);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"name", (Comparable)((Object)name), String.class);
        return entity;
    }

    public void destructor(Entity entity) {
        String description = PrimitiveAssociationSemantics.getBlobAsString((Entity)entity, (String)"description");
        securityLog.info((Object)("role " + (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"name", String.class, (Object)"<no role>") + (description == null ? " deleted" : " (" + description + ") deleted")));
        super.destructor(entity);
    }

    public String getDisplayName(Entity entity) {
        super.getDisplayName(entity);
        return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Role.role_{role_name}", new Object[]{PrimitiveAssociationSemantics.getOldValue((TransientEntity)((TransientEntity)entity), (String)"name", String.class, (Object)"<no role>")});
    }

    public void executeBeforeFlushTrigger(Entity entity) {
        super.executeBeforeFlushTrigger(entity);
        boolean isNew = EntityOperations.isNew((Entity)entity);
        if (isNew) {
            securityLog.info((Object)("role " + (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"name", String.class, (Object)"<no role>") + " created"));
        }
    }

    public Iterable<Permission> getPermissions(Entity entity) {
        return RoleImpl.fromDeprecated(AssociationSemantics.getToMany((Entity)entity, (String)"permissions"));
    }

    public boolean hasPermission(Permission p, Entity entity) {
        return Sequence.fromIterable(RoleImpl.fromDeprecated(AssociationSemantics.getToMany((Entity)entity, (String)"permissions"))).contains((Object)p);
    }

    public void addPermission(Permission permission, Entity entity) {
        DirectedAssociationSemantics.createToMany((Entity)entity, (String)"permissions", (Entity)RoleImpl.toDeprecated(permission));
    }

    public void removePermission(Permission permission, Entity entity) {
        DirectedAssociationSemantics.removeToMany((Entity)entity, (String)"permissions", (Entity)RoleImpl.toDeprecated(permission));
    }

    public static Entity constructor(String name) {
        return ((RoleImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(name, __ENTITY_TYPE__);
    }

    public static Entity findOrCreate(String name) {
        Entity role = RoleImpl.find(name);
        if (EntityOperations.equals((Entity)role, null)) {
            DnqUtils.getCurrentTransientSession().flush();
            role = RoleImpl.constructor(name);
            role = ((RingImporter)ServiceLocator.getBean((String)"ringImporter")).importRole(role);
            DnqUtils.getCurrentTransientSession().flush();
        }
        return role;
    }

    public static Entity findOrCreateDeveloper() {
        return RoleImpl.findOrCreateDefaultRole(DefaultRole.DEVELOPER);
    }

    public static Entity findOrCreateProjectAdmin() {
        return RoleImpl.findOrCreateDefaultRole(DefaultRole.PROJECT_ADMIN);
    }

    private static Entity findOrCreateDefaultRole(DefaultRole defaultRole) {
        String name = defaultRole.getName();
        Entity role = RoleImpl.find(name);
        if (EntityOperations.equals((Entity)role, null)) {
            DnqUtils.getCurrentTransientSession().flush();
            role = RoleImpl.constructor(name);
            for (Permission permission : Sequence.fromIterable((Iterable)defaultRole.getPermissions())) {
                ((RoleImpl)DnqUtils.getPersistentClassInstance((Entity)role, (String)"Role")).addPermission(permission, role);
            }
            role = ((RingImporter)ServiceLocator.getBean((String)"ringImporter")).importRole(role);
            DnqUtils.getCurrentTransientSession().flush();
        }
        return role;
    }

    public static Entity find(String name) {
        return QueryOperations.getFirst((Iterable)QueryOperations.query(null, (String)"Role", (NodeBase)new PropertyEqual("name", (Comparable)((Object)name))));
    }

    public static Permission fromDeprecated(Entity permission) {
        return Enum.valueOf(Permission.class, (String)PrimitiveAssociationSemantics.get((Entity)permission, (String)"__ENUM_CONST_NAME__", String.class, null));
    }

    public static Iterable<Permission> fromDeprecated(Iterable<Entity> source) {
        return SetSequence.fromSetWithValues(new HashSet(), (Iterable)Sequence.fromIterable(source).select((_FunctionTypes._return_P1_E0)new ISelector<Entity, Permission>(){

            public Permission select(Entity it) {
                return RoleImpl.fromDeprecated(it);
            }
        }));
    }

    public static Entity toDeprecated(Permission permission) {
        return QueryOperations.getFirst((Iterable)QueryOperations.query(null, (String)"Permission", (NodeBase)new PropertyEqual("__ENUM_CONST_NAME__", (Comparable)((Object)permission.name()))));
    }

    public static Iterable<Entity> toDeprecated(Iterable<Permission> source) {
        return Sequence.fromIterable(source).select((_FunctionTypes._return_P1_E0)new ISelector<Permission, Entity>(){

            public Entity select(Permission it) {
                return RoleImpl.toDeprecated(it);
            }
        });
    }

    protected static DnqUtils.QueryingEntityCreator getEntityCreator(String entityType, String name, final Set<String> queriedParams) {
        final DnqUtils.QueryingEntityCreator parent = DnqUtils.getEntityCreator((String)entityType, queriedParams);
        final String __var__name = name;
        return new DnqUtils.QueryingEntityCreator(entityType){

            public Iterable<Entity> query() {
                Iterable result = parent.query();
                if (queriedParams.contains("name")) {
                    result = QueryOperations.query((Iterable)result, (String)"Role", (NodeBase)new PropertyEqual("name", (Comparable)((Object)__var__name)));
                }
                return result;
            }

            public void created(@NotNull Entity entity) {
                parent.created(entity);
                PrimitiveAssociationSemantics.set((Entity)entity, (String)"name", (Comparable)((Object)__var__name), String.class);
            }
        };
    }

    public static Entity findOrCreate(String name, String[] queriedParams) {
        return RoleImpl.getEntityCreator(__ENTITY_TYPE__, name, BasePersistentClassImpl.buildSet((Object[])queriedParams)).create((TransientEntityStore)ServiceLocator.getBean((String)"transientEntityStore"));
    }
}

