/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.persistence.user;

import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jetbrains.charisma.persistence.user.ProjectCustomFieldsSnapshot;
import jetbrains.exodus.core.dataStructures.hash.LinkedHashSet;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.core.security.Permission;

public abstract class BasePermissionsData {
    protected final Map<Entity, List<Entity>> readPermittedCustomFields = new jetbrains.exodus.core.dataStructures.hash.HashMap();
    protected Map<Entity, HashMap<Entity, Operation>> projectToReadOperation = new HashMap<Entity, HashMap<Entity, Operation>>();
    protected final Map<Entity, List<Entity>> writePermittedCustomFields = new jetbrains.exodus.core.dataStructures.hash.HashMap();
    protected Map<Entity, HashMap<Entity, Operation>> projectToWriteOperation = new HashMap<Entity, HashMap<Entity, Operation>>();
    protected Map<EntityId, List<Entity>> bundleReadPermittedCustomFields = new jetbrains.exodus.core.dataStructures.hash.HashMap();
    protected Map<EntityId, List<Entity>> bundleWritePermittedCustomFields = new jetbrains.exodus.core.dataStructures.hash.HashMap();
    protected Map<Entity, Set<Entity>> bundleReadPermittedCustomFieldPrototypes = new jetbrains.exodus.core.dataStructures.hash.HashMap();
    protected Map<Entity, Set<Entity>> bundleWritePermittedCustomFieldPrototypes = new jetbrains.exodus.core.dataStructures.hash.HashMap();
    protected final Set<Entity> allReadPermittedCustomFields = new LinkedHashSet();
    protected final Set<Entity> allReadPermittedCustomFieldPrototypes = new LinkedHashSet();
    protected final Set<Entity> allWritePermittedCustomFields = new LinkedHashSet();
    protected final Set<Entity> allWritePermittedCustomFieldPrototypes = new LinkedHashSet();

    public Set<Entity> getReadPermittedCustomFields() {
        return this.allReadPermittedCustomFields;
    }

    public Set<Entity> getWritePermittedCustomFields() {
        return this.allWritePermittedCustomFields;
    }

    public Set<Entity> getReadPermittedCustomFieldPrototypes() {
        return this.allReadPermittedCustomFieldPrototypes;
    }

    public Set<Entity> getWritePermittedCustomFieldPrototypes() {
        return this.allWritePermittedCustomFieldPrototypes;
    }

    public List<Entity> getReadPermittedCustomFields(Entity prototype) {
        List pcfs = this.readPermittedCustomFields.get(prototype);
        return pcfs == null ? BasePermissionsData.as_4kstqm_a0a1a4(Collections.emptyList(), List.class) : pcfs;
    }

    public List<Entity> getWritePermittedCustomFields(Entity prototype) {
        List pcfs = this.writePermittedCustomFields.get(prototype);
        return pcfs == null ? BasePermissionsData.as_4kstqm_a0a1a5(Collections.emptyList(), List.class) : pcfs;
    }

    public Map<Entity, Operation> getProjectsToReadOperation(Entity prototype) {
        Map res = this.projectToReadOperation.get(prototype);
        return res == null ? BasePermissionsData.as_4kstqm_a0a1a6(Collections.emptyMap(), Map.class) : res;
    }

    public Map<Entity, Operation> getProjectsToWriteOperation(Entity prototype) {
        Map res = this.projectToWriteOperation.get(prototype);
        return res == null ? BasePermissionsData.as_4kstqm_a0a1a7(Collections.emptyMap(), Map.class) : res;
    }

    public List<Entity> getBundleReadPermittedCustomFields(EntityId bundleId) {
        List pcfs = this.bundleReadPermittedCustomFields.get(bundleId);
        return pcfs == null ? BasePermissionsData.as_4kstqm_a0a1a8(Collections.emptyList(), List.class) : pcfs;
    }

    public List<Entity> getBundleWritePermittedCustomFields(EntityId bundleId) {
        List pcfs = this.bundleWritePermittedCustomFields.get(bundleId);
        return pcfs == null ? BasePermissionsData.as_4kstqm_a0a1a9(Collections.emptyList(), List.class) : pcfs;
    }

    public Set<Entity> getBundleReadPermittedCustomFieldPrototypes(Entity bundle) {
        Set cfps = this.bundleReadPermittedCustomFieldPrototypes.get(bundle);
        return cfps == null ? BasePermissionsData.as_4kstqm_a0a1a01(Collections.emptySet(), Set.class) : cfps;
    }

    public Set<Entity> getBundleWritePermittedCustomFieldPrototypes(Entity bundle) {
        Set cfps = this.bundleWritePermittedCustomFieldPrototypes.get(bundle);
        return cfps == null ? BasePermissionsData.as_4kstqm_a0a1a11(Collections.emptySet(), Set.class) : cfps;
    }

    protected abstract Set<Entity> getProjectsForPermission(Permission var1);

    protected void calculateProjectCustomFields(ProjectCustomFieldsSnapshot snapshot) {
        Set<Entity> createIssueProjects = this.getProjectsForPermission(Permission.CREATE_ISSUE);
        HashMap<String, Set<Entity>> readPermissionsToProject = new HashMap<String, Set<Entity>>(2);
        HashMap<String, Set<Entity>> writePermissionsToProject = new HashMap<String, Set<Entity>>(2);
        for (ProjectCustomFieldsSnapshot.Field pcf : snapshot.projectCustomFields) {
            Set<Entity> writePermittedProjects;
            Entity prototype = pcf.prototype;
            Entity bundle = pcf.bundle;
            Entity project = pcf.project;
            Set<Entity> readPermittedProjects = this.getReadPermittedProjects(readPermissionsToProject, pcf.isPrivate, createIssueProjects, pcf.readPermissionName);
            boolean hasBundle = !EntityOperations.equals((Entity)bundle, null);
            this.putProject(this.projectToReadOperation, pcf, pcf.readPermissionName);
            if (readPermittedProjects != null && readPermittedProjects.contains(project)) {
                this.putField(this.readPermittedCustomFields, prototype, pcf);
                this.putProject(this.projectToWriteOperation, pcf, pcf.writePermissionName);
                if (hasBundle) {
                    EntityId bundleId = pcf.bundleId;
                    this.putField(this.bundleReadPermittedCustomFields, bundleId, pcf);
                    Set<Entity> protos = this.bundleReadPermittedCustomFieldPrototypes.get(bundle);
                    if (protos == null) {
                        protos = new HashSet<Entity>();
                        this.bundleReadPermittedCustomFieldPrototypes.put(bundle, protos);
                    }
                    protos.add(prototype);
                }
                this.allReadPermittedCustomFields.add(pcf.projectCustomField);
                this.allReadPermittedCustomFieldPrototypes.add(prototype);
            }
            if ((writePermittedProjects = this.getWritePermittedProjects(writePermissionsToProject, pcf.writePermissionName)) == null || !writePermittedProjects.contains(project)) continue;
            this.putField(this.writePermittedCustomFields, prototype, pcf);
            if (hasBundle) {
                EntityId bundleId = bundle.getId();
                this.putField(this.bundleWritePermittedCustomFields, bundleId, pcf);
                jetbrains.exodus.core.dataStructures.hash.HashSet protos = this.bundleWritePermittedCustomFieldPrototypes.get(bundle);
                if (protos == null) {
                    protos = new jetbrains.exodus.core.dataStructures.hash.HashSet();
                    this.bundleWritePermittedCustomFieldPrototypes.put(bundle, (Set<Entity>)protos);
                }
                protos.add((Entity)prototype);
            }
            this.allWritePermittedCustomFields.add(pcf.projectCustomField);
            this.allWritePermittedCustomFieldPrototypes.add(prototype);
        }
    }

    private void putProject(Map<Entity, HashMap<Entity, Operation>> map, ProjectCustomFieldsSnapshot.Field pcf, String permissionName) {
        HashMap<Object, Object> projects = map.get(pcf.prototype);
        if (projects == null) {
            projects = new HashMap(1);
            map.put(pcf.prototype, projects);
        }
        projects.put(pcf.project, Permission.valueOf((String)permissionName).getOperation());
    }

    private <T> void putField(Map<T, List<Entity>> map, T key, ProjectCustomFieldsSnapshot.Field pcf) {
        List<Entity> fields = map.get(key);
        if (fields == null) {
            fields = new ArrayList<Entity>(1);
            map.put(key, fields);
        }
        fields.add(pcf.projectCustomField);
    }

    private Set<Entity> getWritePermittedProjects(Map<String, Set<Entity>> writePermissionsToProject, String writePermissionName) {
        Set<Entity> writePermittedProjects;
        if (writePermissionsToProject.containsKey(writePermissionName)) {
            writePermittedProjects = writePermissionsToProject.get(writePermissionName);
        } else {
            writePermittedProjects = this.getProjectsForPermission(Enum.valueOf(Permission.class, writePermissionName));
            writePermissionsToProject.put(writePermissionName, writePermittedProjects);
        }
        return writePermittedProjects;
    }

    private Set<Entity> getReadPermittedProjects(Map<String, Set<Entity>> readPermissionsToProject, Boolean isPrivate, Set<Entity> createIssueProjects, String readPermissionName) {
        jetbrains.exodus.core.dataStructures.hash.HashSet readPermittedProjects;
        if (readPermissionsToProject.containsKey(readPermissionName)) {
            readPermittedProjects = readPermissionsToProject.get(readPermissionName);
        } else {
            readPermittedProjects = this.getProjectsForPermission(Enum.valueOf(Permission.class, readPermissionName));
            if (!isPrivate.booleanValue() && createIssueProjects != null) {
                if (readPermittedProjects == null) {
                    readPermittedProjects = createIssueProjects;
                } else {
                    readPermittedProjects = new jetbrains.exodus.core.dataStructures.hash.HashSet(readPermittedProjects);
                    readPermittedProjects.addAll(createIssueProjects);
                }
            }
            readPermissionsToProject.put(readPermissionName, (Set<Entity>)readPermittedProjects);
        }
        return readPermittedProjects;
    }

    private static <T> T as_4kstqm_a0a1a4(Object o, Class<T> type) {
        return (T)(type.isInstance(o) ? o : null);
    }

    private static <T> T as_4kstqm_a0a1a5(Object o, Class<T> type) {
        return (T)(type.isInstance(o) ? o : null);
    }

    private static <T> T as_4kstqm_a0a1a6(Object o, Class<T> type) {
        return (T)(type.isInstance(o) ? o : null);
    }

    private static <T> T as_4kstqm_a0a1a7(Object o, Class<T> type) {
        return (T)(type.isInstance(o) ? o : null);
    }

    private static <T> T as_4kstqm_a0a1a8(Object o, Class<T> type) {
        return (T)(type.isInstance(o) ? o : null);
    }

    private static <T> T as_4kstqm_a0a1a9(Object o, Class<T> type) {
        return (T)(type.isInstance(o) ? o : null);
    }

    private static <T> T as_4kstqm_a0a1a01(Object o, Class<T> type) {
        return (T)(type.isInstance(o) ? o : null);
    }

    private static <T> T as_4kstqm_a0a1a11(Object o, Class<T> type) {
        return (T)(type.isInstance(o) ? o : null);
    }
}

