/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.persistence.user;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.DirectedAssociationSemantics;
import jetbrains.charisma.authentication.BaseUserDataImpl;
import jetbrains.charisma.persistence.user.UserImpl;
import jetbrains.charisma.plugins.UserMergeHandler;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.LinkEqual;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.TreeKeepingEntityIterable;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;

public class MiscUserMergeHandler
implements UserMergeHandler {
    @Override
    public void userDeleted(final Entity deleted, Entity successor) {
        this.reassignProjectFields(deleted, successor);
        Sequence.fromIterable((Iterable)QueryOperations.query(null, (String)"DatabaseBackupConfig", (NodeBase)new LinkEqual("notifiedUsers", deleted))).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

            public void visit(Entity it) {
                DirectedAssociationSemantics.removeToMany((Entity)it, (String)"notifiedUsers", (Entity)deleted);
            }
        });
    }

    @Override
    public void userMerged(final Entity from, final Entity into) {
        if (!((UserImpl)DnqUtils.getPersistentClassInstance((Entity)into, (String)"User")).isGuest(into)) {
            Sequence.fromIterable((Iterable)QueryOperations.query(null, (String)"BaseUserData", (NodeBase)new LinkEqual("user", from))).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

                public void visit(Entity it) {
                    ((BaseUserDataImpl)DnqUtils.getPersistentClassInstance((Entity)it, (String)"BaseUserData")).reassign(into, it);
                }
            });
            this.processProjectPinMerge(from, into);
        }
        this.reassignProjectFields(from, into);
        Sequence.fromIterable((Iterable)QueryOperations.query(null, (String)"DatabaseBackupConfig", (NodeBase)new LinkEqual("notifiedUsers", from))).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

            public void visit(Entity it) {
                DirectedAssociationSemantics.removeToMany((Entity)it, (String)"notifiedUsers", (Entity)from);
                if (!((UserImpl)DnqUtils.getPersistentClassInstance((Entity)into, (String)"User")).isGuest(into)) {
                    DirectedAssociationSemantics.createToMany((Entity)it, (String)"notifiedUsers", (Entity)into);
                }
            }
        });
    }

    @Override
    public Integer priority() {
        return 10000;
    }

    private void reassignProjectFields(Entity from, final Entity into) {
        Sequence.fromIterable((Iterable)QueryOperations.query(null, (String)"Project", (NodeBase)new LinkEqual("leader", from))).toListSequence().visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

            public void visit(Entity it) {
                DirectedAssociationSemantics.setToOne((Entity)it, (String)"leader", (Entity)(((UserImpl)DnqUtils.getPersistentClassInstance((Entity)into, (String)"User")).isGuest(into) ? (Entity)ServiceLocator.getBean((String)"deletedUser") : into));
            }
        });
        Sequence.fromIterable((Iterable)QueryOperations.query(null, (String)"Project", (NodeBase)new LinkEqual("createdBy", from))).toListSequence().visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

            public void visit(Entity it) {
                DirectedAssociationSemantics.setToOne((Entity)it, (String)"createdBy", (Entity)(((UserImpl)DnqUtils.getPersistentClassInstance((Entity)into, (String)"User")).isGuest(into) ? (Entity)ServiceLocator.getBean((String)"deletedUser") : into));
            }
        });
    }

    private void processProjectPinMerge(Entity from, final Entity to) {
        final Iterable projectsPinnedByTargetUser = QueryOperations.selectDistinct((Iterable)QueryOperations.query(null, (String)"ProjectPin", (NodeBase)new LinkEqual("user", from)), (String)"project");
        TreeKeepingEntityIterable pinsBySourceUser = QueryOperations.query(null, (String)"ProjectPin", (NodeBase)new LinkEqual("user", from));
        Sequence.fromIterable((Iterable)pinsBySourceUser).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

            public boolean accept(Entity it) {
                return !QueryOperations.contains((Iterable)projectsPinnedByTargetUser, (Entity)AssociationSemantics.getToOne((Entity)it, (String)"project"));
            }
        }).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

            public void visit(Entity it) {
                DirectedAssociationSemantics.setToOne((Entity)it, (String)"user", (Entity)to);
            }
        });
    }
}

