/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.persistence.user;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import jetbrains.charisma.persistence.security.RoleImpl;
import jetbrains.charisma.persistence.user.BasePermissionsData;
import jetbrains.charisma.persistence.user.ProjectCustomFieldsSnapshot;
import jetbrains.exodus.core.dataStructures.Pair;
import jetbrains.exodus.core.dataStructures.hash.HashMap;
import jetbrains.exodus.core.dataStructures.hash.HashSet;
import jetbrains.exodus.core.dataStructures.hash.LongHashMap;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.util.StringInterner;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.youtrack.core.security.Permission;

class PermissionData
extends BasePermissionsData {
    private final Set<Entity> roles;
    private final Set<Entity> userRoles;
    private final Map<Permission, List<Entity>> permissionToProject;
    private Map<Permission, Set<Entity>> _permissionToProject;
    protected final String handle;

    public PermissionData(Set<Entity> ownRoles, Set<Entity> roles, Set<Entity> groups, String handle, InitParams params) {
        this.handle = handle;
        if (ownRoles.isEmpty() && groups.size() == 1) {
            Entity group = groups.iterator().next();
            Pair pair = (Pair)params.allGroupsData.get(group.getId().getLocalId());
            if (pair != null) {
                ownRoles = (Set)pair.getFirst();
                roles = (Set)pair.getSecond();
            }
        } else {
            if (ownRoles.isEmpty()) {
                ownRoles = new HashSet();
                roles = new HashSet();
            }
            for (Entity group : groups) {
                Pair pair = (Pair)params.allGroupsData.get(group.getId().getLocalId());
                if (pair == null) continue;
                ownRoles.addAll((Collection)pair.getFirst());
                roles.addAll((Collection)pair.getSecond());
            }
        }
        this.userRoles = ownRoles;
        this.roles = roles;
        this._permissionToProject = new HashMap();
        this.calculatePermissionToProjects((Set<Entity>)ownRoles, this._permissionToProject, params);
        this.calculateProjectCustomFields(new ProjectCustomFieldsSnapshot());
        HashMap permissionToProject = new HashMap();
        for (Map.Entry<Permission, Set<Entity>> perm : this._permissionToProject.entrySet()) {
            Set<Entity> filter = perm.getValue();
            ArrayList<Entity> value = new ArrayList<Entity>(filter.size());
            for (Entity p : params.sortedProjects) {
                if (!filter.contains(p)) continue;
                value.add(p);
            }
            permissionToProject.put(perm.getKey(), value);
        }
        for (Permission issueRelatedPermission : SetSequence.fromSet(params.issueRelatedPermissions)) {
            List projectsWithPermission = (List)permissionToProject.get(issueRelatedPermission);
            if (projectsWithPermission == null) continue;
            if (params.archivedProjects.containsAll(projectsWithPermission)) {
                permissionToProject.put(issueRelatedPermission, null);
                continue;
            }
            ListIterator listIterator = projectsWithPermission.listIterator();
            while (listIterator.hasNext()) {
                Entity project = (Entity)listIterator.next();
                if (!params.archivedProjects.contains(project)) continue;
                listIterator.remove();
            }
        }
        this.permissionToProject = permissionToProject;
    }

    public int hashCode() {
        return this.handle.hashCode();
    }

    public Map<Permission, List<Entity>> getPermissionToProject() {
        return this.permissionToProject;
    }

    public Set<Entity> getUserRoles() {
        return this.userRoles;
    }

    public Set<Entity> getRoles() {
        return this.roles;
    }

    private void calculatePermissionToProjects(Set<Entity> ownRoles, Map<Permission, Set<Entity>> permissionToProjects, InitParams params) {
        for (Entity ur : ownRoles) {
            for (Entity perm : Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)AssociationSemantics.getToOne((Entity)ur, (String)"role"), (String)"permissions"))) {
                Iterable ur_projects;
                Iterator itr;
                Permission permissionKey = RoleImpl.fromDeprecated(perm);
                HashSet projects = permissionToProjects.get(permissionKey);
                if (projects != null && projects.isEmpty()) continue;
                if (projects == null) {
                    projects = new HashSet();
                    permissionToProjects.put(permissionKey, (Set<Entity>)projects);
                }
                if ((itr = (ur_projects = AssociationSemantics.getToMany((Entity)ur, (String)"projects")).iterator()).hasNext()) {
                    do {
                        projects.add(itr.next());
                    } while (itr.hasNext());
                    continue;
                }
                projects.addAll(params.sortedProjects);
            }
        }
    }

    @Override
    protected Set<Entity> getProjectsForPermission(Permission permission) {
        return this._permissionToProject.get(permission);
    }

    static String createHandle(Iterable<Entity> roles, Iterable<Entity> groups) {
        StringBuilder builder = new StringBuilder(20);
        for (Entity role : roles) {
            builder.append('r').append(role.getId().getLocalId());
        }
        if (groups != null) {
            for (Entity group : groups) {
                builder.append('g').append(group.getId().getLocalId());
            }
        }
        return StringInterner.intern((String)builder.toString());
    }

    public static class InitParams {
        public LongHashMap<Pair<Set<Entity>, Set<Entity>>> allGroupsData;
        public List<Entity> allProjectCustomFields;
        public List<Entity> sortedProjects;
        public Set<Permission> issueRelatedPermissions;
        public Set<Entity> archivedProjects;
    }
}

