/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.persistence.user;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import jetbrains.charisma.persistence.security.RoleImpl;
import jetbrains.charisma.persistence.security.UserGroupImpl;
import jetbrains.charisma.persistence.user.BaseUserPermissionsCache;
import jetbrains.charisma.persistence.user.PermissionData;
import jetbrains.charisma.persistence.user.UserImpl;
import jetbrains.charisma.persistence.user.UserPermissionsCacheData;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.LinkEqual;
import jetbrains.exodus.query.NodeBase;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.txn._Txn;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.core.security.Security;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UserPermissionsCache
extends BaseUserPermissionsCache {
    protected static Log log = LogFactory.getLog(UserPermissionsCache.class);

    UserPermissionsCache() {
    }

    public Map<Permission, List<Entity>> getPermissionToProject(Entity user) {
        PermissionData permissionData = this.getPermissionData(user);
        if (permissionData == null) {
            String handle = PermissionData.createHandle(AssociationSemantics.getToMany((Entity)user, (String)"userRoles"), AssociationSemantics.getToMany((Entity)user, (String)"groups"));
            PermissionData permissionData2 = permissionData = this.getData() == null ? null : (PermissionData)this.getData().permissions.get(handle);
            if (permissionData == null) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("No permissions data for user: " + user));
                }
                return ((Security)ServiceLocator.getBean((String)"security")).getPermissionToProjectInMemory(user, false);
            }
        }
        return permissionData.getPermissionToProject();
    }

    @Override
    @Nullable
    public UserPermissionsCacheData getData() {
        return (UserPermissionsCacheData)this.data;
    }

    @Override
    protected PermissionData getPermissionData(Entity user) {
        return (PermissionData)super.getPermissionData(user);
    }

    public boolean hasPermission(Entity user, Permission permission) {
        PermissionData permissionData = this.getPermissionData(user);
        if (permissionData == null) {
            return this.hasPermissionInDatabase(user, permission);
        }
        return permissionData.getPermissionToProject().containsKey(permission);
    }

    public Iterable<Entity> getRoles(Entity user) {
        PermissionData permissionData = this.getPermissionData(user);
        return permissionData == null ? QueryOperations.selectDistinct(((UserImpl)DnqUtils.getPersistentClassInstance((Entity)user, (String)"User")).getUserRolesInMemory(user), (String)"role") : permissionData.getRoles();
    }

    public Iterable<Entity> getUserRoles(Entity user) {
        PermissionData permissionData = this.getPermissionData(user);
        return permissionData == null ? ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)user, (String)"User")).getUserRolesInMemory(user) : permissionData.getUserRoles();
    }

    @Override
    protected void recalculate() {
        _Txn.runNew((_FunctionTypes._void_P0_E0)new _FunctionTypes._void_P0_E0(){

            public void invoke() {
                UserPermissionsCache.this.data = new UserPermissionsCacheData();
            }
        });
    }

    @Override
    @NotNull
    protected Collection<Entity> getProjectsForPermission(Entity user, String permissionName) {
        Collection projects = ((Security)ServiceLocator.getBean((String)"security")).getProjectsUnordered(user, Enum.valueOf(Permission.class, permissionName), false);
        return projects == null ? Collections.EMPTY_LIST : projects;
    }

    private boolean hasPermissionInDatabase(Entity user, Permission permission) {
        Iterable result = QueryOperations.empty((String)"User");
        for (Entity role : Sequence.fromIterable((Iterable)QueryOperations.query(null, (String)"Role", (NodeBase)new LinkEqual("permissions", RoleImpl.toDeprecated(permission))))) {
            for (Entity userRole : Sequence.fromIterable((Iterable)QueryOperations.query(null, (String)"UserRole", (NodeBase)new LinkEqual("role", role)))) {
                Entity u = AssociationSemantics.getToOne((Entity)userRole, (String)"user");
                if (!EntityOperations.equals((Entity)u, null)) {
                    if (!EntityOperations.equals((Entity)u, (Object)user)) continue;
                    return true;
                }
                result = QueryOperations.union((Iterable)result, ((UserGroupImpl)DnqUtils.getPersistentClassInstance((Entity)AssociationSemantics.getToOne((Entity)userRole, (String)"userGroup"), (String)"UserGroup")).getUsersIncludingChildrenGroups(AssociationSemantics.getToOne((Entity)userRole, (String)"userGroup")));
            }
        }
        return QueryOperations.contains((Iterable)result, (Entity)user);
    }
}

