/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.persistence.user;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import jetbrains.charisma.persistence.customfields.ProjectCustomFieldImpl;
import jetbrains.charisma.persistence.user.BaseUserPermissionsCacheData;
import jetbrains.charisma.persistence.user.PermissionData;
import jetbrains.exodus.core.dataStructures.NanoSet;
import jetbrains.exodus.core.dataStructures.Pair;
import jetbrains.exodus.core.dataStructures.hash.LongHashMap;
import jetbrains.exodus.entitystore.ComparableGetter;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.ComparableGetterSort;
import jetbrains.exodus.query.LinkEqual;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.exodus.query.UnaryNot;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.core.persistent.ProjectImpl;
import jetbrains.youtrack.core.security.Permission;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class UserPermissionsCacheData
extends BaseUserPermissionsCacheData {
    private static final Log log = LogFactory.getLog(UserPermissionsCacheData.class);

    UserPermissionsCacheData() {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Start (re)calculating user permissions", new Throwable());
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Start (re)calculating user permissions");
        }
        long time = System.nanoTime();
        Entity allUsersGroup = (Entity)ServiceLocator.getBean((String)"allUsersGroup");
        NanoSet allUsersGroupSet = new NanoSet((Object)allUsersGroup);
        LongHashMap<Set<Entity>> userData = this.preloadGroups();
        PermissionData.InitParams params = new PermissionData.InitParams();
        params.allGroupsData = this.preloadGroupRoles();
        LongHashMap<Pair<Set<Entity>, Set<Entity>>> userRoles = this.preloadUserRoles();
        params.issueRelatedPermissions = SetSequence.fromSetWithValues(new HashSet(), (Iterable)Sequence.fromIterable((Iterable)Sequence.fromArray((Object[])Permission.values())).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Permission>(){

            public boolean accept(Permission it) {
                String permClass = it.getPersistentClass();
                return UserPermissionsCacheData.eq_nc7al5_a0a0a1a0a0a0b0a01a0_0(permClass, "IssueWorkItem") || UserPermissionsCacheData.eq_nc7al5_a0a0a1a0a0a0b0a01a0(permClass, "IssueComment") || UserPermissionsCacheData.eq_nc7al5_a0a0b0a0a0a1a0k0a(permClass, "Issue") || UserPermissionsCacheData.eq_nc7al5_a0a1a0a0a0b0a01a0(permClass, "Project");
            }
        }));
        params.archivedProjects = SetSequence.fromSetWithValues(new HashSet(), (Iterable)QueryOperations.query(null, (String)"Project", (NodeBase)new PropertyEqual("archived", (Comparable)Boolean.TRUE)));
        params.sortedProjects = new ArrayList<Entity>((Collection<Entity>)Sequence.fromIterable((Iterable)QueryOperations.query(null, (String)"Project", (NodeBase)new UnaryNot((NodeBase)new PropertyEqual("needsToContinueImport", (Comparable)Boolean.TRUE)))).toListSequence());
        Collections.sort(params.sortedProjects, ProjectImpl.COMPARATOR);
        params.allProjectCustomFields = Sequence.fromIterable((Iterable)QueryOperations.query((Iterable)QueryOperations.queryGetAll((String)"ProjectCustomField"), (String)"ProjectCustomField", (NodeBase)ComparableGetterSort.create(null, (ComparableGetter)new ComparableGetter(){

            public Comparable select(Entity it) {
                return Integer.valueOf(((ProjectCustomFieldImpl)DnqUtils.getPersistentClassInstance((Entity)it, (String)"ProjectCustomField")).getOrdinalNoCache(it));
            }
        }, (boolean)true))).toListSequence();
        if (log.isDebugEnabled()) {
            long preloadTime = System.nanoTime() - time;
            log.debug((Object)("Finish preloading security principals in: " + preloadTime / 1000000000L + "s"));
        }
        for (Entity user : QueryOperations.queryGetAll((String)"User")) {
            long id = user.getId().getLocalId();
            Pair pair = (Pair)userRoles.get(id);
            Set groups = (Set)userData.get(id);
            Set ur = pair == null ? Collections.EMPTY_SET : (Set)pair.getFirst();
            Set r = pair == null ? Collections.EMPTY_SET : (Set)pair.getSecond();
            String handle = PermissionData.createHandle(ur, groups);
            if (this.permissions.containsKey(handle)) {
                this.userPermissions.put(this.getUserKey(user), this.permissions.get(handle));
                continue;
            }
            if (groups == null) {
                groups = allUsersGroupSet;
            } else {
                groups.add(allUsersGroup);
            }
            PermissionData data = new PermissionData(ur, r, groups, handle, params);
            this.userPermissions.put(this.getUserKey(user), data);
            this.permissions.put(handle, data);
        }
        if (log.isDebugEnabled()) {
            time = System.nanoTime() - time;
            log.debug((Object)("Finish calculating user permissions in: " + time / 1000000000L + "s"));
        }
    }

    private LongHashMap<Pair<Set<Entity>, Set<Entity>>> preloadUserRoles() {
        LongHashMap userRoles = new LongHashMap();
        for (Entity userRole : QueryOperations.query(null, (String)"UserRole", (NodeBase)new UnaryNot((NodeBase)new LinkEqual("user", null)))) {
            Object r;
            Object ur;
            Entity user = AssociationSemantics.getToOne((Entity)userRole, (String)"user");
            long id = user.getId().getLocalId();
            Pair pair = (Pair)userRoles.get(id);
            if (pair == null) {
                ur = new jetbrains.exodus.core.dataStructures.hash.HashSet();
                r = new jetbrains.exodus.core.dataStructures.hash.HashSet();
                pair = new Pair(ur, r);
                userRoles.put(id, (Object)pair);
            } else {
                ur = (Set)pair.getFirst();
                r = (Set)pair.getSecond();
            }
            ur.add(userRole);
            r.add(AssociationSemantics.getToOne((Entity)userRole, (String)"role"));
        }
        return userRoles;
    }

    private LongHashMap<Pair<Set<Entity>, Set<Entity>>> preloadGroupRoles() {
        LongHashMap userRoles = new LongHashMap();
        for (Entity userRole : QueryOperations.query(null, (String)"UserRole", (NodeBase)new UnaryNot((NodeBase)new LinkEqual("userGroup", null)))) {
            Object r;
            Object ur;
            Entity userGroup = AssociationSemantics.getToOne((Entity)userRole, (String)"userGroup");
            long id = userGroup.getId().getLocalId();
            Pair pair = (Pair)userRoles.get(id);
            if (pair == null) {
                ur = new jetbrains.exodus.core.dataStructures.hash.HashSet();
                r = new jetbrains.exodus.core.dataStructures.hash.HashSet();
                pair = new Pair(ur, r);
                userRoles.put(id, (Object)pair);
            } else {
                ur = (Set)pair.getFirst();
                r = (Set)pair.getSecond();
            }
            ur.add(userRole);
            r.add(AssociationSemantics.getToOne((Entity)userRole, (String)"role"));
        }
        return userRoles;
    }

    private LongHashMap<Set<Entity>> preloadGroups() {
        LongHashMap userGroups = new LongHashMap();
        for (Entity userGroup : QueryOperations.queryGetAll((String)"UserGroup")) {
            for (Entity user : AssociationSemantics.getToMany((Entity)userGroup, (String)"users")) {
                long id = user.getId().getLocalId();
                Set set = (Set)userGroups.get(id);
                if (set == null) {
                    set = new jetbrains.exodus.core.dataStructures.hash.HashSet();
                    userGroups.put(id, (Object)set);
                }
                set.add(userGroup);
            }
        }
        return userGroups;
    }

    private static boolean eq_nc7al5_a0a0b0a0a0a1a0k0a(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }

    private static boolean eq_nc7al5_a0a0a1a0a0a0b0a01a0(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }

    private static boolean eq_nc7al5_a0a0a1a0a0a0b0a01a0_0(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }

    private static boolean eq_nc7al5_a0a1a0a0a0b0a01a0(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }
}

