/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.persistence.user;

import com.jetbrains.teamsys.dnq.association.DirectedAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import jetbrains.charisma.authentication.UserDataFactory;
import jetbrains.charisma.persistence.user.UserImpl;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.jetpass.pojo.api.authority.profile.LoginUtils;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.ring.RingImporter;
import org.jetbrains.annotations.NotNull;

public class UserUtil {
    @NotNull
    public static Entity findOrCreateAndImport(String login, String email, String password, String displayName, UserDataFactory userDataFactory) {
        Entity user = UserImpl.findOrCreate(LoginUtils.fix((String)login), email, password, displayName, new String[]{"login"});
        if (EntityOperations.isNew((Entity)user)) {
            ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)user, (String)"User")).register(user);
            if (userDataFactory != null) {
                Entity userData = userDataFactory.createUserData();
                DirectedAssociationSemantics.setToOne((Entity)userData, (String)"user", (Entity)user);
            }
            user = ((RingImporter)ServiceLocator.getBean((String)"ringImporter")).importUser(user);
        }
        return user;
    }

    public static String findUniqueUserLogin(String loginBase) {
        String login = loginBase;
        int uniqueSuffix = 0;
        while (!EntityOperations.equals((Entity)UserImpl.findUser(login), null)) {
            login = loginBase + ++uniqueSuffix;
        }
        return login;
    }
}

