/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.persistence.user;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import jetbrains.charisma.persistence.security.RoleImpl;
import jetbrains.charisma.persistence.user.AbstractYouTrackSecurity;
import jetbrains.charisma.persistence.user.UserImpl;
import jetbrains.charisma.persistence.user.UserPermissionsCache;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.query.And;
import jetbrains.exodus.query.LinksEqualDecorator;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.exodus.query.UnaryNot;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.core.persistent.ProjectImpl;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.core.security.Security;

public class YouTrackSecurityImpl
extends AbstractYouTrackSecurity {
    protected volatile UserPermissionsCache userPermissionsCache;

    public void checkCacheCreated() {
        if (this.userPermissionsCache == null) {
            this.userPermissionsCache = new UserPermissionsCache();
            this.userPermissionsCache.recalculate();
        }
    }

    public Map<Permission, List<Entity>> getPermissionToProject(Entity user) {
        this.checkCacheCreated();
        return this.userPermissionsCache.getPermissionToProject(user);
    }

    public Map<Permission, List<Entity>> getPermissionToProjectInMemory(Entity user, final boolean withImporting) {
        final HashMap permissionToProjects = new HashMap();
        Sequence.fromIterable(((UserImpl)DnqUtils.getPersistentClassInstance((Entity)user, (String)"User")).getUserRolesInMemory(user)).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

            public void visit(Entity ur) {
                for (Permission perm : Sequence.fromIterable(RoleImpl.fromDeprecated(AssociationSemantics.getToMany((Entity)AssociationSemantics.getToOne((Entity)ur, (String)"role"), (String)"permissions")))) {
                    HashSet<Entity> projects = (HashSet<Entity>)permissionToProjects.get(perm);
                    if (projects != null && projects.isEmpty()) continue;
                    if (projects == null) {
                        projects = new HashSet<Entity>();
                        permissionToProjects.put(perm, projects);
                    }
                    Object projectsList = Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)ur, (String)"projects")).isEmpty() ? QueryOperations.queryGetAll((String)"Project") : AssociationSemantics.getToMany((Entity)ur, (String)"projects");
                    if (!withImporting) {
                        projectsList = QueryOperations.query((Iterable)projectsList, (String)"Project", (NodeBase)new And((NodeBase)new UnaryNot((NodeBase)new PropertyEqual("needsToContinueImport", (Comparable)Boolean.TRUE)), (NodeBase)new UnaryNot((NodeBase)new PropertyEqual("archived", (Comparable)Boolean.TRUE))));
                    }
                    for (Entity p : Sequence.fromIterable((Iterable)projectsList)) {
                        if (EntityOperations.isRemoved((Entity)p)) continue;
                        projects.add(p);
                    }
                }
            }
        });
        HashMap<Permission, List<Entity>> result = new HashMap<Permission, List<Entity>>();
        for (Map.Entry perm : permissionToProjects.entrySet()) {
            ArrayList value = new ArrayList((Collection)perm.getValue());
            Collections.sort(value, ProjectImpl.COMPARATOR);
            result.put((Permission)perm.getKey(), value);
        }
        return result;
    }

    public boolean hasPermission(Entity user, Permission permission) {
        this.checkCacheCreated();
        return this.userPermissionsCache.hasPermission(user, permission);
    }

    public boolean hasPermission(Entity user, Permission permission, Entity project) {
        if (((UserImpl)DnqUtils.getPersistentClassInstance((Entity)user, (String)"User")).isSystem(user)) {
            return true;
        }
        List<Entity> projects = this.getProjects(user, permission, false);
        return projects == null ? false : Collections.binarySearch(projects, project, ProjectImpl.COMPARATOR) >= 0;
    }

    public Iterable<Entity> getPermittedProjectCustomFields(Entity user, Security.CustomFieldsAccess access) {
        this.checkCacheCreated();
        return this.userPermissionsCache.getPermittedProjectCustomFields(user, access);
    }

    public Iterable<Entity> getPermittedProjectCustomFieldPrototypes(Entity user, Security.CustomFieldsAccess access) {
        this.checkCacheCreated();
        return this.userPermissionsCache.getPermittedProjectCustomFieldPrototypes(user, access);
    }

    public Iterable<Entity> getPermittedProjectCustomFields(Entity user, EntityId bundleId, Security.CustomFieldsAccess access) {
        this.checkCacheCreated();
        return this.userPermissionsCache.getPermittedProjectCustomFields(user, bundleId, access);
    }

    public Iterable<Entity> getPermittedProjectCustomFields(Entity user, Entity bundle, Security.CustomFieldsAccess access) {
        return this.getPermittedProjectCustomFields(user, bundle.getId(), access);
    }

    public Iterable<Entity> getPermittedProjectCustomFields(Entity user, Security.CustomFieldsAccess access, Entity prototype) {
        this.checkCacheCreated();
        return this.userPermissionsCache.getPermittedProjectCustomFields(user, access, prototype);
    }

    public Iterable<Entity> getPermittedProjectCustomFieldPrototypes(Entity user, Entity bundle, Security.CustomFieldsAccess access) {
        this.checkCacheCreated();
        return this.userPermissionsCache.getPermittedProjectCustomFieldPrototypes(user, bundle, access);
    }

    public Map<Entity, Operation> getProjectsToWriteOperations(Entity user, Entity prototype) {
        this.checkCacheCreated();
        return this.userPermissionsCache.getProjectToWriteOperation(user, prototype);
    }

    public Map<Entity, Operation> getProjectsToReadOperations(Entity user, Entity prototype) {
        this.checkCacheCreated();
        return this.userPermissionsCache.getProjectToReadOperation(user, prototype);
    }

    public boolean hasRole(Entity user, String roleName) {
        this.checkCacheCreated();
        return !QueryOperations.isEmpty((Iterable)QueryOperations.query(this.userPermissionsCache.getUserRoles(user), (String)"UserRole", (NodeBase)new LinksEqualDecorator("role", (NodeBase)new PropertyEqual("name", (Comparable)((Object)roleName)), "Role")));
    }

    public boolean hasRole(Entity user, Entity project, String roleName) {
        this.checkCacheCreated();
        Entity role = QueryOperations.getFirst(this.userPermissionsCache.getUserRoles(user));
        return !EntityOperations.equals((Entity)role, null) && (QueryOperations.isEmpty((Iterable)AssociationSemantics.getToMany((Entity)role, (String)"projects")) || QueryOperations.contains((Iterable)AssociationSemantics.getToMany((Entity)role, (String)"projects"), (Entity)project));
    }

    public void invalidate() {
        if (this.userPermissionsCache != null) {
            this.userPermissionsCache.invalidate();
        }
    }

    public void checkValid() {
        if (this.userPermissionsCache != null) {
            this.userPermissionsCache.checkValid();
        }
    }

    public String getImplementationName(boolean localized) {
        if (localized) {
            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("YouTrackSecurityImpl.Local_YouTrack_permission_management", new Object[0]);
        }
        return "Local YouTrack permission management";
    }
}

