/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.persistent;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.BasePersistentClassImpl;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import jetbrains.charisma.date.SuitableTimezones;
import jetbrains.charisma.main.CharismaLicenseChecker;
import jetbrains.charisma.main.ConfigurationUtil;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.charisma.persistent.RefactoringDescriptorImpl;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.database.exceptions.ConstraintsValidationException;
import jetbrains.exodus.database.exceptions.DataIntegrityViolationException;
import jetbrains.exodus.database.exceptions.UserConstraintValidationException;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.baseLanguage.dates.runtime.CompareType;
import jetbrains.mps.baseLanguage.dates.runtime.DateTimeOperations;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internationalization.runtime.LocaleEntry;
import jetbrains.mps.internationalization.runtime.LocaleUtil;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.ring.license.LicenseFlag;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.txn._Txn;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import webr.framework.textBuilder.TBuilderContext;
import webr.framework.url.UrlUtil;

public class ApplicationMetaDataImpl
extends BasePersistentClassImpl {
    private static String __ENTITY_TYPE__ = "ApplicationMetaData";
    public static final int LOGO_MAX_WIDTH = 250;
    public static final int LOGO_MAX_HEIGHT = 80;
    private static final long A_27_DAYS_MILLIS = 2332800000L;
    private static final Log securityLog = LogFactory.getLog((String)"security");

    public void run() {
        DnqUtils.setPersistentClassInstance((String)__ENTITY_TYPE__, (BasePersistentClassImpl)this);
    }

    protected Entity _constructor(String _entityType_) {
        Entity entity = super._constructor(_entityType_);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"hideLicenseExpirationWarning", (Comparable)Boolean.valueOf(false), Boolean.class);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"serverLocale", (Comparable)((Object)LocaleUtil.DEFAULT_LOCALE.toString()), String.class);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"uuid", (Comparable)((Object)UUID.randomUUID().toString()), String.class);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"maxUploadFileSize", (Comparable)Integer.valueOf(0xA00000), Long.class);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"maxOrderedIssues", (Comparable)Integer.valueOf(500), Integer.class);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"maxExportItems", (Comparable)Integer.valueOf(500), Integer.class);
        return entity;
    }

    public void executeBeforeFlushTrigger(Entity entity) {
        String licenseError;
        super.executeBeforeFlushTrigger(entity);
        if (!ConfigurationUtil.isYoutrackHosted() && (EntityOperations.hasChanges((TransientEntity)((TransientEntity)entity), (String)"username") || EntityOperations.hasChanges((TransientEntity)((TransientEntity)entity), (String)"license")) && (licenseError = CharismaLicenseChecker.getLicenseError(PrimitiveAssociationSemantics.getBlobAsString((Entity)entity, (String)"username"), PrimitiveAssociationSemantics.getBlobAsString((Entity)entity, (String)"license"))) != null) {
            throw EntityOperations.isRemoved((Entity)entity) ? new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException(licenseError)) : new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException(licenseError, (Entity)((TransientEntity)entity)));
        }
        if (!EntityOperations.equals((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"logo"), null) && EntityOperations.hasChanges((TransientEntity)((TransientEntity)entity), (String)"logo") && CharismaLicenseChecker.checkFlag(LicenseFlag.CHANGE_LOGO_FORBIDDEN)) {
            throw EntityOperations.isRemoved((Entity)entity) ? new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("ApplicationMetaData.Can_t_change_logo_due_to_license_restrictions", new Object[0]))) : new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("ApplicationMetaData.Can_t_change_logo_due_to_license_restrictions", new Object[0]), (Entity)((TransientEntity)entity)));
        }
        if (EntityOperations.hasChanges((TransientEntity)((TransientEntity)entity), (String)"defaultTimeZoneId")) {
            securityLog.info((Object)("Default timezone has been changed from " + (String)PrimitiveAssociationSemantics.getOldValue((TransientEntity)((TransientEntity)entity), (String)"defaultTimeZoneId", String.class, null) + " to " + (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"defaultTimeZoneId", String.class, null)));
        }
    }

    public boolean refactoringApplied(String uid, Entity entity) {
        return !QueryOperations.isEmpty((Iterable)QueryOperations.query(null, (String)"RefactoringDescriptor", (NodeBase)new PropertyEqual("uid", (Comparable)((Object)uid))));
    }

    public void saveAsAppliedRefactoring(String uid, Entity entity) {
        if (!((ApplicationMetaDataImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"ApplicationMetaData")).refactoringApplied(uid, entity)) {
            RefactoringDescriptorImpl.constructor(uid);
        }
    }

    public void setLocale(Locale locale, Entity entity) {
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"serverLocale", (Comparable)((Object)locale.toString()), String.class);
    }

    private boolean licenseFreeUpgradeEnd(Entity entity) {
        return CharismaLicenseChecker.getLicenseFreeUpdateEnd() - 2332800000L < System.currentTimeMillis();
    }

    private boolean licenseWillExpireSoon(Entity entity) {
        return CharismaLicenseChecker.getLicenseExpirationTime() - 2332800000L < System.currentTimeMillis();
    }

    List<String> collectExpirationMessages(Entity entity) {
        IListSequence expireMessages = ListSequence.fromList(new ArrayList());
        if (!((Boolean)PrimitiveAssociationSemantics.get((Entity)entity, (String)"hideLicenseExpirationWarning", Boolean.class, null)).booleanValue()) {
            if (!ConfigurationUtil.isYoutrackHosted() && ((ApplicationMetaDataImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"ApplicationMetaData")).licenseFreeUpgradeEnd(entity)) {
                Long licenseFreeUpdateEnd = CharismaLicenseChecker.getLicenseFreeUpdateEnd();
                if (DateTimeOperations.compare((Long)licenseFreeUpdateEnd, (CompareType)CompareType.LT, (Long)System.currentTimeMillis(), (DateTimeFieldType)DateTimeFieldType.millisOfSecond())) {
                    expireMessages.add(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("ApplicationMetaData._The_free_upgrade_period_for_this_YouTrack_instance_already_expired", new Object[0]));
                } else {
                    expireMessages.add(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("ApplicationMetaData._The_free_upgrade_period_for_this_YouTrack_instance_will_expire_on_{0}", new Object[]{DateTimeOperations.print((DateTime)DateTimeOperations.convert((Long)licenseFreeUpdateEnd, (DateTimeZone)((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).getGeneralProfile().getTimeZone()), (DateTimeFormatter)DateTimeFormat.fullDateTime(), (Locale)((Localizer)ServiceLocator.getBean((String)"localizer")).getLocale())}));
                }
            }
            if (this.licenseWillExpireSoon(entity)) {
                ListSequence.fromList((List)expireMessages).addElement((Object)((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("ApplicationMetaData._Your_license_for_this_YouTrack_instance_will_expire_on_{0}", new Object[]{DateTimeOperations.print((DateTime)DateTimeOperations.convert((Long)CharismaLicenseChecker.getLicenseExpirationTime(), (DateTimeZone)((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).getGeneralProfile().getTimeZone()), (DateTimeFormatter)DateTimeFormat.fullDateTime(), (Locale)((Localizer)ServiceLocator.getBean((String)"localizer")).getLocale())}));
            }
        }
        return expireMessages;
    }

    public String getLogoUrl(Entity entity) {
        String url = UrlUtil.getClasspathResourceUri((String)"/smartui/img/default/youtrack-sign.svg", (boolean)true);
        if (!EntityOperations.equals((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"logo"), null) && !CharismaLicenseChecker.checkFlag(LicenseFlag.CHANGE_LOGO_FORBIDDEN)) {
            TBuilderContext builderContext = new TBuilderContext();
            url = UrlUtil.getPersistentFileUrl((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"logo"), null, null, (Boolean)true);
        }
        return url;
    }

    public boolean containsLogo(Entity entity) {
        return !EntityOperations.equals((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"logo"), null);
    }

    public String getDefaultTimeZoneId(Entity entity) {
        return ApplicationMetaDataImpl.isEmpty_p38qlr_a0a0a11((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"defaultTimeZoneId", String.class, null)) ? ((SuitableTimezones)ServiceLocator.getBean((String)"suitableTimezones")).getDefault().getID() : (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"defaultTimeZoneId", String.class, null);
    }

    public long getCustomFieldNumber(Entity entity) {
        return PrimitiveAssociationSemantics.incSequenceValue((TransientStoreSession)DnqUtils.getCurrentTransientSession(), (Entity)entity, (String)"nextCFNumberGenerator");
    }

    public long getNextLinkId(Entity entity) {
        return PrimitiveAssociationSemantics.incSequenceValue((TransientStoreSession)DnqUtils.getCurrentTransientSession(), (Entity)entity, (String)"linkId");
    }

    public DateTimeZone getTimeZone(final Entity entity) {
        return (DateTimeZone)_Txn.eval((_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<DateTimeZone>(){

            public DateTimeZone invoke() {
                return DateTimeZone.forID((String)((ApplicationMetaDataImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"ApplicationMetaData")).getDefaultTimeZoneId(entity));
            }
        });
    }

    public String getLocaleInternalIdentifier(Entity entity) {
        return (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"serverLocale", String.class, null);
    }

    public Locale getLocaleData(Entity entity) {
        LocaleEntry localeEntry;
        String serverLocale = (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"serverLocale", String.class, null);
        if (serverLocale == null) {
            PrimitiveAssociationSemantics.set((Entity)entity, (String)"serverLocale", (Comparable)((Object)LocaleUtil.DEFAULT_LOCALE.toString()), String.class);
            serverLocale = (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"serverLocale", String.class, null);
        }
        if ((localeEntry = ((Localizer)ServiceLocator.getBean((String)"localizer")).byLocaleId(serverLocale)) == null) {
            throw new IllegalStateException("Cannot find your custom locale " + serverLocale + " Probably you've lost the parameter 'jetbrains.mps.webr.i18n.custom-translations'");
        }
        return localeEntry.getLocale();
    }

    public static Entity constructor() {
        return ((ApplicationMetaDataImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(__ENTITY_TYPE__);
    }

    public static Locale getLocale() {
        if (ServiceLocator.beanDefined((String)"applicationMetaData")) {
            return (Locale)_Txn.eval((_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<Locale>(){

                public Locale invoke() {
                    return ((ApplicationMetaDataImpl)DnqUtils.getPersistentClassInstance((Entity)((Entity)ServiceLocator.getBean((String)"applicationMetaData")), (String)"ApplicationMetaData")).getLocaleData((Entity)ServiceLocator.getBean((String)"applicationMetaData"));
                }
            });
        }
        return LocaleUtil.DEFAULT_LOCALE;
    }

    public static boolean isEmpty_p38qlr_a0a0a11(String str) {
        return str == null || str.length() == 0;
    }
}

